/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.ellabook.EllaBookViewer;
import cn.ellabook.EllaBookViewerHelper;
import cn.ellabook.ReaderActivity;
import cn.ellabook.ReaderAudioHelper;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.storage.SPSaveManager;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.IReaderController;
import com.ellabook.project.ellareader.ListenableFrameAnimation;
import com.ellabook.project.ellareader.OnDebounceListener;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ReaderModule;
import com.ellabook.project.ellareader.TryReadController;
import com.ellabook.project.ellareader.bean.HttpWordDetails;
import com.ellabook.project.ellareader.bean.StoneNum;
import com.ellabook.project.ellareader.bean.StoneResult;
import com.ellabook.project.ellareader.biz.BizReader;
import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.ui.read.BookReader;
import com.ellabook.project.ellareader.ui.read.CourseGuideFragment;
import com.ellabook.project.ellareader.ui.read.CourseSecondGuideFragment;
import com.ellabook.project.ellareader.ui.read.MediaPlayerUtil;
import com.ellabook.project.ellareader.ui.read.MenuFragment;
import com.ellabook.project.ellareader.ui.read.ResultBean;
import com.ellabook.project.ellareader.ui.read.SelfStudyGuideFragment;
import com.ellabook.project.ellareader.ui.read.SplitedSentence;
import com.ellabook.project.ellareader.ui.read.SplitedWordDialogFragment;
import com.google.gson.Gson;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.trello.rxlifecycle2.RxLifecycle;
import com.trello.rxlifecycle2.android.ActivityEvent;
import ellax.log.Logger;
import io.reactivex.subjects.BehaviorSubject;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class BookReaderActivity
extends ReaderActivity {
    public static final String TAG = "BookReaderActivity.TAG";
    private final BehaviorSubject<ActivityEvent> lifecycleSubject = BehaviorSubject.create();
    public static final int REQUEST_COURSE_PASS_CODE = 1027;
    private Map<String, String> wordsMap = new HashMap<String, String>();
    private int passNumber = 0;
    public static final int RESULT_FINISH = 1000;
    public static final int RESULT_GO_BACK_FIST_PAGE = 1001;
    private boolean reachedLastPage = false;
    private View controlView;
    ImageView menu;
    View left;
    View right;
    View vLogo;
    TextView tvDiamond;
    ImageView ivDiamond;
    ImageView ivDiamondAnimation;
    View vDiamond;
    Button btnDebugLastPage;
    MenuFragment menuFragment;
    private boolean isTryRead;
    private boolean isFinished;
    private BookContainer bookContainer;
    private long mapId;
    private SparseIntArray stoneArray = new SparseIntArray();
    private HashMap<String, Integer> localStoneMap = new HashMap();
    private Handler handler;
    int fetchedStoneNum = 0;
    long readStartTime = 0L;
    ArrayList<String> mReadStartEnds = new ArrayList();
    ArrayList<String> mReadLastPageStartEnds = new ArrayList();
    private boolean shouldTryPostCoursePassed = false;
    int maxPageNum = 0;
    int maxPageTotalNum = 0;
    private static Set<PreferenceManager.OnActivityResultListener> onActivityResultListeners = new LinkedHashSet<PreferenceManager.OnActivityResultListener>();
    private boolean mStopController = false;
    public boolean guided = false;
    public static final String GROUPID = "groupid";
    public static final String PAGEID = "pageid";
    public static final String QUESTIONID = "questionid";
    public static final String RESULT = "result";
    public static final String RESULT_PERFECT = "perfect";
    public static final String RESULT_GREAT = "great";
    public static final String RESULT_GOOD = "good";
    public static final String[] RESULT_VALUES = new String[]{"good", "great", "perfect"};
    ListenableFrameAnimation diamondAnimation;
    private int autoClickPage = 0;
    private boolean mAutoNext = false;
    private Runnable mAutoClickRunnable = new AutoClickRunnable();
    List<SoftReference<Fragment>> softReferenceList = new ArrayList<SoftReference<Fragment>>();
    private Set<Integer> readedPages = new HashSet<Integer>();
    boolean isResumed = false;

    @Override
    public void finish() {
        super.finish();
        Log.i((String)TAG, (String)"finish");
    }

    public static void add(PreferenceManager.OnActivityResultListener listener) {
        onActivityResultListeners.add(listener);
    }

    public String getBookType() {
        try {
            if (this.bookContainer == null) {
                this.bookContainer = (BookContainer)((Object)this.getIntent().getSerializableExtra("bookContainer"));
            }
            return this.bookContainer.getBookType();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void injectView() {
        this.menu = (ImageView)this.findViewById(R.id.ellaReadExit);
        this.left = this.findViewById(R.id.ellaReadLeft);
        this.right = this.findViewById(R.id.ellaReadRight);
        this.vLogo = this.findViewById(R.id.vLogo);
        this.tvDiamond = (TextView)this.findViewById(R.id.tvDiamond);
        this.vDiamond = this.findViewById(R.id.vDiamondWrapper);
        this.ivDiamond = (ImageView)this.findViewById(R.id.ivDiamond);
        this.ivDiamondAnimation = (ImageView)this.findViewById(R.id.ivDiamondAnimation);
        this.vLogo.setVisibility(ReaderModule.showCopyRight() ? 0 : 8);
        this.btnDebugLastPage = (Button)this.findViewById(R.id.btnDebugLastPage);
        this.findViewById(R.id.ellaReadLeft).setOnClickListener((View.OnClickListener)new OnDebounceListener(new View.OnClickListener(){

            public void onClick(View v) {
                BookReaderActivity.this.onLeftClick();
            }
        }));
        this.findViewById(R.id.ellaReadRight).setOnClickListener((View.OnClickListener)new OnDebounceListener(new View.OnClickListener(){

            public void onClick(View v) {
                BookReaderActivity.this.onRightClick(false);
            }
        }));
        this.findViewById(R.id.ellaReadExit).setOnClickListener((View.OnClickListener)new OnDebounceListener(new View.OnClickListener(){

            public void onClick(View v) {
                BookReaderActivity.this.onMenuClick();
            }
        }));
        this.findViewById(R.id.btnDebugLastPage).setOnClickListener((View.OnClickListener)new OnDebounceListener(new View.OnClickListener(){

            public void onClick(View v) {
                EllaBookViewer.setBookPlayMode((byte)4);
                BookReaderActivity.this.onLastClick();
            }
        }));
        this.findViewById(R.id.vDiamondWrapper).setOnClickListener((View.OnClickListener)new OnDebounceListener(new View.OnClickListener(){

            public void onClick(View v) {
                BookReaderActivity.this.onDiamondTvClick();
            }
        }));
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT >= 28) {
            Window window = this.getWindow();
            WindowManager.LayoutParams attributes = window.getAttributes();
            attributes.layoutInDisplayCutoutMode = 1;
            window.setAttributes(attributes);
        }
        super.onCreate(savedInstanceState);
        EllaBookViewer.initLib((Context)this);
        EllaBookViewer.initJNI((Context)this, (AssetManager)this.getAssets());
        EllaBookViewer.setUserDataInfomation((String)"");
        this.readStartTime = System.currentTimeMillis();
        this.injectView();
        this.bookContainer = (BookContainer)((Object)this.getIntent().getSerializableExtra("bookContainer"));
        this.isTryRead = this.getIntent().getBooleanExtra("isTryRead", false);
        this.isFinished = this.getIntent().getBooleanExtra("isFinished", false);
        this.mapId = this.getIntent().getLongExtra("mapId", 0L);
        this.passNumber = this.getIntent().getIntExtra("passNumber", 0);
        if ("LESSON".equals(this.bookContainer.getBookType())) {
            this.tvDiamond.setText((CharSequence)("0/" + this.bookContainer.getDiamondNum()));
            this.getStoneNums();
        } else {
            this.menu.setBackgroundResource(R.drawable.pass_en_book_btn_exit);
        }
        this.btnDebugLastPage.setVisibility(ReaderModule.isDebugable() ? 0 : 8);
        int volume = UserInfoProvider.getReaderVolume();
        if (volume < 0 || volume > 100) {
            volume = 100;
        }
        EllaBookViewer.setVolume((int)volume);
    }

    protected void onStop() {
        super.onStop();
        this.stopMachineRead();
    }

    private void stopMachineRead() {
        MediaPlayerUtil.stop();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("fetchedStoneNum", this.fetchedStoneNum);
        outState.putBoolean("isFinished", this.isFinished);
        outState.putBoolean("isTryRead", this.isTryRead);
        outState.putBoolean("mAutoNext", this.mAutoNext);
        outState.putStringArrayList("mReadStartEnds", this.mReadStartEnds);
        outState.putStringArrayList("mReadLastPageStartEnds", this.mReadLastPageStartEnds);
        Log.i((String)TAG, (String)"onSaveInstanceState ");
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.isFinished = savedInstanceState.getBoolean("isFinished", false);
        this.isTryRead = savedInstanceState.getBoolean("isTryRead", this.isTryRead);
        this.mAutoNext = savedInstanceState.getBoolean("mAutoNext", false);
        this.fetchedStoneNum = savedInstanceState.getInt("fetchedStoneNum", 0);
        this.mReadStartEnds = savedInstanceState.getStringArrayList("mReadStartEnds");
        this.mReadLastPageStartEnds = savedInstanceState.getStringArrayList("mReadLastPageStartEnds");
        Log.i((String)TAG, (String)"onRestoreInstanceState ");
    }

    @Override
    protected View createReaderControlView() {
        this.controlView = View.inflate((Context)this, (int)R.layout.ellabook_read_controll, null);
        return this.controlView;
    }

    void onLeftClick() {
        if (this.mStopController) {
            return;
        }
        if (!EllaBookViewer.isMenuEnable()) {
            return;
        }
        if (this.getReaderControler().getCurrentPage() == 1) {
            return;
        }
        this.getReaderControler().pageUp();
    }

    void onRightClick(boolean fromAuto) {
        if (!fromAuto && this.mStopController) {
            return;
        }
        if (!fromAuto && EllaBookViewer.getCurrentPage() >= 2 && !EllaBookViewer.isLastPage() && "LESSON".equals(this.bookContainer.getBookType()) && EllaBookViewer.getBookPlayMode() == 5 && !this.isPagePassed(EllaBookViewer.getCurrentPage()) && UserInfoProvider.isGuideAvailable((String)("firstLearnToReadFinish_" + this.bookContainer.getBookCode()), (boolean)true)) {
            EllaBookViewerHelper.pause();
            ToastUtils.showToast((String)"\u672c\u9875\u5168\u90e8\u63d0\u95ee\u8fd8\u6ca1\u7ed3\u675f\uff0c\u6682\u65f6\u4e0d\u80fd\u7ffb\u9875\u54e6");
            this.mStopController = true;
            this.playGuideVoice(R.raw.learn_to_read_not_finished, new AudioPlayer.OnAudioPlayDone(){

                public void onAudioPlayDone() {
                    BookReaderActivity.this.mStopController = false;
                    EllaBookViewerHelper.resume();
                }
            });
            return;
        }
        this.mAutoNext = false;
        this.controlView.removeCallbacks(this.mAutoClickRunnable);
        if (this.diamondAnimation != null && this.diamondAnimation.isRunning()) {
            this.diamondAnimation.stop();
            this.ivDiamondAnimation.setVisibility(8);
            this.ivDiamond.setVisibility(0);
        }
        if (!EllaBookViewer.isMenuEnable()) {
            return;
        }
        if (this.isTryRead && this.getReaderControler().getCurrentPage() >= this.bookContainer.getTryReadPage()) {
            if (ReaderModule.getTryReadController() != null) {
                ReaderModule.getTryReadController().onTryReadDone(this, this.bookContainer, new TryReadController.onDoneListener(){

                    @Override
                    public void onResult(boolean done) {
                        if (done) {
                            BookReaderActivity.this.isTryRead = false;
                        }
                    }
                });
            } else {
                ToastUtils.showCenterToast((String)("\u8bd5\u8bfb\u6a21\u5f0f\u53ea\u80fd\u9605\u8bfb\u524d" + this.bookContainer.getTryReadPage() + "\u9875\uff0c\u8bf7\u8d2d\u4e70\u540e\u7ee7\u7eed\u9605\u8bfb"));
            }
            return;
        }
        if (EllaBookViewer.isLastPage()) {
            UserInfoProvider.setGuide((String)("firstLearnToReadFinish_" + this.bookContainer.getBookCode()), (boolean)false);
            this.goNext();
            return;
        }
        this.getReaderControler().pageDown();
    }

    public void goNext() {
        if ("LESSON".equals(this.bookContainer.getBookType())) {
            this.updateReadRecordForMission();
        }
        ArrayList<String> toEndPassReadStartEnds = new ArrayList<String>(this.mReadLastPageStartEnds);
        toEndPassReadStartEnds.add(String.valueOf(System.currentTimeMillis()));
        Log.i((String)TAG, (String)(" go pass " + toEndPassReadStartEnds));
        ReaderModule.getReaderController().onBookReadPassed(this.bookContainer.getPicBookCode(), this.bookContainer.getBookType(), this.bookContainer.getId(), this.mapId, this.bookContainer.getBookCover(), (HashMap)EllaBookViewer.getQuestionQuantity(), (Activity)this, 1027, toEndPassReadStartEnds, this.fetchedStoneNum, new IReaderController.AnalysisFinishCallback(){

            @Override
            public void isAnalysisFinish(boolean isFinish) {
                if (isFinish) {
                    BookReaderActivity.this.isFinished = true;
                }
            }
        });
        this.fetchedStoneNum = 0;
        this.mReadLastPageStartEnds.clear();
    }

    public BookContainer getBookContainer() {
        return this.bookContainer;
    }

    void onMenuClick() {
        if (this.mStopController) {
            return;
        }
        if ("COURSE".equals(this.bookContainer.getBookType())) {
            Logger.record((String)"en_read_exit");
            this.getReaderControler().endBookViewer();
        } else {
            Logger.record((String)"en_read_buttons");
            if (this.menuFragment == null) {
                this.menuFragment = MenuFragment.get(this.bookContainer.getId(), () -> this.getScoreTotalDiamond() >= this.passNumber);
            }
            this.menuFragment.show(this.getFragmentManager(), R.id.llBookViewControll, "menu", this.getScoreTotalDiamond() >= this.passNumber, "LESSON".equals(this.bookContainer.getBookType()));
            EllaBookViewerHelper.pause();
            this.stopMachineRead();
        }
    }

    void onLastClick() {
        this.getReaderControler().gotoPage(this.getReaderControler().getBookPages());
    }

    void onDiamondTvClick() {
        if (this.mStopController) {
            return;
        }
        Logger.record((String)"en_class_stone");
        EllaBookViewerHelper.pause();
        BookReader.showPowerStone(this.getFragmentManager(), this.bookContainer.getPassNum(), this.getAllCanScore(), this.bookContainer.getId(), this.mapId, this.bookContainer.getBookCover(), (HashMap)EllaBookViewer.getQuestionQuantity(), !this.isFinished, false);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.reachedLastPage) {
            Logger.record((String)"en_read_complete");
        }
    }

    @Override
    public void onViewerNotice2(int type) {
        switch (type) {
            case 5: {
                ReaderAudioHelper.getInstance().releaseAudio();
                break;
            }
            case 6: {
                ReaderAudioHelper.getInstance().requestAudio((Context)this);
                break;
            }
            case 0: {
                if ("LESSON".equals(this.bookContainer.getBookType())) {
                    if (EllaBookViewer.getBookPlayMode() != 5) {
                        EllaBookViewer.setBookPlayMode((byte)5);
                    }
                    EllaBookViewer.setEvaluatingType((int)1);
                    int questionNum = 0;
                    Map map = EllaBookViewer.getQuestionQuantity();
                    if (map != null && map.size() > 0) {
                        for (Map.Entry entry : map.entrySet()) {
                            if (entry == null || entry.getValue() == null) continue;
                            questionNum += ((Integer)entry.getValue()).intValue();
                        }
                    }
                    if (questionNum <= 0) break;
                    BizReader.getInstance().uploadCourseStoneNum(null, this.bookContainer.getBookCode(), questionNum * 3, null);
                    break;
                }
                if (EllaBookViewer.getBookPlayMode() != 4) {
                    EllaBookViewer.setBookPlayMode((byte)4);
                }
                EllaBookViewer.setEvaluatingType((int)1);
                break;
            }
            case 10: {
                break;
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            super.onActivityResult(requestCode, resultCode, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (requestCode == 1027 && resultCode == -1) {
            int currentPage;
            this.getReaderControler().gotoPage(1);
            Map map = EllaBookViewer.getExercisePages();
            if (map != null) {
                Log.v((String)"reader_exercisePage", (String)map.toString());
            }
            if (map.containsKey(currentPage = 1) && map.get(currentPage) != null && !((Boolean)map.get(currentPage)).booleanValue()) {
                if (EllaBookViewer.getCurrentPage() < 2 || !SelfStudyGuideFragment.checkShowGuide(this)) {
                    ToastUtils.showCenterToast((String)"\u5df2\u8fdb\u5165Read to learn\u6a21\u5f0f\uff0c\u70b9\u51fb\u6587\u672c\u5185\u5bb9\u53ef\u67e5\u770b\u7ffb\u8bd1");
                    EllaBookViewer.setBookPlayMode((byte)4);
                    EllaBookViewerHelper.resume();
                }
            } else {
                ToastUtils.showCenterToast((String)"\u5f53\u524d\u9875\u9762\u6682\u65f6\u4e0d\u652f\u6301\u81ea\u5b66\u6a21\u5f0f\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9875\u9762\u8fdb\u5165\u81ea\u5b66\u6a21\u5f0f");
            }
        } else if (requestCode == 1027 && resultCode == 1001) {
            this.getReaderControler().gotoPage(1);
        } else if (requestCode == 1027 && resultCode == 1000) {
            EllaBookViewer.endBookViewer();
        }
        try {
            Iterator<PreferenceManager.OnActivityResultListener> listenerIterator = onActivityResultListeners.iterator();
            while (listenerIterator.hasNext()) {
                boolean result = listenerIterator.next().onActivityResult(requestCode, resultCode, data);
                if (!result) continue;
                listenerIterator.remove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void isViewerReady2(boolean var1) {
        super.isViewerReady2(var1);
        this.maxPageNum = Math.max(this.maxPageNum, EllaBookViewer.getCurrentPage());
        this.maxPageTotalNum = Math.max(this.maxPageTotalNum, EllaBookViewer.getBookPages());
        this.left.setVisibility(var1 && this.getReaderControler().getCurrentPage() != 1 ? 0 : 8);
        this.controlView.setVisibility(var1 ? 0 : 8);
        if (var1) {
            if (ReaderModule.showCopyRight() && this.getReaderControler().getCurrentPage() == 1) {
                this.vLogo.setVisibility(0);
                this.vDiamond.setVisibility(4);
            } else {
                this.vLogo.setVisibility(8);
                if (!"LESSON".equals(this.bookContainer.getBookType())) {
                    this.vDiamond.setVisibility(4);
                } else {
                    this.vDiamond.setVisibility(0);
                }
            }
            if ("LESSON".equals(this.bookContainer.getBookType())) {
                if (EllaBookViewer.getBookPlayMode() == 4 && this.getReaderControler().getCurrentPage() >= 2) {
                    SelfStudyGuideFragment.checkShowGuide(this);
                } else if (!this.guided && this.getReaderControler().getCurrentPage() == 2) {
                    if (!CourseGuideFragment.checkShowGuide(this, this.vDiamond.getWidth()) && this.isFinished && EllaBookViewer.getBookPlayMode() == 5) {
                        CourseSecondGuideFragment.checkShowGuide(this, this.vDiamond.getWidth());
                    }
                    this.guided = true;
                }
            }
            this.saveReadRecord();
        }
        if (var1 && EllaBookViewer.isLastPage()) {
            this.reachedLastPage = true;
        }
        if (var1 && EllaBookViewer.isLastPage() && !ReaderModule.getReaderController().canDoneWith(this.bookContainer.getPicBookCode(), this.bookContainer.getBookType(), EllaBookViewer.getBookPlayMode())) {
            this.right.setVisibility(4);
            if ("LESSON".equals(this.bookContainer.getBookType()) && EllaBookViewer.getBookPlayMode() == 4) {
                this.showSelfStudyDone();
            }
        } else if (this.right.getVisibility() != 0) {
            this.right.setVisibility(0);
        }
    }

    private void showSelfStudyDone() {
        ArrayList<String> toEndPassReadStartEnds = new ArrayList<String>(this.mReadLastPageStartEnds);
        toEndPassReadStartEnds.add(String.valueOf(System.currentTimeMillis()));
        Log.i((String)TAG, (String)(" go pass " + toEndPassReadStartEnds));
        BookReader.onSelfStudyDone(this.getFragmentManager(), R.id.llBookViewControll, "selfStudy", this.bookContainer.getPassNum() <= this.getScoreTotalDiamond(), this.mapId, this.bookContainer.getId(), toEndPassReadStartEnds);
        this.mReadLastPageStartEnds.clear();
    }

    private void saveReadRecord() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        this.handler.postDelayed(() -> {
            if (this.getReaderControler().getCurrentPage() >= this.getReaderControler().getBookPages()) {
                UserInfoProvider.putUserReadPage((String)this.bookContainer.getBookCode(), (int)-1);
            } else {
                UserInfoProvider.putUserReadPage((String)this.bookContainer.getBookCode(), (int)this.getReaderControler().getCurrentPage());
            }
        }, 500L);
    }

    @Override
    public void onClassModeResult2(String s) {
        this.uploadClassResult(s);
    }

    public boolean isCurrentQuestionRight(String s) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            try {
                JSONObject jsonObject = new JSONObject(s);
                String groupId = this.getJsonString(jsonObject, GROUPID);
                String pageid = this.getJsonString(jsonObject, PAGEID);
                String questionid = this.getJsonString(jsonObject, QUESTIONID);
                String result = this.getJsonString(jsonObject, RESULT);
                String key = "user_" + UserInfoProvider.getUserId() + "book_" + this.bookContainer.getBookCode() + groupId + "_" + pageid + "_" + questionid;
                String lastValue = SPSaveManager.getInstance().getInfo(key);
                if (this.findValueIndex(result, RESULT_VALUES) > this.findValueIndex(lastValue, RESULT_VALUES)) {
                    SPSaveManager.getInstance().saveInfo(key, result);
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public int findValueIndex(String temp, String[] values) {
        if (temp == null || values == null || values.length == 0) {
            return -1;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!TextUtils.equals((CharSequence)temp, (CharSequence)values[i])) continue;
            return i;
        }
        return -1;
    }

    public String getJsonString(JSONObject jsonObject, String key) {
        try {
            if (jsonObject.has(key)) {
                return jsonObject.opt(key).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void onViewerReadPermissionNotice(int i, String s) {
    }

    public void onStateCodeNotice(int i) {
    }

    public void bookPageButtonVisible(boolean b) {
    }

    @Override
    public void onClassModeResult(String[] results) {
        super.onClassModeResult(results);
        boolean shouldShowPowerAnimation = false;
        if (results != null) {
            for (String s : results) {
                this.uploadClassResult(s);
                shouldShowPowerAnimation = shouldShowPowerAnimation || this.isCurrentQuestionRight(s);
            }
        }
        if (shouldShowPowerAnimation) {
            this.tvDiamond.post(this::showAnimationAndSound);
        }
    }

    private void showAnimationAndSound() {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play((Uri)Uri.parse((String)("android.resource://" + this.getPackageName() + "/" + R.raw.animation_voice)));
        }
        if (this.diamondAnimation == null) {
            int[] reses = new int[]{R.drawable.light_00000, R.drawable.light_00001, R.drawable.light_00002, R.drawable.light_00003, R.drawable.light_00004, R.drawable.light_00005, R.drawable.light_00006, R.drawable.light_00007, R.drawable.light_00008, R.drawable.light_00009, R.drawable.light_00010, R.drawable.light_00011};
            this.diamondAnimation = new ListenableFrameAnimation();
            this.diamondAnimation.setOnFrameAnimationListener(new ListenableFrameAnimation.OnFrameAnimationListener(){

                @Override
                public void onStart() {
                    BookReaderActivity.this.ivDiamond.setVisibility(4);
                    BookReaderActivity.this.ivDiamondAnimation.setVisibility(0);
                }

                @Override
                public void onEnd() {
                    BookReaderActivity.this.ivDiamondAnimation.setVisibility(8);
                    BookReaderActivity.this.ivDiamond.setVisibility(0);
                }
            });
            for (int res : reses) {
                this.diamondAnimation.addFrame(this.getResources().getDrawable(res), 1500 / reses.length);
            }
            this.ivDiamondAnimation.setImageDrawable((Drawable)this.diamondAnimation);
        }
        int animationSize = 360;
        int pngSize = 76;
        int pngImageSize = this.ivDiamond.getWidth();
        int pngImageCenterX = (int)(this.vDiamond.getX() + this.ivDiamond.getX() + (float)(this.ivDiamond.getWidth() / 2));
        int pngImageCenterY = (int)(this.vDiamond.getY() + this.ivDiamond.getY() + (float)(this.ivDiamond.getHeight() / 2));
        int animationImageSize = pngImageSize * animationSize / pngSize;
        int animationImageX = pngImageCenterX - animationImageSize / 2;
        int animationImageY = pngImageCenterY - animationImageSize / 2;
        RelativeLayout.LayoutParams relativeLayout = new RelativeLayout.LayoutParams(animationImageSize, animationImageSize);
        this.ivDiamondAnimation.setLayoutParams((ViewGroup.LayoutParams)relativeLayout);
        this.ivDiamondAnimation.setX((float)animationImageX);
        this.ivDiamondAnimation.setY((float)animationImageY);
        this.diamondAnimation.start();
    }

    private void uploadClassResult(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return;
        }
        ResultBean resultBean = (ResultBean)new Gson().fromJson(s, ResultBean.class);
        if (this.localStoneMap.containsKey(resultBean.getIdKey())) {
            int counts = this.localStoneMap.get(resultBean.getIdKey());
            if (counts < resultBean.getScoreDiamond()) {
                this.localStoneMap.put(resultBean.getIdKey(), resultBean.getScoreDiamond());
            }
        } else {
            this.localStoneMap.put(resultBean.getIdKey(), resultBean.getScoreDiamond());
        }
        final int currentPage = this.getReaderControler().getCurrentPage();
        BizReader.getInstance().uploadAnswerRecord(RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)ActivityEvent.PAUSE), this.bookContainer.getId(), this.getPageQuestionCounts(), s, new HttpServiceCallBack<StoneResult>(){

            public void onHttpServiceFinished(final StoneResult result) {
                BookReaderActivity.this.stoneArray.put(currentPage, result.stoneNum + BookReaderActivity.this.stoneArray.get(currentPage));
                BookReaderActivity.this.fetchedStoneNum += result.stoneNum;
                BookReaderActivity.this.showStoneNum();
                BookReaderActivity.this.tvDiamond.post(new Runnable(){

                    @Override
                    public void run() {
                        if (result.stoneNum > 0) {
                            int animationSize = 360;
                            int pngSize = 76;
                            int pngImageSize = BookReaderActivity.this.ivDiamond.getWidth();
                            int pngImageCenterX = (int)(BookReaderActivity.this.vDiamond.getX() + BookReaderActivity.this.ivDiamond.getX() + (float)(BookReaderActivity.this.ivDiamond.getWidth() / 2));
                            int pngImageCenterY = (int)(BookReaderActivity.this.vDiamond.getY() + BookReaderActivity.this.ivDiamond.getY() + (float)(BookReaderActivity.this.ivDiamond.getHeight() / 2));
                            int animationImageSize = pngImageSize * animationSize / pngSize;
                            int animationImageX = pngImageCenterX - animationImageSize / 2;
                            int animationImageY = pngImageCenterY - animationImageSize / 2;
                            RelativeLayout.LayoutParams relativeLayout = new RelativeLayout.LayoutParams(animationImageSize, animationImageSize);
                            BookReaderActivity.this.ivDiamondAnimation.setLayoutParams((ViewGroup.LayoutParams)relativeLayout);
                            BookReaderActivity.this.ivDiamondAnimation.setX((float)animationImageX);
                            BookReaderActivity.this.ivDiamondAnimation.setY((float)animationImageY);
                        }
                    }
                });
                if (BookReaderActivity.this.shouldTryPostCoursePassed && BookReaderActivity.this.getScoreTotalDiamond() >= BookReaderActivity.this.passNumber) {
                    ReaderModule.getReaderController().postBookPassed(BookReaderActivity.this.bookContainer.getBookCode(), BookReaderActivity.this.bookContainer.getBookType(), BookReaderActivity.this.bookContainer.getId());
                    BookReaderActivity.this.shouldTryPostCoursePassed = false;
                }
            }

            public void onHttpServiceError(int code, String msg) {
                ToastUtils.showToast((String)msg);
            }
        });
    }

    private int getScoreTotalDiamond() {
        int total = 0;
        for (int i = 0; i < this.stoneArray.size(); ++i) {
            total += this.stoneArray.valueAt(i);
        }
        return total;
    }

    @Override
    public void onClassModeEnd2() {
        this.autoClickPage = EllaBookViewer.getCurrentPage();
        this.mAutoNext = true;
        this.tryMarkPagePassed(this.autoClickPage);
        this.controlView.postDelayed(this.mAutoClickRunnable, 2000L);
    }

    public void cleanRunnable() {
        if (this.controlView != null) {
            this.controlView.removeCallbacks(this.mAutoClickRunnable);
        }
    }

    public void onAttachFragment(Fragment fragment) {
        super.onAttachFragment(fragment);
        this.softReferenceList.add(new SoftReference<Fragment>(fragment));
    }

    private boolean isAnyFragmentCovered() {
        for (SoftReference<Fragment> sf : this.softReferenceList) {
            Fragment fragment;
            if (sf == null || (fragment = sf.get()) == null || !fragment.isVisible()) continue;
            return true;
        }
        return false;
    }

    private void tryMarkPagePassed(int page) {
        this.readedPages.add(page);
    }

    private boolean isPagePassed(int page) {
        return this.isFinished || this.readedPages.contains(page) || this.stoneArray.get(page) != 0;
    }

    private int getPageScoreDiamond() {
        int total = 0;
        for (String key : this.localStoneMap.keySet()) {
            if (!key.startsWith(this.getReaderControler().getCurrentPage() + "_")) continue;
            total += this.localStoneMap.get(key).intValue();
        }
        return total;
    }

    private int getPageCanScoreDiamond() {
        return this.getPageQuestionCounts() * 3;
    }

    private int getPageQuestionCounts() {
        Map map = EllaBookViewer.getQuestionQuantity();
        if (map != null && map.containsKey(this.getReaderControler().getCurrentPage())) {
            return (Integer)map.get(this.getReaderControler().getCurrentPage());
        }
        return 0;
    }

    private int getAllCanScore() {
        int total = 0;
        Map map = EllaBookViewer.getQuestionQuantity();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            total += value * 3;
        }
        return total;
    }

    @Override
    public void onSubtitleSelect(Object[] vSubtitleSplitData) {
        EllaBookViewerHelper.pause();
        SplitedWordDialogFragment.show((Activity)this, SplitedSentence.toLocalListSentence(vSubtitleSplitData), 0, 0, "", this.bookContainer.getBookCode(), this.bookContainer.getMissionCode(), this.getReaderControler().getCurrentPage());
    }

    @Override
    public void onSubtitleDeacon(String s) {
        if (this.wordsMap.containsKey(s)) {
            MediaPlayerUtil.play(this.wordsMap.get(s));
        } else {
            this.getWordInfo(s);
        }
    }

    public void onControllDeaconPlay() {
        this.stopMachineRead();
    }

    public void onBookDownloadProgress(float v) {
    }

    public void onBookDownloadFinish() {
    }

    private void getWordInfo(final String word) {
        if (TextUtils.isEmpty((CharSequence)word)) {
            ToastUtils.showToast((int)R.string.select_word_error);
            return;
        }
        BizReader.getInstance().getWordDetails(RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)ActivityEvent.PAUSE), UserInfoProvider.getUserId(), word, this.bookContainer.getBookCode(), this.getReaderControler().getCurrentPage(), new HttpServiceCallBack<HttpWordDetails>(){

            public void onHttpServiceFinished(HttpWordDetails result) {
                if (!TextUtils.isEmpty((CharSequence)result.usSpeech)) {
                    BookReaderActivity.this.wordsMap.put(word, result.usSpeech);
                    MediaPlayerUtil.play(result.usSpeech);
                }
            }

            public void onHttpServiceError(int code, String msg) {
                ToastUtils.showToast((String)msg);
            }
        });
    }

    @Override
    public void onSubtitleSplit2(int segmentID, int sentenceID, Object[] vSubtitleSplitData, String soundFile) {
        if (!this.isVoiced("welcome_split_words")) {
            this.playGuideVoice(R.raw.welcome_split_words, null);
        }
        EllaBookViewerHelper.pause();
        SplitedWordDialogFragment.show((Activity)this, SplitedSentence.toLocalList(vSubtitleSplitData), segmentID, sentenceID, soundFile, this.bookContainer.getBookCode(), this.bookContainer.getMissionCode(), this.getReaderControler().getCurrentPage());
    }

    @Override
    public void onBookEnd2() {
        super.onBookEnd2();
    }

    @Override
    public void onMemoryOverflow2() {
        super.onMemoryOverflow2();
    }

    private void getStoneNums() {
        BizReader.getInstance().getStoneNums((LifecycleTransformer<List<StoneNum>>)RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)ActivityEvent.PAUSE), this.bookContainer.getId(), new HttpServiceCallBack<List<StoneNum>>(){

            public void onHttpServiceFinished(List<StoneNum> result) {
                if (result != null) {
                    for (StoneNum stoneNum : result) {
                        BookReaderActivity.this.stoneArray.put(stoneNum.pageNumber, stoneNum.stoneNum);
                    }
                    BookReaderActivity.this.showStoneNum();
                    if (BookReaderActivity.this.getScoreTotalDiamond() >= BookReaderActivity.this.passNumber) {
                        BookReaderActivity.this.shouldTryPostCoursePassed = false;
                    } else {
                        BookReaderActivity.this.shouldTryPostCoursePassed = true;
                    }
                }
            }

            public void onHttpServiceError(int code, String msg) {
                ToastUtils.showToast((String)msg);
                BookReaderActivity.this.shouldTryPostCoursePassed = false;
            }
        });
    }

    private void showStoneNum() {
        int getted = this.getScoreTotalDiamond();
        int bookTotal = this.bookContainer.getDiamondNum();
        this.tvDiamond.setText((CharSequence)(getted + "/" + Math.max(getted, bookTotal)));
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.readStartTime = System.currentTimeMillis();
        this.mReadStartEnds.add(String.valueOf(this.readStartTime));
        if (this.mReadLastPageStartEnds.size() == 1) {
            this.mReadLastPageStartEnds.clear();
        }
        this.mReadLastPageStartEnds.add(String.valueOf(this.readStartTime));
        Log.i((String)TAG, (String)("onResume " + this.mReadStartEnds));
        this.isResumed = true;
        if (this.mAutoNext) {
            this.controlView.removeCallbacks(this.mAutoClickRunnable);
            this.controlView.postDelayed(this.mAutoClickRunnable, 2000L);
        }
    }

    @Override
    protected void onPause() {
        if ("COURSE".equals(this.bookContainer.getBookType())) {
            this.updateReadRecordForEnBook();
        }
        if (!this.isFinishing()) {
            if (this.mReadStartEnds.size() % 2 == 1) {
                this.mReadStartEnds.add(String.valueOf(System.currentTimeMillis()));
            }
            if (this.mReadLastPageStartEnds.size() % 2 == 1) {
                this.mReadLastPageStartEnds.add(String.valueOf(System.currentTimeMillis()));
            }
        } else if ("LESSON".equals(this.bookContainer.getBookType())) {
            this.updateReadRecordForMission();
        }
        Log.i((String)TAG, (String)("onPause " + this.isFinishing() + "  " + this.mReadStartEnds));
        super.onPause();
        this.isResumed = false;
    }

    private void updateReadRecordForMission() {
        if (this.isResumed) {
            this.mReadStartEnds.add(String.valueOf(System.currentTimeMillis()));
            Log.i((String)TAG, (String)("upload record on resume " + this.mReadStartEnds.toString()));
        } else {
            Log.i((String)TAG, (String)("upload record  " + this.mReadStartEnds.toString()));
        }
        BizReader.getInstance().uploadReadInfoMission(null, this.bookContainer.getId(), this.bookContainer.getPicBookCode(), this.maxPageNum, this.maxPageTotalNum, new ArrayList<String>(this.mReadStartEnds), null);
        this.mReadStartEnds.clear();
    }

    private void updateReadRecordForEnBook() {
        BizReader.getInstance().uploadReadInfoEnBook(null, this.bookContainer.getPicBookCode(), this.maxPageNum, this.maxPageTotalNum, this.readStartTime, System.currentTimeMillis(), null);
        this.readStartTime = System.currentTimeMillis();
    }

    public boolean isVoiced(String voiceName) {
        if (UserInfoProvider.isGuideAvailable((String)voiceName, (boolean)false)) {
            return true;
        }
        UserInfoProvider.setGuide((String)voiceName, (boolean)true);
        return false;
    }

    public void playGuideVoice(int voiceId, AudioPlayer.OnAudioPlayDone onAudioPlayDone) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play((String)"default", (Uri)Uri.parse((String)("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId)), (boolean)true, (float)AudioPlayer.DEFAULT_VOLUMN, (AudioPlayer.OnAudioPlayDone)onAudioPlayDone);
        } else if (onAudioPlayDone != null) {
            onAudioPlayDone.onAudioPlayDone();
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.getReaderControler() != null) {
                this.getReaderControler().endBookViewer();
            }
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private class AutoClickRunnable
    implements Runnable {
        private AutoClickRunnable() {
        }

        @Override
        public void run() {
            if (BookReaderActivity.this.isResumed) {
                if (!BookReaderActivity.this.isAnyFragmentCovered()) {
                    if (BookReaderActivity.this.autoClickPage == EllaBookViewer.getCurrentPage()) {
                        BookReaderActivity.this.onRightClick(true);
                    }
                    BookReaderActivity.this.mAutoNext = false;
                } else {
                    BookReaderActivity.this.controlView.postDelayed(BookReaderActivity.this.mAutoClickRunnable, 2000L);
                }
            }
        }
    }
}

