/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.book.cache;

import android.content.Context;
import com.ellabook.project.base.log.EllaLog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;

public class Cache {
    private Context m_context;
    private Gson m_gson = new GsonBuilder().create();

    public static Cache getInstance() {
        return BCacheControlHolder.INSTANCE;
    }

    public void init(Context context) {
        this.m_context = context;
    }

    public void write(Object object, String path) {
        try {
            FileWriter writer = new FileWriter(path);
            if (object != null) {
                this.m_gson.toJson(object, (Appendable)writer);
                ((Writer)writer).close();
            }
        }
        catch (Exception e) {
            EllaLog.e((String)"201707121227", (String)e.toString());
        }
    }

    public void write(String object, String path) {
        try {
            FileWriter writer = new FileWriter(path);
            if (object != null) {
                writer.write(object);
                ((Writer)writer).close();
            }
        }
        catch (Exception e) {
            EllaLog.e((String)"201707121227", (String)e.toString());
        }
    }

    public <T> T readFileData4Gson(String path, Class<T> classOfT) {
        String res = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fin = new FileInputStream(file);
            int length = fin.available();
            byte[] buffer = new byte[length];
            fin.read(buffer);
            res = new String(buffer, "UTF-8");
            fin.close();
            return (T)this.m_gson.fromJson(res, classOfT);
        }
        catch (Exception e) {
            EllaLog.e((String)"201709121132", (String)e.toString());
            return null;
        }
    }

    public String readFileData(String path) {
        String res = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fin = new FileInputStream(file);
            int length = fin.available();
            byte[] buffer = new byte[length];
            fin.read(buffer);
            res = new String(buffer, "UTF-8");
            fin.close();
        }
        catch (Exception e) {
            EllaLog.e((String)"201707121459", (String)e.toString());
        }
        return res;
    }

    public Gson getGson() {
        return this.m_gson;
    }

    public void setGson(Gson m_gson) {
        this.m_gson = m_gson;
    }

    public Context getContext() {
        return this.m_context;
    }

    public void setContext(Context m_context) {
        this.m_context = m_context;
    }

    private static class BCacheControlHolder {
        private static Cache INSTANCE = new Cache();

        private BCacheControlHolder() {
        }
    }
}

