package com.ellabook.project.ellareader.ui.read;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.ellabook.project.ellareader.R;
import com.google.android.material.internal.FlowLayout;

import java.util.List;

/**
 * Created by java on 2019/1/22.
 */

public class SplitedSentencesLayout extends FlowLayout {

    private OnWordSelectListener listener;

    private int segmentId;
    private int currentSentenceIndex;
    private List<SplitedSentence> splitedSentences;
    private int selectWordIndex = -1;

    public SplitedSentencesLayout(Context context) {
        super(context);
    }

    public SplitedSentencesLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SplitedSentencesLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public SplitedSentence getCurrentSplitedSentence() {
        return splitedSentences.get(currentSentenceIndex);
    }

    public void setOnWordSelectListener(OnWordSelectListener listener) {
        this.listener = listener;
    }

    public void setSplitedSentences(int segmentId, int currentSentenceIndex, List<SplitedSentence> splitedSentences) {
        this.segmentId = segmentId;
        this.currentSentenceIndex = currentSentenceIndex;
        this.splitedSentences = splitedSentences;
        updateView();
    }

    private void updateView() {
        if (splitedSentences == null)
            return;
        removeAllViews();
        int i = 0;
        for (SplitedSentence splitedSentence : splitedSentences) {
            for (String word : splitedSentence.wordList) {
                TextView child = (TextView) LayoutInflater.from(getContext()).inflate(R.layout.item_splited_word, this, false);
                addView(child);
                child.setOnClickListener(new ItemClickListener(i, splitedSentence, word));
                child.setText(word);
                i++;
            }
        }
        updateAllBackGround();
    }

    private void updateAllBackGround() {
        int i = 0;
        for (SplitedSentence splitedSentence : splitedSentences) {
            for (String word : splitedSentence.wordList) {
                updateItemBackGround((TextView) getChildAt(i), splitedSentence, word, i);
                i++;
            }
        }
    }

    private void updateItemBackGround(TextView textView, SplitedSentence splitedSentence, String word, int index) {
        if (!isCurrentSentence(splitedSentence)) {
            textView.setBackgroundResource(R.drawable.bg_word_grey);
            textView.setTextColor(Color.parseColor("#80FFFFFF"));
        } else if (SplitedSentence.isMark(word)) {
            textView.setBackgroundResource(R.drawable.bg_word_grey);
            textView.setTextColor(Color.parseColor("#80FFFFFF"));
        } else if (index == selectWordIndex) {
            textView.setBackgroundResource(R.drawable.bg_word_blue);
            textView.setTextColor(ContextCompat.getColor(getContext(), R.color.white));
        } else {
            textView.setBackgroundResource(R.drawable.bg_word_white);
            textView.setTextColor(Color.parseColor("#4A4A4A"));
        }
    }

    private boolean isCurrentSentence(SplitedSentence splitedSentence) {
        if (currentSentenceIndex < 0 || currentSentenceIndex >= splitedSentences.size()) {
            return false;
        }
        return splitedSentence == splitedSentences.get(currentSentenceIndex);
    }

    class ItemClickListener implements View.OnClickListener {
        private int index;
        private SplitedSentence splitedSentence;
        private String word;

        public ItemClickListener(int index, SplitedSentence splitedSentence, String word) {
            this.index = index;
            this.splitedSentence = splitedSentence;
            this.word = word;
        }

        @Override
        public void onClick(View v) {
            if (SplitedSentence.isMark(word))
                return;

            selectWordIndex = index;
            for (int i = 0; i < splitedSentences.size(); i++)
                if (splitedSentences.get(i) == splitedSentence) {
                    currentSentenceIndex = i;
                    break;
                }

            updateAllBackGround();
            if (listener != null)
                listener.onSelect(segmentId, currentSentenceIndex, word, splitedSentence);
        }
    }

    interface OnWordSelectListener {
        void onSelect(int segmentId, int currentSentenceIndex, String word, SplitedSentence splitedSentence);
    }

}
