package com.ellabook.project.ellareader.ui.read;

import android.app.Activity;
import android.app.Fragment;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ellabook.project.ellareader.R;

public class ClassEndFragment extends Fragment {

    ImageView ivContratulate;
    TextView tvReadAgain;
    TextView tvReadContinue;

    private Handler handler;

    public static void show(Activity context, boolean fullScore) {
        ClassEndFragment fragment = new ClassEndFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("fullScore", fullScore);
        fragment.setArguments(bundle);
        context.getFragmentManager().beginTransaction().replace(R.id.llBookViewControll, fragment).commitAllowingStateLoss();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_class_end, container, false);
        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
        return view;
    }

    protected void injectView(View view) {
        ivContratulate = view.findViewById(R.id.ivContratulate);
        tvReadAgain = view.findViewById(R.id.tvReadAgain);
        tvReadContinue = view.findViewById(R.id.tvReadContinue);

        view.findViewById(R.id.tvReadAgain).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onReadAgainClick();
            }
        });
        view.findViewById(R.id.tvReadContinue).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onContinueClick();
            }
        });
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        injectView(view);
        boolean fullScore = getArguments().getBoolean("fullScore");
        if (fullScore) {
            tvReadAgain.setVisibility(View.GONE);
            tvReadContinue.setVisibility(View.GONE);
            ivContratulate.setVisibility(View.VISIBLE);
            handler = new Handler();
            handler.postDelayed(() -> {
                dismiss();
            }, 1500);
        }
    }

    void onReadAgainClick() {
        ((BookReaderActivity) getActivity()).getReaderControler().restartCurrentPage();
        dismiss();
    }

    void onContinueClick() {
        dismiss();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (handler != null)
            handler.removeCallbacksAndMessages(null);
    }

    private void dismiss() {
        getActivity().getFragmentManager().beginTransaction().remove(this).commitAllowingStateLoss();
    }
}
