package com.ellabook.project.ellareader.book.cache;

import android.content.Context;

import androidx.annotation.WorkerThread;

import com.ellabook.project.ellareader.book.cache.bean.ProfileStorageAll;
import com.ellabook.project.ellareader.book.cache.bean.ProfileStorageItem;

import java.io.File;
import java.util.Locale;

/**
 * 咿啦英语 课程 绘本 分级下载管理
 * <p>
 * https://blog.csdn.net/maodoudou1217/article/details/49075791
 * <p>
 * <p>
 * Created by Tony on 2018/7/28.
 */

public class EllaDowloadStorageManager {


    public enum RESOURCETYPE {
        LESSON,//课程
        COURSE//绘本
    }


    private final String TAG = EllaDowloadStorageManager.class.getSimpleName();
    private final String UNITSIZE = "M";


    private static EllaDowloadStorageManager instance;

    private Context context;

    public EllaDowloadStorageManager(Context context) {
        this.context = context;
    }


    public static EllaDowloadStorageManager getInstance(Context context) {
        if (instance == null) {
            synchronized (EllaDowloadStorageManager.class) {
                if (instance == null) {
                    instance = new EllaDowloadStorageManager(context);
                }
            }
        }
        return instance;
    }


    public String getFormatStorageSize(long size) {
        if (size == 0)
            return String.format("0%s", UNITSIZE);
        else
            return String.format(Locale.getDefault(), "%.2f%s", (double) size / 1024 / 1024, UNITSIZE);
    }

    /**
     * 获取指定用户下 对应等级 文件夹 下 所有文件的大小
     *
     * @param uid   用户表示
     * @param level 资源等级
     */
    @WorkerThread
    public ProfileStorageAll getLevelDirSize(String uid, int level) {
        try {
            ProfileStorageAll all = new ConcurrentTotalFileSizeWLatch()
                    .getTotalSizeOfFile(level, context);
            return all;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 获取指定用户下 对应等级 文件夹 下 所有文件的大小
     *
     */
    @WorkerThread
    public ProfileStorageAll getAllLevelDir() {
        try {
            ProfileStorageAll all = new ConcurrentTotalFileSizeWLatch()
                    .getTotalSizeOfFile(context);
            return all;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public long getAllLevelDirSize() {
        long allSize = 0l;
        ProfileStorageAll all = getAllLevelDir();
        if (all != null && all.getList() != null) {
            for (ProfileStorageItem item : all.getList()) {
                if (item != null) {
                    allSize += item.getItemSize();
                }
            }
        }
        return allSize;
    }


    protected String getBaseCachePath() {
//        if (BuildConfig.DEBUG) {
//            return context.getExternalFilesDir("debug").getPath() + File.separator;
//        } else {
//            return context.getFilesDir().getPath() + File.separator;
//
//        }
        return context.getFilesDir().getPath() + File.separator;
    }


    /**
     * 获取图片缓存
     *
     * @return
     */
    public String getCacheImagePath() {
        String cachePath = context.getExternalFilesDir("images").getPath();
        File userFile = new File(cachePath);
        if (!userFile.exists())
            userFile.mkdir();
        String userPath = userFile.getAbsolutePath();
        return userPath;
    }


    /**
     * 获取下载资源路径
     *
     * @return
     */
    public String getDownloadResourcePath() {
        String path = getBaseCachePath();
        File downLoadSourceFile = new File(path, "download");
        if (!downLoadSourceFile.exists())
            downLoadSourceFile.mkdir();
        String downLoadSourceFilePath = downLoadSourceFile.getAbsolutePath();
        return downLoadSourceFilePath;
    }


}
