package com.ellabook.project.ellareader;

import android.app.Activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReaderModule implements IReaderController {
    private static boolean                 sDebugable         = false;
    static         boolean                 sAddWordEnable     = true;
    static         boolean                 sShowCopyRight     = true;
    private        List<IReaderController> mReaderControllers = new ArrayList<>();
    private static TryReadController       tryReadController;

    public static TryReadController getTryReadController() {
        return tryReadController;
    }

    public static void setTryReadController(TryReadController _tryReadController) {
        tryReadController = _tryReadController;
    }

    public static boolean showCopyRight() {
        return sShowCopyRight;
    }

    private static class HOLDER {
        private static final ReaderModule sReaderModule = new ReaderModule();
    }

    public static void setShowCopyRight(boolean sShowCopyRight) {
        ReaderModule.sShowCopyRight = sShowCopyRight;
    }

    public static boolean isAddWordEnable() {
        return sAddWordEnable;
    }

    public static boolean isDebugable() {
        return sDebugable;
    }

    public static void init(boolean addWordEnable, boolean debugable) {
        sAddWordEnable = addWordEnable;
        sDebugable = debugable;
    }

    public static IReaderController getReaderController() {
        return HOLDER.sReaderModule;
    }

    public static void add(IReaderController controller) {
        HOLDER.sReaderModule.mReaderControllers.add(controller);
    }

    @Override
    public void onBookReadPassed(String bookCode,
                                 String bookType,
                                 long missionId,
                                 long mapId,
                                 String bookCover,
                                 HashMap<Integer, Integer> questionQuantity,
                                 Activity activity,
                                 int requestCode,
                                 ArrayList<String> readStartEnds,
                                 int power,
                                 AnalysisFinishCallback callback) {
        for (IReaderController controller : mReaderControllers) {
            controller.onBookReadPassed(bookCode, bookType, missionId, mapId, bookCover,
                    questionQuantity, activity, requestCode, readStartEnds, power, callback);
        }
    }

    @Override
    public void postBookPassed(String bookCode, String bookType, long missionId) {
        for (IReaderController controller : mReaderControllers) {
            controller.postBookPassed(bookCode, bookType, missionId);
        }
    }

    @Override
    public boolean canDoneWith(String bookCode, String bookType, byte mode) {
        for (IReaderController controller : mReaderControllers) {
            if (controller.canDoneWith(bookCode, bookType, mode)) {
                return true;
            }
        }
        return false;
    }
}
