package com.ellabook.project.ellareader;

import android.media.MediaRecorder;
import android.os.Handler;
import android.util.Log;

import java.io.File;
import java.io.IOException;

public class AudioRecorder {
    public static final int MIN_AMPLITUDE = 75;
    public static final long MAX_RECORDER_TIME = 15 * 1000L;
    public static final long MAX_NO_SOUND_TIME = 5 * 1000L;
    private final String TAG = "MediaRecord";
    private MediaRecorder mMediaRecorder;
    public static final int MAX_LENGTH = 1000 * 60 * 10;// 最大录音时长1000*60*10;
    private String filePath;
    private OnAudioRecordListener onAudioRecordListener;

    public AudioRecorder(OnAudioRecordListener onAudioRecordListener) {
        this.onAudioRecordListener = onAudioRecordListener;
    }


    private long startTime;
    private long endTime;

    /**
     * 开始录音 使用amr格式
     * <p>
     * 录音文件
     *
     * @return
     */
    public void startRecord(File file) {
        this.filePath = file.getAbsolutePath();
        Log.e(TAG, "file path:" + filePath);
        hasVoice = false;
        // 开始录音
        /* ①Initial：实例化MediaRecorder对象 */
        if (mMediaRecorder == null)
            mMediaRecorder = new MediaRecorder();
        try {
            /* ②setAudioSource/setVedioSource */
            mMediaRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);// 设置麦克风
            /* ②设置音频文件的编码：AAC/AMR_NB/AMR_MB/Default 声音的（波形）的采样 */
            mMediaRecorder.setOutputFormat(MediaRecorder.OutputFormat.DEFAULT);
            /*
             * ②设置输出文件的格式：THREE_GPP/MPEG-4/RAW_AMR/Default THREE_GPP(3gp格式
             * ，H263视频/ARM音频编码)、MPEG-4、RAW_AMR(只支持音频且音频编码要求为AMR_NB)
             */
            mMediaRecorder.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);

            /* ③准备 */
            mMediaRecorder.setOutputFile(filePath);
            mMediaRecorder.setMaxDuration(MAX_LENGTH);
            mMediaRecorder.prepare();
            /* ④开始 */
            mMediaRecorder.start();
            // AudioRecord audioRecord.
            /* 获取开始时间* */
            startTime = System.currentTimeMillis();
            updateMicStatus();
            Log.i("ACTION_START", "startTime" + startTime);
        } catch (IllegalStateException e) {
            Log.i(TAG,
                    "call startAmr(File mRecAudioFile) failed!"
                            + e.getMessage());
        } catch (IOException e) {
            Log.i(TAG,
                    "call startAmr(File mRecAudioFile) failed!"
                            + e.getMessage());
        }
    }

    /**
     * 停止录音
     */
    public long stopRecord() {
        if (mMediaRecorder == null)
            return 0L;
        mHandler.removeCallbacks(mUpdateMicStatusTimer);
        endTime = System.currentTimeMillis();
        Log.i("ACTION_END", "endTime" + endTime);
        mMediaRecorder.stop();
        mMediaRecorder.reset();
        mMediaRecorder.release();
        mMediaRecorder = null;
        Log.i("ACTION_LENGTH", "Time" + (endTime - startTime));
        if (!hasVoice){
            return 0L;
        }
        return endTime - startTime;
    }

    private final Handler mHandler = new Handler();
    private Runnable mUpdateMicStatusTimer = new Runnable() {
        public void run() {
            updateMicStatus();
        }
    };

    /**
     * 更新话筒状态
     */
    private static final int BASE = 1;
    private static final int SPACE = 200;// 间隔取样时间
    private boolean hasVoice = false;

    private void updateMicStatus() {
        if (System.currentTimeMillis() - startTime > MAX_RECORDER_TIME) {
            if (mMediaRecorder != null) {
                stopRecord();
                onAudioRecordListener.onRecorderOverFlow();
                //超过15s 停止
            }
        } else {
            if (mMediaRecorder != null) {
                onAudioRecordListener.onTimeCountDown(startTime);
                if (!hasVoice) {
                    double ratio = (double) mMediaRecorder.getMaxAmplitude() / BASE;
                    double db = 0;// 分贝
                    if (ratio > 1)
                        db = 20 * Math.log10(ratio);
                    Log.d(TAG, "分贝值：" + db);
                    hasVoice = db >= MIN_AMPLITUDE;
                }
                if (!hasVoice) {
                    //如果没声音了
                    if (System.currentTimeMillis() - startTime > MAX_NO_SOUND_TIME) {
                        //如果没声音，并且过了5秒 退出
                        stopRecord();
                        onAudioRecordListener.onNoVoice();
                    } else {
                        //如果没声音，还没到5s，下次计算时间
                        mHandler.postDelayed(mUpdateMicStatusTimer, SPACE);
                    }
                } else {
                    //如果有声音了 ，倒数计时到15s
//                    long delayTime = MAX_RECORDER_TIME - (System.currentTimeMillis() - startTime) + SPACE;
//                    delayTime = delayTime >= 0 ? delayTime : SPACE;
//                    mHandler.postDelayed(mUpdateMicStatusTimer, delayTime);
                    mHandler.postDelayed(mUpdateMicStatusTimer, SPACE);
                }
            }
        }
    }

    public interface OnAudioRecordListener {
        void onNoVoice();

        void onTimeCountDown(long startTime);

        void onRecorderOverFlow();
    }
}