package com.ellabook.project.ellareader.ui.read;

import android.text.TextUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import cn.ellabook.SplitedSentences;

public class SplitedSentence implements Serializable {
    public float startPos;
    public float endPos;
    public List<String> wordList;

    public static ArrayList<ArrayList<SplitedSentence>> toLocalListSentence(Object[] splitedSegments) {
        ArrayList<ArrayList<SplitedSentence>> result = new ArrayList<>();
        ArrayList<SplitedSentence> temp = new ArrayList<>();
        if (splitedSegments == null)
            return result;

        temp = new ArrayList<>();
        for (Object object : splitedSegments) {
            if (!(object instanceof SplitedSentences))
                continue;
            SplitedSentences sentences = (SplitedSentences) object;

            SplitedSentence splitedSentence = new SplitedSentence();
            splitedSentence.startPos = sentences.startPos;
            splitedSentence.endPos = sentences.endPos;
            splitedSentence.wordList = new ArrayList<>();
            if (sentences.vFont == null)
                continue;

            for (String vFont : sentences.vFont) {
                if (!" ".equals(vFont))//阅读器可能返回空格等没有内容的单词，过滤掉
                    splitedSentence.wordList.add(vFont);
            }
            temp.add(splitedSentence);
        }
        result.add(temp);

        return result;
    }

    public static ArrayList<ArrayList<SplitedSentence>> toLocalList(Object[] splitedSegments) {
        ArrayList<ArrayList<SplitedSentence>> result = new ArrayList<>();
        ArrayList<SplitedSentence> temp = new ArrayList<>();
        if (splitedSegments == null)
            return result;

        for (Object splitedSegment : splitedSegments) {
            Object[] splitedSentences = ((Object[]) splitedSegment);
            if (splitedSentences == null || splitedSentences.length < 1) {
                continue;
            }
            temp = new ArrayList<>();
            for (Object object : splitedSentences) {
                if (!(object instanceof SplitedSentences))
                    continue;
                SplitedSentences sentences = (SplitedSentences) object;

                SplitedSentence splitedSentence = new SplitedSentence();
                splitedSentence.startPos = sentences.startPos;
                splitedSentence.endPos = sentences.endPos;
                splitedSentence.wordList = new ArrayList<>();
                if (sentences.vFont == null)
                    continue;

                for (String vFont : sentences.vFont) {
                    if (!" ".equals(vFont))//阅读器可能返回空格等没有内容的单词，过滤掉
                        splitedSentence.wordList.add(vFont);
                }
                temp.add(splitedSentence);
            }
            result.add(temp);
        }

        return result;
    }

    public String getSentence() {
        if (wordList == null || wordList.size() == 0) {
            return "";
        }
        if (wordList.size() == 1) {
            return wordList.get(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(wordList.get(0));
        for (int i = 1; i < wordList.size(); i++) {
            if (
                    (!isMark(wordList.get(i))
                            && (!isMark(wordList.get(i - 1))))
            ) {
                sb.append(" ");
            }
            sb.append(wordList.get(i));
        }
        return sb.toString();
    }

    // 中文标点
    public static boolean isMark(String word) {
        if (!TextUtils.isEmpty(word)) {
            word = word.trim();
        } else {
            return true;
        }
        String replaced = word.replaceAll("\\p{P}|\\p{S}|\\p{C}|\\p{N}|\\p{Z}", "");
        return TextUtils.isEmpty(replaced);
    }
}
