package com.ellabook.project.ellareader.ui.read;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.ellabook.project.base.util.Converter;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.bean.FeedbackBean;

import java.util.List;

import ellax.base.Callback;

import static android.content.Context.LAYOUT_INFLATER_SERVICE;

/**
 * Created by tiandehua on 2020/6/10
 *
 * @description:
 */
public class FeedbackPopup {

    private FeedbackAdapter mAdapter;
    private Callback<Integer> mCallback;

    public void show(Context context,View belowView,  View parentView, List<FeedbackBean> list, View maskView) {
        LayoutInflater mLayoutInflater = (LayoutInflater) context.getSystemService(LAYOUT_INFLATER_SERVICE);
        ViewGroup menuView = (ViewGroup) mLayoutInflater.inflate(
                R.layout.popup_feed_back_choose, null, true);
        PopupWindow pw = new PopupWindow(menuView, ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT, true);
        pw.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        pw.setOutsideTouchable(true);

        boolean isTablet = context.getResources().getBoolean(R.bool.is_tablet);
        if(!isTablet) {
            //使用的是手机，非平板
            menuView.findViewById(R.id.rlArrowTop).setVisibility(View.GONE);
            pw.showAtLocation(parentView, Gravity.END | Gravity.BOTTOM, Converter.dip2px(20f), Converter.dip2px(30f));
        } else {
            //平板展示
            //判断是否能展示的下
            if (isSpaceEnough(belowView, 170)) {
                pw.showAsDropDown(belowView, 0, 0);
            } else {
                //当显示不下时，弹出在底部固定位置，并隐藏三角号
                menuView.findViewById(R.id.rlArrowTop).setVisibility(View.GONE);
                pw.showAtLocation(parentView, Gravity.END | Gravity.BOTTOM, Converter.dip2px(53f), Converter.dip2px(50f));
            }
        }

        pw.update();
        pw.setOnDismissListener(new PopupWindow.OnDismissListener() {
            @Override
            public void onDismiss() {
                maskView.setVisibility(View.GONE);
            }
        });

        maskView.setVisibility(View.VISIBLE);

        menuView.findViewById(R.id.btConfirm).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                pw.dismiss();
                if(mCallback != null) {
                    mCallback.callback(mAdapter.getCurrentPosition());
                }
            }
        });
        initRecylerView(context, menuView.findViewById(R.id.rvFeedback), list);
    }
    private boolean isSpaceEnough(View targetView, int needSpace) {
        Context context = targetView.getContext();
        int screenHeight = context.getResources().getDisplayMetrics().heightPixels;
        int[] viewLocation = new int[2];
        targetView.getLocationOnScreen(viewLocation);
        int bottom = viewLocation[1] + targetView.getHeight();
        int restSpace = screenHeight - bottom;
        return restSpace > Converter.dip2px(needSpace);
    }

    public void setConfirmCallback(Callback<Integer> callback) {
        mCallback = callback;
    }

    private void initRecylerView(Context context, RecyclerView rvFeedback, List<FeedbackBean> list) {
        //初始化recyclerView
        mAdapter = new FeedbackAdapter(list, 0);
        rvFeedback.setLayoutManager(new GridLayoutManager(context, 3));
        rvFeedback.addItemDecoration(new GridSpaceDecoration(3, list.size(), Converter.dip2px(6), Converter.dip2px(8)));
        rvFeedback.setAdapter(mAdapter);
    }

    /**
     * 反馈列表 adapter
     */
    private static class FeedbackAdapter extends RecyclerView.Adapter<FeedbackViewHolder> {
        private List<FeedbackBean> mList;
        private int mSelectIndex;

        private FeedbackAdapter(@NonNull List<FeedbackBean> list, int selectPosition) {
            mList = list;
            mSelectIndex = selectPosition;
        }

        @NonNull
        @Override
        public FeedbackViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_feedback_reason, parent, false);
            return new FeedbackViewHolder(view);
        }

        @Override
        public void onBindViewHolder(@NonNull FeedbackViewHolder holder, int position) {
            holder.setItem(mList.get(position).info, position == mSelectIndex);
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mSelectIndex = position;
                    notifyDataSetChanged();
                }
            });
        }

        @Override
        public int getItemCount() {
            return mList.size();
        }

        public int getCurrentPosition() {
            return mSelectIndex;
        }
    }

    private static class FeedbackViewHolder extends RecyclerView.ViewHolder {

        public FeedbackViewHolder(@NonNull View itemView) {
            super(itemView);
        }

        public void setItem(String value, boolean isSelect) {
            TextView textView = (TextView) itemView;
            textView.setText(value);
            textView.setSelected(isSelect);
        }
    }

    private static class GridSpaceDecoration extends RecyclerView.ItemDecoration {

        //这里简单实现，不区分首行尾行
        private int lineSpace; //列间距
        private int rowSpace; //行间距

        private int spanCount;
        private int totalCount;

        public GridSpaceDecoration(int _spanCount, int _totalCount,  int _lineSpace, int _rowSpace) {
            spanCount = _spanCount;
            totalCount = _totalCount;
            lineSpace = _lineSpace;
            rowSpace = _rowSpace;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            int position = parent.getChildAdapterPosition(view);
            int top = 0;
            int left = 0;
            if(!isFirstRow(position)) {
                left = rowSpace;
            }
            if(!isFirstLine((position))) {
                top = lineSpace;
            }
            outRect.left = left;
            outRect.top = top;
        }

        private boolean isLastLine(int position) {
            int lines = totalCount / spanCount + totalCount % spanCount == 0 ? 0 : 1;
            return position >= (lines - 1) * spanCount;
        }
        private boolean isLastRow(int position) {
            return position % spanCount == spanCount - 1;
        }

        private boolean isFirstRow(int position) {
            return position % spanCount == 0;
        }

        private boolean isFirstLine(int position) {
            return position < spanCount;
        }
    }


}
