package com.ellabook.project.ellareader.ui.read;

import android.app.Fragment;
import android.net.Uri;
import android.os.Bundle;
import android.os.Looper;
import android.os.MessageQueue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.R;

/**
 * 作者：wangtao on 2019/4/10 16:49
 * 邮箱：863010067@qq.com
 * 课程关卡引导页
 */
public class CourseGuideFragment extends Fragment implements View.OnClickListener {

    private RelativeLayout rlGuideOne;
    private TextView tvNextOne;
    private TextView tvSkipOne;
    private RelativeLayout rlGuideTwo;
    private TextView tvNextTwo;
    private TextView tvSkipTwo;
    private RelativeLayout rlGuideFour;
    private TextView tvNextFour;
    private TextView tvSkipFour;
    private RelativeLayout rlGuideFive;
    private TextView tvLookRepeat;
    private TextView tvGuideDone;
    private View vDiamondHighLight = null;
    private ShadownXorView sdvDiamondHighLight;
    private ShadownXorView sdvEllaReadExit;
    private ShadownXorView sdvEllaReadRight;
    private ShadownXorView sdvEllaReadLeft;

    private View vEllaReadExit;
    private View vEllaReadRight;
    private View vEllaReadLeft;

    public static final String GUIDE_KEY = "CourseGuideFragment.GUIDE_KEY";

    public static boolean checkShowGuide(BookReaderActivity context, int diamondWidth) {
        if (context.getReaderControler().getCurrentPage() != 2)
            return false;
        if (!UserInfoProvider.isGuideAvailable(GUIDE_KEY, true))
            return false;

        UserInfoProvider.setGuide(GUIDE_KEY, false);
        context.getReaderControler().pause();//暂停播放
        CourseGuideFragment courseGuideFragment = new CourseGuideFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("diamond_width", diamondWidth);
        courseGuideFragment.setArguments(bundle);
        context.getFragmentManager().beginTransaction().replace(R.id.llBookViewControll, courseGuideFragment).commitAllowingStateLoss();
        return true;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_fragment_guide, container, false);
        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
        int diamondWidth = getArguments().getInt("diamond_width");
        vDiamondHighLight = view.findViewById(R.id.vDiamondHighLight);
        vDiamondHighLight.getLayoutParams().width = diamondWidth;

        sdvDiamondHighLight = view.findViewById(R.id.sdvDiamondHighLight);

        sdvEllaReadExit = view.findViewById(R.id.sdvEllaReadExit);
        vEllaReadExit = view.findViewById(R.id.vEllaReadExit);

        sdvEllaReadRight = view.findViewById(R.id.sdvEllaReadRight);
        vEllaReadRight = view.findViewById(R.id.vEllaReadRight);

        sdvEllaReadLeft = view.findViewById(R.id.sdvEllaReadLeft);
        vEllaReadLeft = view.findViewById(R.id.vEllaReadLeft);


        rlGuideOne = view.findViewById(R.id.rlGuideOne);
        tvNextOne = view.findViewById(R.id.tvNextOne);
        tvSkipOne = view.findViewById(R.id.tvSkipOne);
        rlGuideTwo = view.findViewById(R.id.rlGuideTwo);
        tvNextTwo = view.findViewById(R.id.tvNextTwo);
        tvSkipTwo = view.findViewById(R.id.tvSkipTwo);
        rlGuideFour = view.findViewById(R.id.rlGuideFour);
        tvNextFour = view.findViewById(R.id.tvNextFour);
        tvSkipFour = view.findViewById(R.id.tvSkipFour);
        rlGuideFive = view.findViewById(R.id.rlGuideFive);
        tvLookRepeat = view.findViewById(R.id.tvLookRepeat);
        tvGuideDone = view.findViewById(R.id.tvGuideDone);

        tvNextOne.setOnClickListener(this);
        if (tvSkipOne != null) {
            tvSkipOne.setOnClickListener(this);
        }
        tvNextTwo.setOnClickListener(this);
        if (tvSkipTwo != null) {
            tvSkipTwo.setOnClickListener(this);
        }
        tvNextFour.setOnClickListener(this);
        if (tvSkipFour != null) {
            tvSkipFour.setOnClickListener(this);
        }
        tvLookRepeat.setOnClickListener(this);
        tvGuideDone.setOnClickListener(this);
        Looper.myQueue().addIdleHandler(new ShowGuideIdleOnce());

        if (!isVoiced("welcome_learn_to_read")) {
            playVoice(R.raw.welcome_learn_to_read);
        }
        return view;
    }

    class ShowGuideIdleOnce implements MessageQueue.IdleHandler {

        @Override
        public boolean queueIdle() {
            if (isDetached()) {
                return false;
            }
            return resetGuide();
        }

    }


    private boolean resetGuide() {
        if (vDiamondHighLight == null) {
            return false;
        }
        if (vDiamondHighLight.getX() == 0) {
            return true;
        }
        sdvDiamondHighLight.setRectangle(vDiamondHighLight.getX(), vDiamondHighLight.getY(), vDiamondHighLight.getWidth(), vDiamondHighLight.getHeight(),
                getResources().getDimension(R.dimen.book_reader_diamond_size));
        sdvEllaReadExit.setCircle(vEllaReadExit.getX(), vEllaReadExit.getY(), vEllaReadExit.getHeight() / 2);
        sdvEllaReadRight.setCircle(vEllaReadRight.getX(), vEllaReadRight.getY(), vEllaReadRight.getHeight() / 2);
        sdvEllaReadLeft.setCircle(vEllaReadLeft.getX(), vEllaReadLeft.getY(), vEllaReadLeft.getHeight() / 2);
        return false;
    }

    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.tvNextOne) {
            if (!isVoiced("course_menu")) {
                playVoice(R.raw.course_menu);
            }
            rlGuideOne.setVisibility(View.INVISIBLE);
            rlGuideTwo.setVisibility(View.VISIBLE);
        } else if (id == R.id.tvSkipOne) {
            dismiss();
        } else if (id == R.id.tvNextTwo) {

            if (!isVoiced("course_next_page")) {
                playVoice(R.raw.course_menu_next_page);
            }

            rlGuideTwo.setVisibility(View.INVISIBLE);
            rlGuideFour.setVisibility(View.VISIBLE);
        } else if (id == R.id.tvSkipTwo) {
            dismiss();
        } else if (id == R.id.tvNextFour) {
            if (!isVoiced("course_pre_page")) {
                playVoice(R.raw.course_menu_pre_page);
            }
            rlGuideFour.setVisibility(View.INVISIBLE);
            rlGuideFive.setVisibility(View.VISIBLE);
        } else if (id == R.id.tvSkipFour) {
            dismiss();
        } else if (id == R.id.tvLookRepeat) {
            if (!isVoiced("welcome_learn_to_read")) {
                playVoice(R.raw.welcome_learn_to_read);
            }
            rlGuideFive.setVisibility(View.INVISIBLE);
            rlGuideOne.setVisibility(View.VISIBLE);
        } else if (id == R.id.tvGuideDone) {
            dismiss();
        }
    }

    /**
     * 始终播放
     */
    public boolean isVoiced(String voiceName) {
        return false;
    }

    public void playVoice(int voiceId) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play(Uri.parse("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId));
        }
    }

    private void dismiss() {
        AudioPlayer.stopPlay();
        getActivity().getFragmentManager().beginTransaction().remove(this).commitAllowingStateLoss();
        ((BookReaderActivity) getActivity()).getReaderControler().resume();//继续播放
    }

}

