package com.ellabook.project.ellareader.book.cache.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.ellabook.project.ellareader.book.bean.BookExtraInfo;

/**
 * 存储信息
 * <p>
 * Created by Tony on 2018/7/28.
 */

public class ProfileStorageItem implements Parcelable {

    int type;//0 课程  1 绘本
    String name;//名称
    long itemSize;//B
    int selectType;//0 未选中 1 选中

    String showItemSize;
    String filePath;
    BookExtraInfo info;

    public BookExtraInfo getInfo() {
        return info;
    }

    public void setInfo(BookExtraInfo info) {
        this.info = info;
    }

    public String getShowItemSize() {
        return showItemSize;
    }

    public void setShowItemSize(String showItemSize) {
        this.showItemSize = showItemSize;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getSelectType() {
        return selectType;
    }

    public void setSelectType(int selectType) {
        this.selectType = selectType;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getItemSize() {
        return itemSize;
    }

    public void setItemSize(long itemSize) {
        this.itemSize = itemSize;
    }

    public ProfileStorageItem() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type);
        dest.writeString(this.name);
        dest.writeLong(this.itemSize);
        dest.writeInt(this.selectType);
        dest.writeString(this.showItemSize);
        dest.writeString(this.filePath);
        dest.writeParcelable(this.info, flags);
    }

    protected ProfileStorageItem(Parcel in) {
        this.type = in.readInt();
        this.name = in.readString();
        this.itemSize = in.readLong();
        this.selectType = in.readInt();
        this.showItemSize = in.readString();
        this.filePath = in.readString();
        this.info = in.readParcelable(BookExtraInfo.class.getClassLoader());
    }

    public static final Creator<ProfileStorageItem> CREATOR = new Creator<ProfileStorageItem>() {
        @Override
        public ProfileStorageItem createFromParcel(Parcel source) {
            return new ProfileStorageItem(source);
        }

        @Override
        public ProfileStorageItem[] newArray(int size) {
            return new ProfileStorageItem[size];
        }
    };
}
