package com.ellabook.project.ellareader.biz;

import com.ellabook.project.ellareader.bean.FeedbackBean;
import com.ellabook.project.ellareader.bean.HttpWordDetails;
import com.ellabook.project.ellareader.bean.StoneNum;
import com.ellabook.project.ellareader.bean.StoneResult;

import java.util.List;

import com.ellabook.netwrok.bean.ResponseDataWrapper;
import io.reactivex.Observable;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.POST;

public interface ApiRead {

    @POST("en/user/info/queryWord/v1")
    Observable<ResponseDataWrapper<HttpWordDetails>> getWordDetails(@Body RequestBody body);

    @POST("/en/resource/putCourseAnswerInfo/v1")
    Observable<ResponseDataWrapper<StoneResult>> uploadAnswerRecord(@Body RequestBody body);

    @POST("/en/resource/getCourseAnswerInfo/v1")
    Observable<ResponseDataWrapper<List<StoneNum>>> getStoneNums(@Body RequestBody body);

    @POST("/en/wordWall/putUserWordWall/v1")
    Observable<ResponseDataWrapper> addUserWord(@Body RequestBody body);

//    @POST("en/picBook/v1/readRecord")
//    Observable<ResponseDataWrapper<Boolean>> uploadReadInfo(@Body RequestBody body);
    @POST("en/picBook/v1/readRecordBatch")
    Observable<ResponseDataWrapper<Boolean>> uploadReadInfoBatch(@Body RequestBody body);

//    @POST("en/resource/readRecordIra/v1")
//    Observable<ResponseDataWrapper<Boolean>> uploadReadInfoMission(@Body RequestBody body);
    @POST("en/resource/readRecordIraBatch/v1")
    Observable<ResponseDataWrapper<Boolean>> uploadReadInfoMissionBatch(@Body RequestBody body);

    @POST("en/resource/updateStoneNum/v1")
    Observable<ResponseDataWrapper<Boolean>> uploadCourseStoneNum(@Body RequestBody body);

    @POST("en/baseBook/v1/getBookShelvesFlag")
    Observable<ResponseDataWrapper<Boolean>> bookStatus(@Body RequestBody body);

    @POST("en/recovery/word/recoveryInfoList/v1")
    Observable<ResponseDataWrapper<List<FeedbackBean>>> feedbackList(@Body RequestBody body);

    @POST("en/user/info/recoveryWord/v1")
    Observable<ResponseDataWrapper<Boolean>> commitFeedback(@Body RequestBody body);

}
