package com.ellabook.project.ellareader.bean.picbook;

import android.os.Parcel;
import android.os.Parcelable;

import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.book.bean.BookExtraInfo;
import com.ellabook.project.ellareader.book.bean.HttpPicBookInfo;

import java.util.List;

import ellax.bookmanager.ReaderResource;
import retrofit2.http.DELETE;


/**
 * 作者：wangtao on 18/8/9 14:24
 * 邮箱：863010067@qq.com
 * 绘本详情实体
 */

public class HttpPicBookDetailInfo implements Parcelable, BookContainer {

    public boolean available = false;
    /**
     * authorText :
     * bookIntroduction :
     * bookName :
     * coverUrl :
     * description :
     * forAge :
     * goodsPrice : 0
     * goodsType :
     * interactionEffect :
     * isBuy : false
     * lexileLevel :
     * picHandle :
     * radioMan :
     * readeCount : 0
     * resourceUrl :
     * reviewerMan :
     * seriesName :
     * supportPayType :
     * tags :
     * videoUrl :
     */

    public String authorText; //作者
    public String bookIntroduction;//介绍
    public String bookName;//名称
    public String coverUrl;//封面
    public String description;//介绍
    public String forAge;//适用年龄
    public double goodsPrice;//商品价格
    public String goodsType;//商品类型
    public String interactionEffect;//动画设计
    public boolean isBuy;//是否购买：ture false
    @Deprecated
    public String lexileLevel;//蓝思级别
    public String lexileLevelCode;//蓝思级别
    public String levelCode;
    public String picHandle;//美术
    public String radioMan;//音频
    public int readeCount;//多少人读过
    public String resourceUrl;//绘本资源url
    public String reviewerMan;//校审
    public String seriesName;//系列名
    public String supportPayType;//支付类型
    public String tags;//标签
    public String videoUrl;//预览视频url
    public List<String> preImage;//预览图片数组
    public List<HttpPicBookInfo> levelRecommend;//推荐
    public boolean isReadFinish;//是否可以发表评论

    public String painting;
    //出版社
    public String bookPressName;

    public String version;
    public String bookCode;
    public String goodsCode;

    public String picBookCode;
    public int type;
    public long missionId;
    public long mapId;
    //------------funbook专属字段 start
    //剧本
    public String script;
    //出版社
    public String publishName;
    //上架时间
    public String salingDate;
    //所需能量石
    public int goodsPriceStone;
    //------------funbook end

    @Override
    public String getBookCode() {
        return bookCode;
    }

    @Override
    public String getPicBookCode() {
        return picBookCode;
    }

    @Override
    public String getBookName() {
        return bookName;
    }

    @Override
    public String getBookType() {
        return ApplicationHolder.getContext().getString(R.string.pic_book_type);//这个是绘本类型，不知道为什么用这个单词
    }

    @Override
    public String getBookLevel() {
        return levelCode;
    }

    @Override
    public String getResourceCode() {
        return bookCode;
    }

    @Override
    public boolean isPublicResource() {
        return false;
    }

    // TODO:bqf 2019-07-12 readerVersion
    @Override
    public String getBookReaderVersion() {
        return "";
    }
    @Override
    public String getBookResourceVersion() {
        return version;
    }


    // TODO:bqf 2019-07-12 这坨东西统一放在一个地方。。。
    @Override
    public ReaderResource getMainResource() {
        ReaderResource resource = new ReaderResource();
        resource.url = resourceUrl;
        resource.resourceType = ReaderResource.RESOURCE_TYPE_BOOK;

        resource.resourceVersion = version;
        resource.extraInfo=new BookExtraInfo(bookName,levelCode,goodsCode,picBookCode);
        resource.bookCode = bookCode;
//        resource.resourceSize = (long) (1 * 1024 * 1024);

//        if (isSupportTeachMode()) {
//            resource.nextResource = getParentingResource();
//        }
        return resource;
    }

    @Override
    public int getDiamondNum() {
        return 0;
    }

    @Override
    public int getPassNum() {
        return 0;
    }

    @Override
    public long getId() {
        return -1;
    }

    @Override
    public String getBookCover() {
        return coverUrl;
    }

    @Override
    public String getMissionCode() {
        return "";
    }

    public HttpPicBookDetailInfo() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.available ? (byte) 1 : (byte) 0);
        dest.writeString(this.authorText);
        dest.writeString(this.bookIntroduction);
        dest.writeString(this.bookName);
        dest.writeString(this.coverUrl);
        dest.writeString(this.description);
        dest.writeString(this.forAge);
        dest.writeDouble(this.goodsPrice);
        dest.writeString(this.goodsType);
        dest.writeString(this.interactionEffect);
        dest.writeByte(this.isBuy ? (byte) 1 : (byte) 0);
        dest.writeString(this.lexileLevel);
        dest.writeString(this.lexileLevelCode);
        dest.writeString(this.levelCode);
        dest.writeString(this.picHandle);
        dest.writeString(this.radioMan);
        dest.writeInt(this.readeCount);
        dest.writeString(this.resourceUrl);
        dest.writeString(this.reviewerMan);
        dest.writeString(this.seriesName);
        dest.writeString(this.supportPayType);
        dest.writeString(this.tags);
        dest.writeString(this.videoUrl);
        dest.writeStringList(this.preImage);
        dest.writeTypedList(this.levelRecommend);
        dest.writeByte(this.isReadFinish ? (byte) 1 : (byte) 0);
        dest.writeString(this.painting);
        dest.writeString(this.bookPressName);
        dest.writeString(this.version);
        dest.writeString(this.bookCode);
        dest.writeString(this.goodsCode);
        dest.writeString(this.picBookCode);
        dest.writeInt(this.type);
        dest.writeLong(this.missionId);
        dest.writeLong(this.mapId);
        dest.writeString(this.script);
        dest.writeString(this.publishName);
        dest.writeString(this.salingDate);
        dest.writeInt(this.goodsPriceStone);
    }

    protected HttpPicBookDetailInfo(Parcel in) {
        this.available = in.readByte() != 0;
        this.authorText = in.readString();
        this.bookIntroduction = in.readString();
        this.bookName = in.readString();
        this.coverUrl = in.readString();
        this.description = in.readString();
        this.forAge = in.readString();
        this.goodsPrice = in.readDouble();
        this.goodsType = in.readString();
        this.interactionEffect = in.readString();
        this.isBuy = in.readByte() != 0;
        this.lexileLevel = in.readString();
        this.lexileLevelCode = in.readString();
        this.levelCode = in.readString();
        this.picHandle = in.readString();
        this.radioMan = in.readString();
        this.readeCount = in.readInt();
        this.resourceUrl = in.readString();
        this.reviewerMan = in.readString();
        this.seriesName = in.readString();
        this.supportPayType = in.readString();
        this.tags = in.readString();
        this.videoUrl = in.readString();
        this.preImage = in.createStringArrayList();
        this.levelRecommend = in.createTypedArrayList(HttpPicBookInfo.CREATOR);
        this.isReadFinish = in.readByte() != 0;
        this.painting = in.readString();
        this.bookPressName = in.readString();
        this.version = in.readString();
        this.bookCode = in.readString();
        this.goodsCode = in.readString();
        this.picBookCode = in.readString();
        this.type = in.readInt();
        this.missionId = in.readLong();
        this.mapId = in.readLong();
        this.script = in.readString();
        this.publishName = in.readString();
        this.salingDate = in.readString();
        this.goodsPriceStone = in.readInt();
    }

    public static final Creator<HttpPicBookDetailInfo> CREATOR = new Creator<HttpPicBookDetailInfo>() {
        @Override
        public HttpPicBookDetailInfo createFromParcel(Parcel source) {
            return new HttpPicBookDetailInfo(source);
        }

        @Override
        public HttpPicBookDetailInfo[] newArray(int size) {
            return new HttpPicBookDetailInfo[size];
        }
    };
}
