package cn.ellabook;

public class ReadTimeCounter {

    private long readTime;
    private long startTime;

    public static ReadTimeCounter getInstance() {
        return InstanceHolder.instance;
    }

    private static class InstanceHolder {
        private static ReadTimeCounter instance = new ReadTimeCounter();
    }

    private ReadTimeCounter() {}

    void onActivityCreate() {
        readTime = 0;
        startTime = 0;
    }

    void onActivityResume() {
        startTime = System.currentTimeMillis();
    }

    void onActivityPause() {
        if(startTime == 0)
            return;
        readTime = readTime + System.currentTimeMillis() - startTime;
        startTime = 0;
    }

    public long getAndClearReadTime() {
        long tempTime = readTime;
        if(startTime != 0) {
            tempTime = tempTime + System.currentTimeMillis() - startTime;
            startTime = 0;
        }
        readTime = 0;
        return tempTime;
    }
}
