/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import cn.ellabook.EllaBookViewer;
import cn.ellabook.EllaBookViewerHelper;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.security.ParentCheckUtil;
import com.ellabook.project.base.share.ShareUtil;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ui.read.BookReaderActivity;
import com.ellabook.project.ellareader.ui.read.SelfStudyGuideFragment;
import ellax.log.Logger;
import java.util.Map;

public class MenuFragment
extends Fragment {
    boolean mIsFinished;
    boolean mShowModeSwitch;
    TextView vModeSwitch;
    TextView tvShare;
    private long bookId;

    static MenuFragment get(long bookId) {
        MenuFragment fragment = new MenuFragment();
        Bundle bundle = new Bundle();
        bundle.putLong("bookId", bookId);
        fragment.setArguments(bundle);
        fragment.bookId = bookId;
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.ellabook_read_menu2, container, false);
    }

    protected void injectView(View view) {
        this.vModeSwitch = (TextView)view.findViewById(R.id.vModeSwitch);
        this.tvShare = (TextView)view.findViewById(R.id.tvShare);
        view.findViewById(R.id.tvExit).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MenuFragment.this.onExitClick();
            }
        });
        view.findViewById(R.id.vModeSwitch).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MenuFragment.this.onSelfStudy();
            }
        });
        view.findViewById(R.id.tvShare).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Logger.record((String)"en_read_share");
                MenuFragment.this.onShareClick();
            }
        });
        view.findViewById(R.id.tvReread).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Logger.record((String)"en_read_back");
                MenuFragment.this.onRereadClick();
            }
        });
        view.findViewById(R.id.ivClose).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MenuFragment.this.onCloseClick();
            }
        });
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.bookId = this.getArguments().getLong("bookId");
        this.injectView(view);
        if (this.mShowModeSwitch) {
            if (EllaBookViewer.getBookPlayMode() == 4) {
                MenuFragment.switchDrawbleTop(this.vModeSwitch, R.drawable.pass_course_btn_answer);
                this.vModeSwitch.setText((CharSequence)"Learn to Read");
            } else {
                MenuFragment.switchDrawbleTop(this.vModeSwitch, R.drawable.pass_course_btn_self);
                this.vModeSwitch.setText((CharSequence)"Read to learn");
            }
        } else {
            this.vModeSwitch.setVisibility(8);
        }
        if (UserInfoProvider.isVipAvailable()) {
            this.tvShare.setVisibility(8);
        } else {
            this.tvShare.setVisibility(8);
        }
        if (EllaBookViewerHelper.isAllExercisePages()) {
            this.vModeSwitch.setVisibility(8);
        } else {
            this.vModeSwitch.setVisibility(0);
        }
        EllaBookViewerHelper.pause();
    }

    private static void switchDrawbleTop(TextView textView, @DrawableRes int drawResourse) {
        Drawable[] drawables = textView.getCompoundDrawables();
        if (drawables.length == 4 && drawables[1] != null) {
            Drawable newDrawable = textView.getResources().getDrawable(drawResourse);
            newDrawable.setBounds(drawables[1].getBounds());
            drawables[1] = newDrawable;
        }
        textView.setCompoundDrawables(drawables[0], drawables[1], drawables[2], drawables[3]);
    }

    void onExitClick() {
        ((BookReaderActivity)this.getActivity()).getReaderControler().endBookViewer();
    }

    void onSelfStudy() {
        if (this.mIsFinished) {
            this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
            if (EllaBookViewer.getBookPlayMode() == 4) {
                EllaBookViewer.setBookPlayMode((byte)5);
                EllaBookViewerHelper.resume();
                Logger.record((String)"en_read_change", (String)"2");
            } else {
                int currentPage;
                Logger.record((String)"en_read_change", (String)"1");
                Map map = EllaBookViewer.getExercisePages();
                if (map != null) {
                    Log.v((String)"reader_exercisePage", (String)map.toString());
                }
                if (map.containsKey(currentPage = EllaBookViewer.getCurrentPage()) && map.get(currentPage) != null && !((Boolean)map.get(currentPage)).booleanValue()) {
                    if (EllaBookViewer.getCurrentPage() < 2 || !SelfStudyGuideFragment.checkShowGuide((BookReaderActivity)this.getActivity())) {
                        ToastUtils.showCenterToast((String)"\u5df2\u8fdb\u5165Read to learn\u6a21\u5f0f\uff0c\u70b9\u51fb\u6587\u672c\u5185\u5bb9\u53ef\u67e5\u770b\u7ffb\u8bd1");
                        EllaBookViewer.setBookPlayMode((byte)4);
                        EllaBookViewerHelper.resume();
                    }
                } else {
                    ToastUtils.showCenterToast((String)"\u5f53\u524d\u9875\u9762\u6682\u65f6\u4e0d\u652f\u6301\u81ea\u5b66\u6a21\u5f0f\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9875\u9762\u8fdb\u5165\u81ea\u5b66\u6a21\u5f0f");
                    EllaBookViewerHelper.resume();
                }
            }
        } else {
            ToastUtils.showCenterToast((String)"\u95ef\u5173\u7ed3\u675f\u540e\uff0c\u624d\u80fd\u5f00\u542f\u81ea\u5b66\u6a21\u5f0f");
        }
    }

    void onShareClick() {
        Activity activity = this.getActivity();
        if (activity != null && activity instanceof FragmentActivity) {
            ParentCheckUtil.show((FragmentActivity)((FragmentActivity)activity), () -> ShareUtil.shareBook((Activity)activity, (long)this.bookId));
        }
    }

    void onRereadClick() {
        this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        EllaBookViewer.restartCurrentPage();
        EllaBookViewerHelper.resume();
    }

    void onCloseClick() {
        this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        EllaBookViewerHelper.resume();
    }

    public void show(FragmentManager fragmentManager, int id2, String tag, boolean isFinished, boolean showModeSwitch) {
        this.mIsFinished = isFinished;
        this.mShowModeSwitch = showModeSwitch;
        fragmentManager.beginTransaction().replace(id2, (Fragment)this).commitAllowingStateLoss();
    }

    public boolean isVoiced(String voiceName) {
        if (UserInfoProvider.isGuideAvailable((String)voiceName, (boolean)false)) {
            return true;
        }
        UserInfoProvider.setGuide((String)voiceName, (boolean)true);
        return false;
    }

    public void playVoice(int voiceId) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play((Uri)Uri.parse((String)("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId)));
        }
    }
}

