/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.book.cache;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.ellabook.project.ellareader.book.cache.ConcurrentTotalFileSizeWLatch;
import com.ellabook.project.ellareader.book.cache.bean.ProfileStorageAll;
import com.ellabook.project.ellareader.book.cache.bean.ProfileStorageItem;
import java.io.File;
import java.util.Locale;

public class EllaDowloadStorageManager {
    private final String TAG = EllaDowloadStorageManager.class.getSimpleName();
    private final String UNITSIZE = "M";
    private static EllaDowloadStorageManager instance;
    private Context context;

    public EllaDowloadStorageManager(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EllaDowloadStorageManager getInstance(Context context) {
        if (instance != null) return instance;
        Class<EllaDowloadStorageManager> clazz = EllaDowloadStorageManager.class;
        synchronized (EllaDowloadStorageManager.class) {
            if (instance != null) return instance;
            instance = new EllaDowloadStorageManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public String getFormatStorageSize(long size) {
        if (size == 0L) {
            return String.format("0%s", "M");
        }
        return String.format(Locale.getDefault(), "%.2f%s", (double)size / 1024.0 / 1024.0, "M");
    }

    @WorkerThread
    public ProfileStorageAll getLevelDirSize(String uid, int level) {
        try {
            ProfileStorageAll all = new ConcurrentTotalFileSizeWLatch().getTotalSizeOfFile(level, this.context);
            return all;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @WorkerThread
    public ProfileStorageAll getAllLevelDir() {
        try {
            ProfileStorageAll all = new ConcurrentTotalFileSizeWLatch().getTotalSizeOfFile(this.context);
            return all;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getAllLevelDirSize() {
        long allSize = 0L;
        ProfileStorageAll all = this.getAllLevelDir();
        if (all != null && all.getList() != null) {
            for (ProfileStorageItem item : all.getList()) {
                if (item == null) continue;
                allSize += item.getItemSize();
            }
        }
        return allSize;
    }

    protected String getBaseCachePath() {
        return this.context.getFilesDir().getPath() + File.separator;
    }

    public String getCacheImagePath() {
        String cachePath = this.context.getExternalFilesDir("images").getPath();
        File userFile = new File(cachePath);
        if (!userFile.exists()) {
            userFile.mkdir();
        }
        String userPath = userFile.getAbsolutePath();
        return userPath;
    }

    public String getDownloadResourcePath() {
        String path = this.getBaseCachePath();
        File downLoadSourceFile = new File(path, "download");
        if (!downLoadSourceFile.exists()) {
            downLoadSourceFile.mkdir();
        }
        String downLoadSourceFilePath = downLoadSourceFile.getAbsolutePath();
        return downLoadSourceFilePath;
    }

    public static enum RESOURCETYPE {
        LESSON,
        COURSE;

    }
}

