package com.ellabook.project.ellareader.ui.read;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.ellabook.project.ellareader.R;

import java.util.ArrayList;

public class SplitedSegmentsLayout extends LinearLayout implements SplitedSentencesLayout.OnWordSelectListener {
    private int currentSegmentIndex;
    private int currentSentenceIndex;
    private ArrayList<ArrayList<SplitedSentence>> splitedSentences;
    private SplitedSentencesLayout.OnWordSelectListener listener;

    public SplitedSegmentsLayout(Context context) {
        super(context);
        init();
    }

    public SplitedSegmentsLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public SplitedSegmentsLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        init();
    }

    public SplitedSegmentsLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        setOrientation(LinearLayout.VERTICAL);
    }

    public void setSplitedSentences(int currentSegmentIndex, int currentSentenceIndex, ArrayList<ArrayList<SplitedSentence>> splitedSentences) {
        this.currentSegmentIndex = currentSegmentIndex;
        this.currentSentenceIndex = currentSentenceIndex;
        this.splitedSentences = splitedSentences;
        updateView(true);
    }

    public void updateView(boolean sentencesChanged) {
        if (sentencesChanged) {
            removeAllViews();
            for (int i = 0; i < splitedSentences.size(); i++) {
                SplitedSentencesLayout splitedSentencesLayout = (SplitedSentencesLayout) LayoutInflater.from(getContext()).inflate(R.layout.splited_setence_layout, this, false);
                splitedSentencesLayout.setOnWordSelectListener(this);
                addView(splitedSentencesLayout, LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);

            }
        }

        for (int i = 0; i < getChildCount(); i++) {
            SplitedSentencesLayout splitedSentencesLayout = ((SplitedSentencesLayout) getChildAt(i));
            ArrayList<SplitedSentence> sentences = splitedSentences.get(i);
            splitedSentencesLayout.setSplitedSentences(i, currentSegmentIndex == i ? currentSentenceIndex : -1, sentences);
        }
    }

    public SplitedSentence getCurrentSplitedSentence() {
        return splitedSentences.get(currentSegmentIndex).get(currentSentenceIndex);
    }

    public void setOnWordSelectListener(SplitedSentencesLayout.OnWordSelectListener listener) {
        this.listener = listener;
    }

    @Override
    public void onSelect(int segmentId, int sentenceIndex, String word, SplitedSentence splitedSentence) {
        currentSegmentIndex = segmentId;
        currentSentenceIndex = sentenceIndex;
        updateView(false);
        if (listener != null) {
            listener.onSelect(segmentId, sentenceIndex, word, splitedSentence);
        }
    }
}
