package com.ellabook.project.ellareader.ui.read;

import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;

import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.biz.BizReader;
import com.ellabook.project.ellareader.book.bean.BookContainer;

import org.cocos2dx.lib.Cocos2dxActivity;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;

import cn.ellabook.EllaBookViewer;
import cn.ellabook.ReaderActivity;
import ellax.bookmanager.BookManager;

public class BookReader {
    private static volatile long lastJumpTime = 0L;
    public static final long TIME_DIVIDER = 2500L;

    public static boolean isCocos2dAvailable() {
        return Cocos2dxActivity.getContext() == null;
    }

    public static void bookRead(Context context, BookContainer bookContainer, boolean isTryRead, boolean isFinished) {
        BizReader.getInstance().bookStatus(null, bookContainer.getBookCode(), null, new HttpServiceCallBack<Boolean>() {
            @Override
            public void onHttpServiceFinished(Boolean s) {
                if (s != null && s) {
                    _bookRead(context, bookContainer, isTryRead, isFinished);
                } else {
                    ToastUtils.showCenterToast("图书下架，暂时无法阅读，先去看看其他书吧~");
                }
            }

            @Override
            public void onHttpServiceError(int i, String s) {
                if (i == 2) {
                    //网络错误，这里直接放行
                    _bookRead(context, bookContainer, isTryRead, isFinished);
                } else {
                    ToastUtils.showCenterToast(s == null ? "服务器返回异常" : s);
                }
            }
        });
    }

    private static Activity getActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity) context;
        } else if (context instanceof ContextWrapper) {
            return getActivity(((ContextWrapper) context).getBaseContext());
        }
        return null;

    }

    public static void _bookRead(Context context, BookContainer bookContainer, boolean isTryRead, boolean isFinished) {
        if (!isCocos2dAvailable()) {
            return;
        }
        if (System.currentTimeMillis() < lastJumpTime + TIME_DIVIDER) {
            return;
        }
        lastJumpTime = System.currentTimeMillis();
        String path = null;
        try {
            path = BookManager.getResourceForReader(bookContainer.getBookCode(), isTryRead).getPath();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            ToastUtils.showToast("书籍资源异常，请删除后重新下载");
            return;
        }
        Intent intent = new Intent(context, BookReaderActivity.class);
        intent.putExtra(ReaderActivity.KEY_BOOK_PATH, path);
        intent.putExtra("bookContainer", bookContainer);
        intent.putExtra("isTryRead", isTryRead);
        intent.putExtra("isFinished", isFinished);
        context.startActivity(intent);
    }

    public static void courseRead(Context context, BookContainer bookContainer, long mapId, boolean isFinished, int passNumber) {
        courseRead(context, bookContainer, mapId, 0, isFinished, passNumber);
    }

    public static void courseRead(Context context, BookContainer bookContainer, long mapId, int page, boolean isFinished, int passNumber) {
        BizReader.getInstance().bookStatus(null, bookContainer.getBookCode(), bookContainer.getId(), new HttpServiceCallBack<Boolean>() {
            @Override
            public void onHttpServiceFinished(Boolean s) {
                if (s != null && s) {
                    _courseRead(context, bookContainer, mapId, page, isFinished, passNumber);
                } else {
                    ToastUtils.showCenterToast("图书下架，暂时无法阅读，先去看看其他书吧~");
                }
            }

            @Override
            public void onHttpServiceError(int i, String s) {
                if (i == 2) {
                    //网络错误，这里直接放行
                    _courseRead(context, bookContainer, mapId, page, isFinished, passNumber);
                } else {
                    ToastUtils.showCenterToast(s == null ? "服务器返回异常" : s);
                }
            }
        });
    }

    public static void _courseRead(Context context, BookContainer bookContainer, long mapId, int page, boolean isFinished, int passNumber) {
        if (!isCocos2dAvailable()) {
            return;
        }
        if (System.currentTimeMillis() < lastJumpTime + 1000l) {
            return;
        }
        lastJumpTime = System.currentTimeMillis();
        String path = null;
        try {
            path = BookManager.getResourceForReader(bookContainer.getBookCode(), false).getPath();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            ToastUtils.showToast("书籍资源异常，请删除后重新下载");
            return;
        }
        Intent intent = new Intent(context, BookReaderActivity.class);
        intent.putExtra(ReaderActivity.KEY_BOOK_PATH, path);
        intent.putExtra(ReaderActivity.KEY_CURRENT_PAGE, page);
        intent.putExtra("bookContainer", bookContainer);
        intent.putExtra("mapId", mapId);
        intent.putExtra("isFinished", isFinished);
        intent.putExtra("passNumber", passNumber);
        context.startActivity(intent);
    }

    public static void finishReader() {
        EllaBookViewer.endBookViewer();
    }

    public static void gotoPage(int pageNumber) {
        EllaBookViewer.gotoPage(pageNumber);
        if (Cocos2dxActivity.getContext() != null && Cocos2dxActivity.getContext() instanceof BookReaderActivity) {
            ((BookReaderActivity) Cocos2dxActivity.getContext()).cleanRunnable();
        }
    }

    public static void restartCurrentPage() {
        EllaBookViewer.restartCurrentPage();

    }

    public static void restartBook() {
        EllaBookViewer.gotoPage(1);
    }

    public static void restartBookWithMission() {
        EllaBookViewer.gotoPage(1);
        EllaBookViewer.setBookPlayMode(EllaBookViewer.PLAY_MODE_LEARN);
    }

    private static MissionService sSelfStudyService;

    public static void init(MissionService sSelfStudyService) {
        BookReader.sSelfStudyService = sSelfStudyService;
    }


    public interface MissionService {
        public void onDone(FragmentManager fragmentManager, int id, String tag, boolean ispassed, long mapid,
                           long bookid, ArrayList<String> toEndPassReadStartEnds);

        public void showPowerStone(FragmentManager fragmentManager, int passCounts, int maxCounts, long missionId, long mapId, String bookCover, HashMap<Integer, Integer> pageMap, boolean hidePowerRemine, boolean hideControl);
    }

    public static void onSelfStudyDone(FragmentManager fragmentManager, int id, String tag, boolean ispassed, long mapid,
                                       long bookid, ArrayList<String> toEndPassReadStartEnds) {
        sSelfStudyService.onDone(fragmentManager, id, tag, ispassed, mapid, bookid, toEndPassReadStartEnds);
    }


    public static void showPowerStone(FragmentManager fragmentManager, int passCounts, int maxCounts, long missionId, long mapId, String bookCover, HashMap<Integer, Integer> pageMap, boolean hidePowerRemine, boolean hideControl) {
        sSelfStudyService.showPowerStone(fragmentManager, passCounts, maxCounts, missionId, mapId, bookCover, pageMap, hidePowerRemine, hideControl);
    }
}
