package com.ellabook.project.ellareader.ui.read;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.ellabook.project.base.ui.theme.dialog.EllaBaseDialogFragment;
import com.ellabook.project.ellareader.R;

import static com.ellabook.project.base.util.Converter.dip2px;

public class BookOffShelvesDialog extends EllaBaseDialogFragment {

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT
        );
        getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        getDialog().setCanceledOnTouchOutside(false);
        getDialog().setCancelable(false);
    }

    @Override
    protected View beforeViewAdd(View view, ViewGroup container) {
        View result= super.beforeViewAdd(view, container);
        result.findViewById(R.id.vConfirm).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (getActivity()!=null) {
                    getActivity().finish();
                }
            }
        });
        result.findViewById(R.id.vClose).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (getActivity()!=null) {
                    getActivity().finish();
                }
            }
        });



        return result;
    }

    @Override
    public int getLayoutFile() {
        return R.layout.dialog_book_offshelves;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return super.onCreateDialog(savedInstanceState);
    }
}
