package com.ellabook.project.ellareader.book.bean;


import android.os.Parcel;
import android.os.Parcelable;

import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.ellareader.R;

import ellax.bookmanager.ReaderResource;

public class HttpPicBookInfo implements Parcelable, BookContainer {

    /**
     * coverUrl :
     * goodsCode :
     * goodsName :
     * levelCode :
     * picBookCode :
     * resourceUrl :
     */

    public String coverUrl;//封面
    public String goodsCode;//商品code
    public String goodsName;//图书名称
    public String levelCode;//图书级别
    @Deprecated
    public String lexileLevel;//图书级别数值
    public String lexileLevelCode;//图书级别数值
    public String picBookCode;//绘本
    public String bookCode;//绘本
    public String resourceUrl;//绘本资源URL

    public boolean bought;//是否已购
    public boolean available;//是否下架
    public String version;//是否已购

    public int selectType;//0 未选中 1 选中(客户端添加)

    public HttpPicBookInfo() {
    }

    @Override
    public String getBookName() {
        return goodsName;
    }

    @Override
    public String getBookCode() {
        return bookCode;
    }

    @Override
    public String getPicBookCode() {
        return picBookCode;
    }

    @Override
    public String getBookType() {
        return ApplicationHolder.getContext().getString(R.string.pic_book_type);
    }

    @Override
    public String getBookLevel() {
        return levelCode;
    }

    @Override
    public String getResourceCode() {
        return bookCode;
    }

    @Override
    public String getBookResourceVersion() {
        return "";
    }

    // TODO:bqf 2019-07-12 readerVersion
    @Override
    public String getBookReaderVersion() {
        return "";
    }

    @Override
    public int getDiamondNum() {
        return 0;
    }

    @Override
    public int getPassNum() {
        return 0;
    }

    @Override
    public long getId() {
        return -1;
    }

    @Override
    public String getBookCover() {
        return coverUrl;
    }

    @Override
    public String getMissionCode() {
        return "";
    }

    // TODO:bqf 2019-07-12 这坨东西统一放在一个地方。。。
    @Override
    public ReaderResource getMainResource() {
        ReaderResource resource = new ReaderResource();
        resource.url = resourceUrl;
        resource.resourceType = ReaderResource.RESOURCE_TYPE_BOOK;
        resource.bookCode = getBookCode();
        resource.resourceVersion = version;
        resource.extraInfo=new BookExtraInfo(getBookName(),levelCode,goodsCode,picBookCode);
        return resource;
    }

    @Override
    public boolean isPublicResource() {
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.available ? (byte) 1 : (byte) 0);
        dest.writeString(this.coverUrl);
        dest.writeString(this.goodsCode);
        dest.writeString(this.goodsName);
        dest.writeString(this.levelCode);
        dest.writeString(this.lexileLevel);
        dest.writeString(this.lexileLevelCode);
        dest.writeString(this.picBookCode);
        dest.writeString(this.bookCode);
        dest.writeString(this.resourceUrl);
        dest.writeByte(this.bought ? (byte) 1 : (byte) 0);
        dest.writeString(this.version);
        dest.writeInt(this.selectType);
    }

    protected HttpPicBookInfo(Parcel in) {
        this.available = in.readByte() != 0;
        this.coverUrl = in.readString();
        this.goodsCode = in.readString();
        this.goodsName = in.readString();
        this.levelCode = in.readString();
        this.lexileLevel = in.readString();
        this.lexileLevelCode = in.readString();
        this.picBookCode = in.readString();
        this.bookCode = in.readString();
        this.resourceUrl = in.readString();
        this.bought = in.readByte() != 0;
        this.version = in.readString();
        this.selectType = in.readInt();
    }

    public static final Creator<HttpPicBookInfo> CREATOR = new Creator<HttpPicBookInfo>() {
        @Override
        public HttpPicBookInfo createFromParcel(Parcel source) {
            return new HttpPicBookInfo(source);
        }

        @Override
        public HttpPicBookInfo[] newArray(int size) {
            return new HttpPicBookInfo[size];
        }
    };
}