package com.ellabook.project.ellareader.biz;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ellabook.project.ellareader.bean.ReadRecord;

import java.util.List;

@Dao
public interface ReadRecordDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(ReadRecord record);

    @Query("delete from read_record where uid = :uid and bookCode = :bookCode and pageNum=:pageNum and totalPage=:totalPage and readModel=:readModel  and readStart=:readStart and endTime=:endTime")
    void delete(String uid,String bookCode, String readModel, int pageNum, int totalPage, long readStart, long endTime);

    @Query("select * from read_record where uid = :uid")
    List<ReadRecord> queryUnuploaded(String uid);

}
