package com.ellabook.project.ellareader.biz;

import com.ellabook.netwrok.http.EllaHttpService;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.bean.FeedbackBean;
import com.ellabook.project.ellareader.bean.HttpWordDetails;
import com.ellabook.project.ellareader.bean.ReadRecord;
import com.ellabook.project.ellareader.bean.ReadRecordlra;
import com.ellabook.project.ellareader.bean.StoneNum;
import com.ellabook.project.ellareader.bean.StoneResult;
import com.google.gson.Gson;
import com.trello.rxlifecycle2.LifecycleTransformer;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import ellax.base.helper.AppExecutors;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class BizReader {
    private static class Holder {
        private static BizReader sBizMission = new BizReader();
    }

    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>();


    private BizReader() {
    }

    public static BizReader getInstance() {
        return Holder.sBizMission;
    }


    public void getWordDetails(LifecycleTransformer lifecycleTransformer, String uid, String word,String bookCode,int pageId, HttpServiceCallBack<HttpWordDetails> callback) {
        Map<String, Object> map = EllaHttpService.createReuestMap();
        map.put("uid", uid);
        map.put("word", word);
        map.put("bookCode", bookCode);
        map.put("pageId", pageId);
        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).getWordDetails(EllaHttpService.generateRequestBody(map)),
                callback);
    }

    public void uploadAnswerRecord(LifecycleTransformer lifecycleTransformer, long id, int totalNum, String json,
                                   HttpServiceCallBack<StoneResult> callback) {
        Map<String, Object> map = EllaHttpService.createReuestMap();
        map.put("id", id);
        map.put("totalNum", totalNum);
        map.put("jsonContent", json);
        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).uploadAnswerRecord(EllaHttpService.generateRequestBody(map)),
                callback);
    }

    public void getStoneNums(LifecycleTransformer<List<StoneNum>> lifecycleTransformer, long id, HttpServiceCallBack<List<StoneNum>> callback) {
        Map<String, Object> map = EllaHttpService.createReuestMap();
        map.put("id", id);
        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).getStoneNums(EllaHttpService.generateRequestBody(map)),
                callback);
    }

    public void addUserWord(LifecycleTransformer lifecycleTransformer, String bookCode, String missionCode,
                            int pageNum, String sentence, String word, String ellaSpeechUrl, HttpServiceCallBack callBack) {
        Map<String, Object> map = EllaHttpService.createReuestMap();
        map.put("bookCode", bookCode);
        map.put("missionCode", missionCode);
        map.put("pageNum", pageNum);
        map.put("sentence", sentence);
        map.put("word", word);
        map.put("ellaSpeechUrl", ellaSpeechUrl);
        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).addUserWord(EllaHttpService.generateRequestBody(map)),
                callBack);
    }

    public static SimpleDateFormat getDataFormat() {
        if (dateFormat.get() == null) {
            dateFormat.set(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        return dateFormat.get();
    }

    List<ReadRecordlra> uploadingIra = Collections.synchronizedList(new ArrayList<>());

    public void uploadReadInfoMission(LifecycleTransformer lifecycleTransformer, long missionId, String bookCode, int pageNum, int totalPage, ArrayList<String> readStartEnds, HttpServiceCallBack<Boolean> callback) {
        AppExecutors.diskIO(new Runnable() {
            @Override
            public void run() {
                uploadReadInfoMissionAsync(lifecycleTransformer, missionId, bookCode, pageNum, totalPage, readStartEnds, callback);
            }
        });
    }

    public void uploadReadInfoMissionAsync(LifecycleTransformer lifecycleTransformer, long missionId, String bookCode, int pageNum, int totalPage, ArrayList<String> readStartEnds, HttpServiceCallBack<Boolean> callback) {
        ArrayList<ReadRecordStartEnd> readStartEndMap = new ArrayList<ReadRecordStartEnd>();
        for (int i = 0; i + 1 < readStartEnds.size(); i += 2) {
            try {
                long start = Long.parseLong(readStartEnds.get(i));
                long end = Long.parseLong(readStartEnds.get(i + 1));
                if (end > start) {
                    readStartEndMap.add(new ReadRecordStartEnd(start, end));
                }
            } catch (Exception e) {

            }
        }
        ReadRecordlra current = ReadRecordlra.build(missionId, new Gson().toJson(readStartEndMap), UserInfoProvider.getUserId());

        ArrayList<ReadRecordlra> needUpload = new ArrayList<>();
        needUpload.add(current);
        List<ReadRecordlra> unuploaded = BizReadDataBase.getInstance().readRecordlrdDao().queryUnuploaded(UserInfoProvider.getUserId());
        if (unuploaded != null && !unuploaded.isEmpty()) {
            unuploaded.removeAll(uploadingIra);
        }
        if (unuploaded != null && !unuploaded.isEmpty()) {
            uploadingIra.addAll(unuploaded);
            needUpload.addAll(unuploaded);
        }

        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).uploadReadInfoMissionBatch(generateRequestBody(needUpload)),
                new HttpServiceCallBack<Boolean>() {
                    @Override
                    public void onHttpServiceFinished(Boolean o) {
                        AppExecutors.diskIO(new Runnable() {
                            @Override
                            public void run() {
                                if (unuploaded != null && !unuploaded.isEmpty()) {
                                    for (ReadRecordlra readRecord : unuploaded) {
                                        BizReadDataBase.getInstance().readRecordlrdDao().delete(readRecord.uid, readRecord.missionId, readRecord.readStartEnds);
                                    }
                                    uploadingIra.removeAll(unuploaded);
                                }
                            }
                        });
                        if (callback != null) {
                            callback.onHttpServiceFinished(o);
                        }
                    }

                    @Override
                    public void onHttpServiceError(int i, String s) {
                        if (unuploaded != null && !unuploaded.isEmpty()) {
                            uploadingIra.removeAll(unuploaded);
                        }
                        AppExecutors.diskIO(new Runnable() {
                            @Override
                            public void run() {
                                BizReadDataBase.getInstance().readRecordlrdDao().insert(current);
                            }
                        });
                        if (callback != null) {
                            callback.onHttpServiceError(i, s);
                        }

                    }
                });
    }

    public static RequestBody generateRequestBody(ArrayList arrayList) {
        try {
            Gson gson = new Gson();
            return RequestBody.create(MediaType.parse("application/json"), gson.toJson(arrayList));
        } catch (Exception var4) {
            var4.printStackTrace();
            return null;
        }
    }

    List<ReadRecord> uploading = Collections.synchronizedList(new ArrayList<>());

    public void uploadReadInfoEnBook(LifecycleTransformer lifecycleTransformer, String bookCode, int pageNum, int totalPage, long readStart, long endTime, HttpServiceCallBack<Boolean> callback) {
        AppExecutors.diskIO(new Runnable() {
            @Override
            public void run() {
                uploadReadInfoEnBookAsync(lifecycleTransformer, bookCode, pageNum, totalPage, readStart, endTime, callback);
            }
        });
    }

    public void uploadReadInfoEnBookAsync(LifecycleTransformer lifecycleTransformer, String bookCode, int pageNum, int totalPage, long readStart, long endTime, HttpServiceCallBack<Boolean> callback) {

        ReadRecord current = ReadRecord.build(bookCode, pageNum, totalPage, readStart, endTime, UserInfoProvider.getUserId());
        ArrayList<ReadRecord> needUpload = new ArrayList<>();
        needUpload.add(current);
        List<ReadRecord> unuploaded = BizReadDataBase.getInstance().readRecordDao().queryUnuploaded(UserInfoProvider.getUserId());
        if (unuploaded != null && !unuploaded.isEmpty()) {
            unuploaded.removeAll(uploading);
        }
        if (unuploaded != null && !unuploaded.isEmpty()) {
            uploading.addAll(unuploaded);
            needUpload.addAll(unuploaded);
        }

        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).uploadReadInfoBatch(generateRequestBody(needUpload)),
                new HttpServiceCallBack<Boolean>() {
                    @Override
                    public void onHttpServiceFinished(Boolean o) {

                        AppExecutors.diskIO(new Runnable() {
                            @Override
                            public void run() {
                                if (unuploaded != null && !unuploaded.isEmpty()) {
                                    for (ReadRecord readRecord : unuploaded) {
                                        BizReadDataBase.getInstance().readRecordDao().delete(readRecord.uid, readRecord.bookCode, readRecord.readModel, readRecord.pageNum, readRecord.totalPage, readRecord.readStart, readRecord.endTime);
                                    }
                                    uploading.removeAll(unuploaded);
                                }
                            }
                        });
                        if (callback != null) {
                            callback.onHttpServiceFinished(o);
                        }
                    }

                    @Override
                    public void onHttpServiceError(int i, String s) {
                        if (unuploaded != null && !unuploaded.isEmpty()) {
                            uploading.removeAll(unuploaded);
                        }
                        AppExecutors.diskIO(new Runnable() {
                            @Override
                            public void run() {
                                BizReadDataBase.getInstance().readRecordDao().insert(current);
                            }
                        });
                        if (callback != null) {
                            callback.onHttpServiceError(i, s);
                        }

                    }
                });
    }

    public static class ReadRecordStartEnd {
        public Long start;
        public Long end;

        public ReadRecordStartEnd() {
        }

        public ReadRecordStartEnd(Long start, Long end) {
            this.start = start;
            this.end = end;
        }
    }

    public void uploadCourseStoneNum(LifecycleTransformer lifecycleTransformer, String bookCode, int stoneNum, HttpServiceCallBack<Boolean> callback) {
        Map<String, Object> map = EllaHttpService.createReuestMap();
        map.put("bookCode", bookCode);
        map.put("stoneNum", stoneNum);
        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).uploadCourseStoneNum(EllaHttpService.generateRequestBody(map)),
                callback);
    }


    public void bookStatus(LifecycleTransformer lifecycleTransformer, String bookCode, Long missionId, HttpServiceCallBack<Boolean> callback) {
        Map<String, Object> map = EllaHttpService.createReuestMap();
        map.put("bookCode", bookCode);
        map.put("uid", UserInfoProvider.getUserId());
        if (missionId != null) {
            map.put("missionId", missionId);
        }
        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).bookStatus(EllaHttpService.generateRequestBody(map)),
                callback);
    }

    /**
     * 获取英语翻译，用户反馈列表
     *
     * @param lifecycleTransformer LifecycleTransformer
     * @param callback             回调
     */
    public void getFeedBackList(LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<List<FeedbackBean>> callback) {
        Map<String, Object> map = EllaHttpService.createReuestMap();
        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).feedbackList(EllaHttpService.generateRequestBody(map)),
                callback);
    }

    public void commitFeedback(LifecycleTransformer lifecycleTransformer, int recoveryType, String content, String explains, String bookCode, String pageId, HttpServiceCallBack<Object> callback) {
        Map<String, Object> map = EllaHttpService.createReuestMap();
        map.put("recoveryType", recoveryType);
        map.put("content", content);
        map.put("explains", explains);
        map.put("bookCode", bookCode);
        map.put("pageId", pageId);
        map.put("uid", UserInfoProvider.getUserId());
        EllaHttpService.handleRequest(lifecycleTransformer,
                EllaHttpService.buildInterfaceImpl(ApiRead.class).commitFeedback(EllaHttpService.generateRequestBody(map)),
                callback);
    }


}
