package cn.ellabook;

/**
 * Created by java on 2018/7/18.
 */

public class ReaderControlerImp implements ReaderControler {

    @Override
    public void setResolutionPolicy(String resolutionPolicy) {
        NativeCpp.setResolutionPolicy(resolutionPolicy);
    }

    @Override
    public void setBookPlayMode(byte playMode) {
        NativeCpp.setBookPlayMode(playMode);
    }

    @Override
    public byte getBookPlayMode() {
        return (byte) NativeCpp.getBookPlayMode();
    }

    @Override
    public void endBookViewer() {
        NativeCpp.bookQuit();
    }

    @Override
    public void startNewBook(String path, int currentPage) {
        NativeCpp.setBookPath(path, currentPage);
    }

    @Override
    public void pause() {
        NativeCpp.pausePlay(true);
    }

    @Override
    public void gotoPage(int page) {
        NativeCpp.gotoPage(page);
    }

    @Override
    public void resume() {
        NativeCpp.resumePlay(true);
    }

    @Override
    public void restartCurrentPage() {
        NativeCpp.restartCurrentPage();
    }

    @Override
    public void pageDown() {
        NativeCpp.pageDown();
    }

    @Override
    public void pageUp() {
        NativeCpp.pageUp();
    }

    @Override
    public int getCurrentPage() {
        return NativeCpp.getCurrentPage();
    }

    @Override
    public int getBookPages() {
        return NativeCpp.getBookPages();
    }

    @Override
    public boolean isLastPage() {
        return NativeCpp.isLastPage();
    }

    @Override
    public boolean isMenuEnable() {
        return NativeCpp.isPageReady();
    }
}
