package cn.ellabook;

import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

import com.ellabook.project.base.util.device.MemoryUtil;
import com.ellabook.project.base.util.device.ScreenUtil;
import com.ellabook.project.base.util.io.FileUtils;

import java.io.File;

/**
 * NativeCpp Package Protect .....
 * Created by java on 2018/7/18.
 */

public abstract class ReaderActivity extends EllaBookViewerActivity implements BookViewerCallback {

    public static final String KEY_CURRENT_PAGE = "currentPage";
    //    public static final String KEY_PRELOAD_MODE = "preloadMode";
    public static final String KEY_BOOK_PATH = "bookPath";

    private ReaderControler mReaderControler;
    private View mReaderControlView;

    private String mBookPath;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ReadTimeCounter.getInstance().onActivityCreate();
        mBookPath = getIntent().getStringExtra(KEY_BOOK_PATH);
        initLib();
        initWindow();
        setKeepScreenOn(true);
        initResource();
        EllaBookViewer.setBookViewerCallback(this);
        NativeCpp.enablePageCallback();
        setReadControlView(createReaderControlView());
        startReader();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        String bookPath = intent.getStringExtra(KEY_BOOK_PATH);
        if (TextUtils.equals(bookPath, mBookPath)) {
            return;
        }

        //打开新的绘本
        startReader();
    }

    //初始化so库
    private void initLib() {
        try {
            ApplicationInfo ai = getPackageManager().getApplicationInfo(getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String libName = bundle.getString("android.app.lib_name");
            System.loadLibrary(libName);
        } catch (Exception var4) {
            var4.printStackTrace();
        }
    }

    //设置window
    private void initWindow() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setFlags(16777216, 16777216);
        }
    }

    // TODO:bqf 2019-07-04 scale
    private void initResource() {
        float scale = ScreenUtil.getDeviceHeight(this) * 1f / (ScreenUtil.getDeviceWidth(this));
        if (isIphone1334())
            NativeCpp.initResource(1334, 750, scale);
        else
            NativeCpp.initResource(2208, 1242, scale);


        if (ScreenUtil.checkIfFullScreen(this)) {
            EllaBookViewer.setResolutionPolicy(EllaBookViewer.RESOLUTION_POLICY_WIDTH);
        } else {
            EllaBookViewer.setResolutionPolicy(EllaBookViewer.RESOLUTION_POLICY_HEIGHT);
        }
        try {
            long memoryFree = MemoryUtil.getMemoryFree(this);
            if (memoryFree > 0) {
                EllaBookViewer.setDeviceMemorySize(0.9f * MemoryUtil.getMemoryFree(this) / 1024f / 1024f);
            }
        } catch (Exception e) {
            Log.e("ellareader", "get memory error", e);
        }
    }

    private boolean isIphone1334() {
        if (new File(mBookPath).getName().equals("Iphone1334")) {
            return true;
        }
        return false;
    }

    //设置
    private void setReadControlView(View readerControlView) {
        if (readerControlView == null) {
            return;
        }

        if (mReaderControlView != null) {
            mFrameLayout.removeView(mReaderControlView);
        }

        mReaderControlView = readerControlView;
        this.mFrameLayout.addView(readerControlView);
    }

    protected abstract View createReaderControlView();

    private void startReader() {
        String bookPath = getIntent().getStringExtra(KEY_BOOK_PATH);
        int currentPage = getIntent().getIntExtra(KEY_CURRENT_PAGE, 0);
//        byte preloadMode = getIntent().getByteExtra(KEY_PRELOAD_MODE, EllaBookViewer.PRELOAD_MODE_THIED);
        if (TextUtils.isEmpty(bookPath)) {
            throw new IllegalArgumentException("bookPath must not be empty!");
        }

        mBookPath = bookPath;
//        if (isIphone1334())
//            bookPath = bookPath + File.separator + "Iphone1334";
//        else
//            bookPath = bookPath + File.separator + "Iphone2208";
        boolean b = FileUtils.isFileExists(bookPath);
        EllaBookViewer.setPreloadMode(EllaBookViewer.PRELOAD_MODE_SINGLE);
        NativeCpp.initBook(bookPath, currentPage);
    }

    public ReaderControler getReaderControler() {
        if (mReaderControler == null) {
            mReaderControler = new ReaderControlerImp();
        }

        return mReaderControler;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        EllaBookViewer.setBookViewerCallback(null);
    }

    @Override
    public void finish() {
        super.finish();
        NativeCpp.bookQuit();
    }

    @Override
    protected void onResume() {
        super.onResume();
        NativeCpp.enablePageCallback();
        ReadTimeCounter.getInstance().onActivityResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
        ReadTimeCounter.getInstance().onActivityPause();
    }

    @Override
    public void onViewerNotice(int var1) {
        runOnUiThread(() -> onViewerNotice2(var1));
    }

    public void onViewerNotice2(int var1) {

    }

    @Override
    public final void isViewerReady(boolean var1) {
        runOnUiThread(() -> isViewerReady2(var1));
    }

    public void isViewerReady2(boolean var1) {

    }

    @Override
    public final void onTipsEnable(boolean var1) {
        runOnUiThread(() -> onTipsEnable2(var1));
    }

    public void onTipsEnable2(boolean var1) {

    }

    @Override
    public final void onTipsShow(boolean var1) {
        runOnUiThread(() -> onTipsShow2(var1));
    }

    public void onTipsShow2(boolean var1) {

    }

    @Override
    public final void onBookEnd() {
        runOnUiThread(() -> onBookEnd2());
    }

    public void onBookEnd2() {

    }

    @Override
    public void onSubtitleSelect(Object[] objects) {
        //do nothing
    }

    @Override
    public void onSubtitleDeacon(String s) {
        //do nothing
    }

    @Override
    public final void onPageStateNotice(int i, int i1) {
        runOnUiThread(() -> onPageStateNotice2(i, i1));
    }

    public void onPageStateNotice2(int i, int i1) {

    }

    @Override
    public final View getHudView(ViewGroup parent) {
        return mReaderControlView;
    }

    @Override
    public final void onMemoryOverflow() {
        runOnUiThread(() -> onMemoryOverflow2());
    }

    public void onMemoryOverflow2() {
    }

    @Override
    public final void onClassModeEnd() {
        runOnUiThread(() -> onClassModeEnd2());
    }

    public void onClassModeEnd2() {

    }

    public void onClassModeResult2(String s) {
    }

    /**
     * 课堂模式结果回调函数，正常答题时数组只有一个结果，未答题翻页或者答题过程中
     * 翻页会存在多个结果
     */
    public void onClassModeResult(final String[] results) {
    }


    @Override
    public final void onSubtitleSplit(int segmentID, int sentenceID, Object[] vSubtitleSplitData, String soundFile) {
        runOnUiThread(() -> onSubtitleSplit2(segmentID, sentenceID, vSubtitleSplitData, soundFile));
    }

    public void onSubtitleSplit2(int segmentID, int sentenceID, Object[] vSubtitleSplitData, String soundFile) {

    }
}