package com.ellabook.project.ellareader.ui.read;

import android.app.Fragment;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.R;

import cn.ellabook.EllaBookViewer;
import cn.ellabook.EllaBookViewerHelper;

/**
 * 作者：wangtao on 2019/4/10 16:49
 * 邮箱：863010067@qq.com
 * 课程关卡引导页
 */
public class SelfStudyGuideFragment extends Fragment {


    public static final String GUIDE_KEY = "SelfStudyGuideFragment.GUIDE_KEY";

    public static boolean checkShowGuide(BookReaderActivity context) {
        if (!UserInfoProvider.isGuideAvailable(GUIDE_KEY, true))
            return false;

        EllaBookViewerHelper.pause();
        UserInfoProvider.setGuide(GUIDE_KEY, false);
        context.getReaderControler().pause();//暂停播放
        SelfStudyGuideFragment courseGuideFragment = new SelfStudyGuideFragment();
        Bundle bundle = new Bundle();
        courseGuideFragment.setArguments(bundle);
        context.getFragmentManager().beginTransaction().replace(R.id.llBookViewControll, courseGuideFragment).commitAllowingStateLoss();
        return true;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_fragment_guide_split_words, container, false);
        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
        view.findViewById(R.id.tvNextThree).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
        return view;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        playVoice(R.raw.welcome_read_to_learn);
    }

    public boolean isVoiced(String voiceName) {
        if (UserInfoProvider.isGuideAvailable(voiceName, false)) {
            return true;
        } else {
            UserInfoProvider.setGuide(voiceName, true);
            return false;
        }
    }


    @Override
    public void onStop() {
        super.onStop();
    }


    public void playVoice(int voiceId) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play(Uri.parse("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId));
        }
    }

    private void dismiss() {
        AudioPlayer.stopPlay();
        getActivity().getFragmentManager().beginTransaction().remove(this).commitAllowingStateLoss();
        if (EllaBookViewer.getBookPlayMode() != EllaBookViewer.PLAY_MODE_LEARN) {
            EllaBookViewer.setBookPlayMode(EllaBookViewer.PLAY_MODE_LEARN);
        }
        EllaBookViewerHelper.resume();
    }

}

