package com.ellabook.project.ellareader.ui.read;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;

import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.security.ParentCheckUtil;
import com.ellabook.project.base.share.ShareUtil;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.R;

import java.util.Map;

import cn.ellabook.EllaBookViewer;
import cn.ellabook.EllaBookViewerHelper;
import ellax.log.Logger;

public class MenuFragment extends Fragment {
    boolean  mIsFinished;
    boolean  mShowModeSwitch;
    TextView vModeSwitch;
    TextView tvShare;
    private long bookId;

    static MenuFragment get(long bookId, ChekStoneCallback callback) {
        MenuFragment fragment = new MenuFragment();
        Bundle bundle = new Bundle();
        bundle.putLong("bookId", bookId);
        fragment.setArguments(bundle);
        fragment.bookId = bookId;
        return fragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater,
                             @Nullable ViewGroup container,
                             Bundle savedInstanceState) {
        return inflater.inflate(R.layout.ellabook_read_menu2, container, false);
    }

    protected void injectView(View view) {
        vModeSwitch = view.findViewById(R.id.vModeSwitch);
        tvShare = view.findViewById(R.id.tvShare);
        view.findViewById(R.id.tvExit).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onExitClick();
            }
        });
        view.findViewById(R.id.vModeSwitch).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onSelfStudy();
            }
        });
        view.findViewById(R.id.tvShare).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.record("en_read_share");
                onShareClick();
            }
        });
        view.findViewById(R.id.tvReread).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.record("en_read_back");
                onRereadClick();
            }
        });
        view.findViewById(R.id.ivClose).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onCloseClick();
            }
        });

    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        bookId = getArguments().getLong("bookId");
        injectView(view);
        if (mShowModeSwitch) {
            if (EllaBookViewer.getBookPlayMode() == EllaBookViewer.PLAY_MODE_LEARN) {
                switchDrawbleTop(vModeSwitch, R.drawable.pass_course_btn_answer);
                vModeSwitch.setText("Learn to Read");
            } else {
                switchDrawbleTop(vModeSwitch, R.drawable.pass_course_btn_self);
                vModeSwitch.setText("Read to learn");
            }
        } else {
            vModeSwitch.setVisibility(View.GONE);
        }

        if (UserInfoProvider.isVipAvailable()) {
            tvShare.setVisibility(View.GONE);
        } else {
            tvShare.setVisibility(View.GONE);
        }
        if (EllaBookViewerHelper.isAllExercisePages()) {
            vModeSwitch.setVisibility(View.GONE);
        } else {
            vModeSwitch.setVisibility(View.VISIBLE);
        }
        EllaBookViewerHelper.pause();
    }

    private static void switchDrawbleTop(TextView textView, @DrawableRes int drawResourse) {
        Drawable[] drawables = textView.getCompoundDrawables();

        if (drawables.length == 4 && drawables[1] != null) {
            Drawable newDrawable = textView.getResources().getDrawable(drawResourse);
            newDrawable.setBounds(drawables[1].getBounds());
            drawables[1] = newDrawable;
        }
        textView.setCompoundDrawables(drawables[0], drawables[1], drawables[2], drawables[3]);

    }

    void onExitClick() {
        ((BookReaderActivity) getActivity()).getReaderControler().endBookViewer();
    }

    void onSelfStudy() {
        if (mIsFinished) {
            getActivity().getFragmentManager().beginTransaction().remove(this).commitAllowingStateLoss();

            if (EllaBookViewer.getBookPlayMode() == EllaBookViewer.PLAY_MODE_LEARN) {
                EllaBookViewer.setBookPlayMode(EllaBookViewer.PLAY_MODE_CLASS);
                EllaBookViewerHelper.resume();
                Logger.record("en_read_change", "2");
                //                EllaBookViewer.restartCurrentPage();
            } else {
                Logger.record("en_read_change", "1");
                Map<Integer, Boolean> map = EllaBookViewer.getExercisePages();
                if (map != null) {
                    Log.v("reader_exercisePage", map.toString());
                }
                int currentPage = EllaBookViewer.getCurrentPage();
                if (map.containsKey(currentPage) && map.get(currentPage) != null && !map.get(currentPage)) {

                    //                    EllaBookViewer.restartCurrentPage();

                    if (!(EllaBookViewer.getCurrentPage() >= 2 &&
                            SelfStudyGuideFragment.checkShowGuide(((BookReaderActivity) getActivity())))) {
                        ToastUtils.showCenterToast("已进入Read to learn模式，点击文本内容可查看翻译");
                        EllaBookViewer.setBookPlayMode(EllaBookViewer.PLAY_MODE_LEARN);
                        EllaBookViewerHelper.resume();

                    }
                } else {
                    ToastUtils.showCenterToast("当前页面暂时不支持自学模式，请选择其他页面进入自学模式");
                    EllaBookViewerHelper.resume();

                }
            }

        } else {
            ToastUtils.showCenterToast("闯关成功后，才能开启自学模式");
        }
    }

    void onShareClick() {
        //分享绘本 需要父母确认
        final Activity activity = getActivity();
        if (activity != null && activity instanceof FragmentActivity) {
            ParentCheckUtil.show(((FragmentActivity) activity),
                    () -> ShareUtil.shareBook(activity, bookId));
        }
    }

    void onRereadClick() {
        getActivity().getFragmentManager().beginTransaction().remove(this).commitAllowingStateLoss();
        EllaBookViewer.restartCurrentPage();
        EllaBookViewerHelper.resume();
    }

    void onCloseClick() {
        getActivity().getFragmentManager().beginTransaction().remove(this).commitAllowingStateLoss();
        EllaBookViewerHelper.resume();
    }

    public void show(FragmentManager fragmentManager,
                     int id,
                     String tag,
                     boolean isFinished,
                     boolean showModeSwitch) {
        mIsFinished = isFinished;
        mShowModeSwitch = showModeSwitch;
        fragmentManager.beginTransaction().replace(id, this).commitAllowingStateLoss();
    }

    public boolean isVoiced(String voiceName) {
        if (UserInfoProvider.isGuideAvailable(voiceName, false)) {
            return true;
        } else {
            UserInfoProvider.setGuide(voiceName, true);
            return false;
        }
    }

    public void playVoice(int voiceId) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play(Uri.parse("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId));
        }
    }

    public interface ChekStoneCallback {
        boolean onDone();
    }
}
