package com.ellabook.project.ellareader.book.download;

import android.app.Application;

import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.book.IBookManager;
import com.ellabook.project.ellareader.book.bean.BookContainer;

import org.greenrobot.eventbus.EventBus;

import ellax.base.IdRetriever;
import ellax.bookmanager.BookEvent;
import ellax.bookmanager.BookManager;
import ellax.bookmanager.Poster;
import ellax.bookmanager.ReaderResource;

/**
 * created by dongdaqing 2018-10-29 16:50
 * <p>
 * 书籍资源管理(试读模式的资源存放地址不在用户目录下)
 */
public class BookManagerImpl implements IBookManager {

    @Override
    public void setup(Application app) {
        BookManager.setup(app, new Poster() {
            @Override
            public void post(Object o) {
                if (o instanceof BookEvent) {
                    BookEvent event = ((BookEvent) o);
                    // TODO:bqf 2019-07-12
                    EventBus.getDefault().post(event);

                }
            }
        }, new IdRetriever() {
            @Override
            public String getUid() {
                return UserInfoProvider.getUserId();
            }

            @Override
            public String getCid() {
                return UserInfoProvider.getUserId();
            }

        });
    }

    @Override
    public boolean isBookInstalled(String bookContainer) {
        return BookManager.isBookInstalled(bookContainer);
    }

//    @Override
//    public int getBookStatus(BookContainer bookContainer) {
//        return BookManager.gets();
//    }

    @Override
    public void download(BookContainer book, boolean tryRead, boolean isOnlyWifi) {
        BookManager.download(book, tryRead, isOnlyWifi);
    }

    @Override
    public void download(BookContainer book, boolean isOnlyWifi) {
        BookManager.download(book, isOnlyWifi);
    }

    @Override
    public void download(ReaderResource resource, boolean isOnlyWifi) {
        BookManager.download(resource, isOnlyWifi);
    }

    @Override
    public void pause(BookContainer book) {
        BookManager.pause(book);
    }

    @Override
    public void pause(ReaderResource resource) {
        BookManager.pause(resource);

    }

    @Override
    public void pauseAll() {
        BookManager.pauseAll();
    }

    @Override
    public void uninstallSync(BookContainer bookContainer) {
        BookManager.uninstallSync(bookContainer);
    }


    @Override
    public boolean isDownloading(BookContainer book) {
        return BookManager.isDownloading(book);
    }

    @Override
    public boolean isDownloading(ReaderResource resource) {
        return BookManager.isDownloading(resource);
    }

    @Override
    public boolean isBookUp2Date(String bookCode, String currentVersion, boolean publicResource) {
        return BookManager.isBookUp2Date(bookCode, currentVersion, publicResource);
    }
}
