package com.ellabook.project.ellareader.ui.read;


import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.text.style.LeadingMarginSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;

import com.ellabook.netwrok.http.EllaHttpService;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.imgspan.ClickableMovementMethod;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.Converter;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.AudioRecorder;
import com.ellabook.project.ellareader.AudioWordLayout;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ReaderModule;
import com.ellabook.project.ellareader.bean.FeedbackBean;
import com.ellabook.project.ellareader.bean.HttpWordDetails;
import com.ellabook.project.ellareader.biz.BizReader;
import com.ellabook.project.ellareader.ctrl.FeedbackRequestCache;
import com.ellabook.project.ellareader.ctrl.Utils;
import com.trello.rxlifecycle2.RxLifecycle;
import com.trello.rxlifecycle2.android.FragmentEvent;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import cn.ellabook.EllaBookViewerHelper;
import ellax.base.Callback;
import io.reactivex.subjects.BehaviorSubject;

/**
 * 作者：wangtao on 2019/4/1 17:28
 * 邮箱：863010067@qq.com
 * 分词模式
 */
public class SplitedWordDialogFragment extends DialogFragment implements SplitedSentencesLayout.OnWordSelectListener {

    private final BehaviorSubject<FragmentEvent> lifecycleSubject = BehaviorSubject.create();

    LinearLayout llRightDes;
    RelativeLayout rlWordLayout;
    ImageView ivWordIcon;
    TextView tvWordTextTip;
    RelativeLayout rlSentenceLayout;

    ImageView ivSentenceIcon;
    TextView tvSentenceTextTip;
    RelativeLayout rlEmptyLayout;
    NestedScrollView nsSentence;
    TextView tvSentenceContent;

    TextView tvSentenceContentTranslate;
    NestedScrollView nsWord;
    TextView tvWord;
    TextView tvAmericaAudio;
    TextView tvEnglandAudio;
    ImageView vLoading;
    ImageView vLoadSentence;

    View maskView;
    //单词错误提交
    RelativeLayout rlReportErrorWord;
    //句子错误提交
    RelativeLayout rlReportErrorSentence;
//    View viewAnchor;

    AudioWordLayout vWordAudioLayout;

    TextView tvWordDes;
    View tvAddWord;
    SplitedSegmentsLayout splitedSegmentsLayout;

    private int segmentID;
    private int sentenceID;
    private ArrayList<ArrayList<SplitedSentence>> list;
    private String bookCode;
    private String missionCode;
    private String sentenceSpeech;

    private String audioPath;
    private int pageNum;

    private HttpWordDetails httpWordDetails;
    private String mRecorderFilePath = null;

    //待翻译的英语句子
    private String mCurrentSentence;
    //翻译结果的句子
    private String mCurrentTranslate;

    //待翻译的单词
    private String word;
    //翻译后的单词
    private String wordTranslate;

    public static void show(Activity activity, ArrayList<ArrayList<SplitedSentence>> list, int segmentID, int sentenceID, String audioPath,
                            String bookCode, String missionCode, int pageNum) {
        if (list == null || list.isEmpty()) {
            Log.e("split_words", "list empty");
            return;
        }

        if (segmentID >= list.size()) {
            Log.e("split_words", "seg overflow segId" + segmentID + "  list.size " + list.size());
            segmentID = 0;
        }
        if (list.get(segmentID) == null) {
            Log.e("split_words", "seg overflow sentenceID" + segmentID + " is null");
            segmentID = -1;
        } else if (sentenceID >= list.get(segmentID).size()) {
            sentenceID = 0;
            Log.e("split_words", "seg overflow sentenceID" + segmentID + "  list.get(segmentID).size " + list.get(segmentID).size());
        }
        SplitedWordDialogFragment wordModelDialogFragment = new SplitedWordDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("segmentID", segmentID);
        bundle.putInt("sentenceID", sentenceID);
        bundle.putSerializable("splitedSentenceList", list);
        bundle.putString("bookCode", bookCode);
        bundle.putString("audioPath", audioPath);
        bundle.putString("missionCode", missionCode);
        bundle.putInt("pageNum", pageNum);
        wordModelDialogFragment.setArguments(bundle);
        wordModelDialogFragment.setStyle(R.style.full_notch_dialog, 0);
        wordModelDialogFragment.show(activity.getFragmentManager(), "SplitedWordDialogFragment");
    }

    protected void injectView(View view) {
        llRightDes = view.findViewById(R.id.llRightDes);
        rlWordLayout = view.findViewById(R.id.rlWordLayout);
        ivWordIcon = view.findViewById(R.id.ivWordIcon);
        tvWordTextTip = view.findViewById(R.id.tvWordTextTip);
        rlSentenceLayout = view.findViewById(R.id.rlSentenceLayout);

        ivSentenceIcon = view.findViewById(R.id.ivSentenceIcon);
        tvSentenceTextTip = view.findViewById(R.id.tvSentenceTextTip);
        rlEmptyLayout = view.findViewById(R.id.rlEmptyLayout);
        nsSentence = view.findViewById(R.id.nsSentence);
        tvSentenceContent = view.findViewById(R.id.tvSentenceContent);

        tvSentenceContentTranslate = view.findViewById(R.id.tvSentenceContentTranslate);
        nsWord = view.findViewById(R.id.nsWord);
        tvWord = view.findViewById(R.id.tvWord);
        tvAmericaAudio = view.findViewById(R.id.tvAmericaAudio);
        tvEnglandAudio = view.findViewById(R.id.tvEnglandAudio);

        vLoading = view.findViewById(R.id.vLoad);
        vLoadSentence = view.findViewById(R.id.vLoadSentence);
        vWordAudioLayout = view.findViewById(R.id.vWordAudioLayout);
        vWordAudioLayout.setVisibility(View.GONE);
        if (vLoading.getDrawable() instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable) vLoading.getDrawable();
            animationDrawable.start();
        }

        if (vLoadSentence.getDrawable() instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable) vLoadSentence.getDrawable();
            animationDrawable.start();
        }
        tvWordDes = view.findViewById(R.id.tvWordDes);
        tvAddWord = view.findViewById(R.id.tvAddWord);
        splitedSegmentsLayout = view.findViewById(R.id.splitedSegmentsLayout);
        maskView = view.findViewById(R.id.fl_content_split);
        rlReportErrorSentence = view.findViewById(R.id.rlReportErrorSentence);
        rlReportErrorWord = view.findViewById(R.id.rlReportErrorWord);
//        viewAnchor = view.findViewById(R.id.tvReportError);
        view.findViewById(R.id.ivBack).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackClick();
            }
        });
        view.findViewById(R.id.rlWordLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onWordSelectClick();
            }
        });
        view.findViewById(R.id.rlSentenceLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onSentenceSelectClick();
            }
        });
        view.findViewById(R.id.tvAddWord).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onAddWordClick();
            }
        });
        view.findViewById(R.id.tvAmericaAudio).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onAmericaAudioClick();
            }
        });
        view.findViewById(R.id.tvEnglandAudio).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onEnglandAudioClick();
            }
        });
        vWordAudioLayout.setListener(new AudioWordLayout.RecordListener() {
            @Override
            public void onRecordClick(boolean isRecording) {
                if (isRecording) {
                    stopRecord(true);
                } else {
                    startRecord();
                }
            }

            @Override
            public void onPlayClick() {
                playLastAudio();
            }
        });
        tvSentenceContent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!TextUtils.isEmpty(sentenceSpeech)) {
                    try {
                        MediaPlayerUtil.play(sentenceSpeech);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        rlReportErrorSentence.setOnClickListener(v -> getFeedbackList(rlReportErrorSentence, mCurrentSentence, mCurrentTranslate));
        rlReportErrorWord.setOnClickListener(v -> {
            if (TextUtils.isEmpty(word)) {
                ToastUtils.showToast(getString(R.string.split_fragment_click_left_words));
                return;
            }
            getFeedbackList(rlReportErrorWord, word, wordTranslate);

        });
        tvAddWord.setVisibility(ReaderModule.isAddWordEnable() ? View.VISIBLE : View.INVISIBLE);
    }

    @Override
    public void onResume() {
        super.onResume();
//        rlReportErrorSentence.setVisibility(Utils.isNetworkConnected(rlReportErrorSentence.getContext()) ? View.VISIBLE : View.INVISIBLE);
//        rlReportErrorWord.setVisibility(Utils.isNetworkConnected(rlReportErrorWord.getContext()) ? View.VISIBLE : View.INVISIBLE);
    }

    //获取 反馈 列表
    private void getFeedbackList(View popView, String word, String translateResult) {
        FeedbackRequestCache cache = FeedbackRequestCache.getInstance();
        List<FeedbackBean> list = cache.getReasonListCache(bookCode);
        if (list != null) {
            showFeedbackPopup(list, popView, word, translateResult);
        } else {
            BizReader.getInstance().getFeedBackList(RxLifecycle.bindUntilEvent(lifecycleSubject, FragmentEvent.PAUSE), new HttpServiceCallBack<List<FeedbackBean>>() {
                @Override
                public void onHttpServiceFinished(List<FeedbackBean> result) {
                    showFeedbackPopup(result, popView, word, translateResult);
                    cache.updateReasonList(bookCode, result);
                }

                @Override
                public void onHttpServiceError(int code, String msg) {
                    ToastUtils.showToast(msg);
                }
            });
        }
    }

    private void showFeedbackPopup(final List<FeedbackBean> list, View popView, String words, String translateResult) {
        FeedbackPopup popup = new FeedbackPopup();
        popup.setConfirmCallback(
                new Callback<Integer>() {
                    @Override
                    public void callback(Integer integer) {
                        int value = list.get(integer).value;
                        String content = list.get(integer).info;
                        BizReader.getInstance().commitFeedback(null, value, words,
                                translateResult, bookCode, String.valueOf(pageNum),
                                new HttpServiceCallBack<Object>() {
                                    @Override
                                    public void onHttpServiceFinished(Object result) {
                                        ToastUtils.showToast(R.string.feedback_commit_success);
                                    }

                                    @Override
                                    public void onHttpServiceError(int code, String msg) {
                                        ToastUtils.showToast(msg);
                                    }
                                });
                    }
                }
        );
        popup.show(popView.getContext(), popView, llRightDes, list, maskView);
    }

    @Override
    public void onPause() {
        super.onPause();
        stopRecord(false);
    }

    AudioRecorder audioRecorder;

    private void startRecord() {
        vWordAudioLayout.showRecordingUI();
        if (audioRecorder == null) {
            audioRecorder = new AudioRecorder(new AudioRecorder.OnAudioRecordListener() {
                @Override
                public void onNoVoice() {
                    ToastUtils.showToast("5秒内没有声音，自动关闭");
                    vWordAudioLayout.hideRecodingUI();
                }

                @Override
                public void onTimeCountDown(long startTime) {
                    vWordAudioLayout.setProgress(
                            (int) ((System.currentTimeMillis() - startTime) / 1000), 15);
                }

                @Override
                public void onRecorderOverFlow() {
                    uploadRecorderMP3();
                    ToastUtils.showToast("录音时间最长为15秒");
                    vWordAudioLayout.hideRecodingUI();
                }
            });
        }
        audioRecorder.startRecord(new File(mRecorderFilePath));
    }

    private void stopRecord(boolean upload) {
        vWordAudioLayout.hideRecodingUI();
        if (audioRecorder != null) {
            long time = audioRecorder.stopRecord();
            if (upload) {
                if (time > 0) {
                    uploadRecorderMP3();
                } else {
                    ToastUtils.showToast("跟读声音太小");
                }
            }
        }
    }

    private void playLastAudio() {

    }

    private void uploadRecorderMP3() {
        //disable btn
        EllaHttpService.getInstance(ApplicationHolder.getContext()).upLoadFile(
                null,
                mRecorderFilePath,
                new HttpServiceCallBack<String>() {
                    @Override
                    public void onHttpServiceFinished(String s) {

                    }

                    @Override
                    public void onHttpServiceError(int i, String s) {

                    }
                }
        );
    }

    @Override
    public void onStop() {
        super.onStop();
        if (vLoading != null && vLoading.getDrawable() instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable) vLoading.getDrawable();
            animationDrawable.stop();
        }
        if (vLoadSentence != null && vLoadSentence.getDrawable() instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable) vLoadSentence.getDrawable();
            animationDrawable.stop();
        }
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(STYLE_NORMAL, R.style.full_notch_dialog);
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        if (dialog.getWindow() != null && dialog.getWindow().getDecorView() != null) {
            dialog.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                    | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
        }
        return dialog;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_fragment_word_model, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mRecorderFilePath = ApplicationHolder.getContext().getExternalCacheDir().getAbsolutePath() + "/recorder_tmp.mp3";
        injectView(view);
        segmentID = getArguments().getInt("segmentID");
        sentenceID = getArguments().getInt("sentenceID");
        list = (ArrayList<ArrayList<SplitedSentence>>) getArguments().getSerializable("splitedSentenceList");
        audioPath = getArguments().getString("audioPath");
        bookCode = getArguments().getString("bookCode");
        missionCode = getArguments().getString("missionCode");
        pageNum = getArguments().getInt("pageNum");
        splitedSegmentsLayout.setOnWordSelectListener(this);
        splitedSegmentsLayout.setSplitedSentences(segmentID, sentenceID, list);
        onSentenceSelectClick();

        setSentence(splitedSegmentsLayout.getCurrentSplitedSentence().getSentence());
        getSentenceInfo(splitedSegmentsLayout.getCurrentSplitedSentence().getSentence());
    }

    private void setSentence(String sentence) {
        mCurrentSentence = sentence;
        sentence = sentence + "  ";//增加喇叭图片和句子的间隔
        String img = "img";
        SpannableString spannableString = new SpannableString(sentence + img);
        ImageSpan imageSpan = new ImageSpan(getActivity(), R.drawable.pass_course_icon_audio, ImageSpan.ALIGN_BASELINE);
        spannableString.setSpan(imageSpan, sentence.length(), sentence.length() + img.length(), Spannable.SPAN_INCLUSIVE_EXCLUSIVE);
        tvSentenceContent.setText(spannableString);
        tvSentenceContent.setMovementMethod(ClickableMovementMethod.getInstance());
    }

    @Override
    public void onSelect(int segmentID, int sentenceID, String word, SplitedSentence splitedSentence) {
        this.word = word;
        wordTranslate = "";
        getWordInfo(word);
        getSentenceInfo(splitedSentence.getSentence());
        onWordSelectClick();
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        try {

            getDialog().getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        } catch (Exception e) {

        }
        super.onActivityCreated(savedInstanceState);
        try {
            getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(0x00000000));
            getDialog().getWindow().setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.MATCH_PARENT);
            getDialog().getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        } catch (Exception e) {

        }
    }

    void onBackClick() {
        dismiss();
        EllaBookViewerHelper.resume();
    }

    void onWordSelectClick() {
        selectedWord(true);
        selectedSentence(false);
    }

    void onSentenceSelectClick() {
        selectedSentence(true);
        selectedWord(false);
    }

    void onAddWordClick() {
        if (word == null)
            return;

        BizReader.getInstance().addUserWord(RxLifecycle.bindUntilEvent(lifecycleSubject, FragmentEvent.PAUSE),
                bookCode, missionCode, pageNum, splitedSegmentsLayout.getCurrentSplitedSentence().getSentence(),
                word, audioPath,
                new HttpServiceCallBack<Object>() {
                    @Override
                    public void onHttpServiceFinished(Object result) {
                        ToastUtils.showToast("添加成功");
                    }

                    @Override
                    public void onHttpServiceError(int code, String msg) {
                        ToastUtils.showToast(msg);
                    }
                }
        );
    }

    void onAmericaAudioClick() {
        if (httpWordDetails == null)
            return;

        MediaPlayerUtil.play(httpWordDetails.usSpeech);
    }

    void onEnglandAudioClick() {
        if (httpWordDetails == null)
            return;

        MediaPlayerUtil.play(httpWordDetails.ukSpeech);
    }

    private void selectedWord(boolean isSelected) {
        ViewGroup.LayoutParams layoutParams = rlWordLayout.getLayoutParams();
        if (isSelected) {
            llRightDes.setBackgroundResource(R.drawable.pass_course_participles_word_selected);
            layoutParams.width = Converter.dip2px(getResources().getInteger(R.integer.split_word_selected));
            rlWordLayout.setLayoutParams(layoutParams);
            ivWordIcon.setVisibility(View.VISIBLE);
            tvWordTextTip.setTextColor(Color.parseColor("#7C70E6"));
            if (TextUtils.isEmpty(word)) {
                rlEmptyLayout.setVisibility(View.VISIBLE);
                nsWord.setVisibility(View.GONE);
            } else {
                rlEmptyLayout.setVisibility(View.GONE);
                nsWord.setVisibility(View.VISIBLE);
            }
        } else {
            llRightDes.setBackgroundResource(R.drawable.pass_course_participles_sentence_selected);
            layoutParams.width = Converter.dip2px(getResources().getInteger(R.integer.split_word_unselected));
            rlWordLayout.setLayoutParams(layoutParams);
            ivWordIcon.setVisibility(View.GONE);
            tvWordTextTip.setTextColor(Color.parseColor("#FFFFFF"));
            nsWord.setVisibility(View.GONE);
        }
    }

    private void selectedSentence(boolean isSelected) {
        ViewGroup.LayoutParams layoutParams = rlSentenceLayout.getLayoutParams();
        if (isSelected) {
            layoutParams.width = Converter.dip2px(getResources().getInteger(R.integer.split_word_selected));
            rlSentenceLayout.setLayoutParams(layoutParams);
            ivSentenceIcon.setVisibility(View.VISIBLE);
            tvSentenceTextTip.setTextColor(Color.parseColor("#7C70E6"));
            nsSentence.setVisibility(View.VISIBLE);
            rlEmptyLayout.setVisibility(View.GONE);
        } else {
            layoutParams.width = Converter.dip2px(getResources().getInteger(R.integer.split_word_unselected));
            rlSentenceLayout.setLayoutParams(layoutParams);
            ivSentenceIcon.setVisibility(View.GONE);
            tvSentenceTextTip.setTextColor(Color.parseColor("#FFFFFF"));
            nsSentence.setVisibility(View.GONE);
        }
    }

    /**
     * 首行缩进的SpannableString
     *
     * @param length      首行缩进宽度 dp
     * @param description 描述信息
     */
    private void setFirstLineSpace(TextView tv, float length, String description) {
        SpannableString spannableString = new SpannableString(description);
        int marginSpanSize = Converter.dip2px(length);
        LeadingMarginSpan leadingMarginSpan = new LeadingMarginSpan.Standard(marginSpanSize, 0);//仅首行缩进
        spannableString.setSpan(leadingMarginSpan, 0, description.length(), Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
        tv.setText(spannableString);
    }


    //获取句子的翻译
    private void getSentenceInfo(String sentence) {
        final CharSequence lastSentence = tvWord.getText();
        setSentence(sentence);
        vLoadSentence.setVisibility(View.VISIBLE);
        tvSentenceContentTranslate.setVisibility(View.GONE);
//        rlReportErrorSentence.setVisibility(View.GONE);
        BizReader.getInstance().getWordDetails(RxLifecycle.bindUntilEvent(lifecycleSubject, FragmentEvent.PAUSE),
                UserInfoProvider.getUserId(),
                sentence,
                bookCode,
                pageNum,
                new HttpServiceCallBack<HttpWordDetails>() {
                    @Override
                    public void onHttpServiceFinished(HttpWordDetails result) {

                        setSentence(result.word);
                        sentenceSpeech = result.usSpeech;
                        mCurrentTranslate = removeWrapper(result.wordDesc);
                        vLoadSentence.setVisibility(View.GONE);
                        tvSentenceContentTranslate.setVisibility(View.VISIBLE);
                        setFirstLineSpace(tvSentenceContentTranslate, 30, mCurrentTranslate);

//                        rlReportErrorSentence.setVisibility(View.VISIBLE);
                    }

                    @Override
                    public void onHttpServiceError(int code, String msg) {
                        tvSentenceContent.setText(lastSentence);
                        ToastUtils.showToast(msg);
                        vLoadSentence.setVisibility(View.GONE);
                        tvSentenceContentTranslate.setVisibility(View.VISIBLE);
                    }
                }
        );
    }

    private void getWordInfo(String word) {
        final String lastWords = tvWord.getText().toString();
        tvWord.setText(word);
        vLoading.setVisibility(View.VISIBLE);
        tvWordDes.setVisibility(View.GONE);
//        rlReportErrorWord.setVisibility(View.GONE);
        BizReader.getInstance().getWordDetails(RxLifecycle.bindUntilEvent(lifecycleSubject, FragmentEvent.PAUSE),
                UserInfoProvider.getUserId(),
                word,
                bookCode,
                pageNum,
                new HttpServiceCallBack<HttpWordDetails>() {
                    @Override
                    public void onHttpServiceFinished(HttpWordDetails result) {
                        httpWordDetails = result;
                        tvWord.setText(result.word);
                        wordTranslate = result.explains;
                        tvWordDes.setText(removeWrapper(result.explains));
                        vLoading.setVisibility(View.GONE);
                        tvWordDes.setVisibility(View.VISIBLE);
//                        rlReportErrorWord.setVisibility(View.VISIBLE);
                    }

                    @Override
                    public void onHttpServiceError(int code, String msg) {
                        ToastUtils.showToast(msg);
                        tvWord.setText(lastWords);
                        vLoading.setVisibility(View.GONE);
                        tvWordDes.setVisibility(View.VISIBLE);
                    }
                }
        );
    }


    /**
     * 去除[" "]
     *
     * @param s
     * @return
     */
    private String removeWrapper(String s) {
        if (TextUtils.isEmpty(s)) {
            return s;
        }
        return s.replace("[", "").replace("]", "").replace("\"", "").replace(",", "\n");
    }
}
