package com.ellabook.project.ellareader.ui.read;

import static android.view.KeyEvent.KEYCODE_BACK;
import static cn.ellabook.EllaBookViewer.PLAY_MODE_CLASS;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.storage.SPSaveManager;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.Converter;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.IReaderController;
import com.ellabook.project.ellareader.ListenableFrameAnimation;
import com.ellabook.project.ellareader.OnDebounceListener;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ReaderModule;
import com.ellabook.project.ellareader.TryReadController;
import com.ellabook.project.ellareader.bean.HttpWordDetails;
import com.ellabook.project.ellareader.bean.StoneNum;
import com.ellabook.project.ellareader.bean.StoneResult;
import com.ellabook.project.ellareader.biz.BizReader;
import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.utils.PermissionUtils;
import com.ellabook.project.ellareader.utils.SaasApp;
import com.google.gson.Gson;
import com.trello.rxlifecycle2.RxLifecycle;
import com.trello.rxlifecycle2.android.ActivityEvent;

import org.json.JSONObject;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.ellabook.BookViewerCallback;
import cn.ellabook.EllaBookViewer;
import cn.ellabook.EllaBookViewerHelper;
import cn.ellabook.ReaderActivity;
import cn.ellabook.ReaderAudioHelper;
import ellax.log.Logger;
import io.reactivex.subjects.BehaviorSubject;

/**
 Created by java on 2018/7/18.
 */
public class BookReaderActivity extends ReaderActivity {
    public static final String                         TAG              = "BookReaderActivity.TAG";
    private final       BehaviorSubject<ActivityEvent> lifecycleSubject = BehaviorSubject.create();

    public static final int                 REQUEST_COURSE_PASS_CODE = 1027;
    private             Map<String, String> wordsMap                 = new HashMap<>();
    private ImageView ivWartermark;

    @Override
    public void finish() {
        super.finish();
        Log.i(TAG, "finish");
    }

    private             int passNumber               = 0;
    public static final int RESULT_FINISH            = 1000;
    public static final int RESULT_GO_BACK_FIST_PAGE = 1001;

    private boolean reachedLastPage = false;
    private View    controlView;
    ImageView menu;
    View      left;
    View      right;
    View      vLogo;
    TextView  tvDiamond;
    ImageView ivDiamond;
    ImageView ivDiamondAnimation;
    View      vDiamond;
    Button    btnDebugLastPage;

    MenuFragment menuFragment;

    private boolean       isTryRead;
    private boolean       isFinished;
    private BookContainer bookContainer;
    private long          mapId;

    private SparseIntArray           stoneArray    = new SparseIntArray();
    private HashMap<String, Integer> localStoneMap = new HashMap<>();
    private Handler                  handler;

    //进入阅读器 到封底页 阅读获得的能量石头
    int               fetchedStoneNum        = 0;
    long              readStartTime          = 0;
    //进入阅读器 到推出阅读器
    ArrayList<String> mReadStartEnds         = new ArrayList<>();
    //进入阅读器 到封底页
    ArrayList<String> mReadLastPageStartEnds = new ArrayList<>();

    private boolean shouldTryPostCoursePassed = false;
    int maxPageNum      = 0;
    int maxPageTotalNum = 0;

    private Map<Integer, Boolean> isVoiceQuestionPage;
    private Dialog                goSettingDialog;
    private boolean               isRequestPermission;

    private static Set<PreferenceManager.OnActivityResultListener> onActivityResultListeners =
            new LinkedHashSet<>();

    public static void add(PreferenceManager.OnActivityResultListener listener) {
        onActivityResultListeners.add(listener);
    }

    public String getBookType() {
        try {
            if (bookContainer == null) {
                bookContainer = (BookContainer) getIntent().getSerializableExtra("bookContainer");
            }
            return bookContainer.getBookType();
        } catch (Exception e) {
            return null;
        }
    }

    protected void injectView() {
        menu = findViewById(R.id.ellaReadExit);
        left = findViewById(R.id.ellaReadLeft);
        right = findViewById(R.id.ellaReadRight);
        vLogo = findViewById(R.id.vLogo);
        tvDiamond = findViewById(R.id.tvDiamond);
        vDiamond = findViewById(R.id.vDiamondWrapper);
        ivDiamond = findViewById(R.id.ivDiamond);
        ivDiamondAnimation = findViewById(R.id.ivDiamondAnimation);
        vLogo.setVisibility(ReaderModule.showCopyRight() ? View.VISIBLE : View.GONE);

        btnDebugLastPage = findViewById(R.id.btnDebugLastPage);

        ivWartermark = findViewById(R.id.iv_watermark_english);
        ui4Watermark(true);
        findViewById(R.id.ellaReadLeft).setOnClickListener(new OnDebounceListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onLeftClick();
            }
        }));
        findViewById(R.id.ellaReadRight).setOnClickListener(new OnDebounceListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onRightClick(false);
            }
        }));
        findViewById(R.id.ellaReadExit).setOnClickListener(new OnDebounceListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onMenuClick();
            }
        }));
        findViewById(R.id.btnDebugLastPage).setOnClickListener(new OnDebounceListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                EllaBookViewer.setBookPlayMode(EllaBookViewer.PLAY_MODE_LEARN);
                onLastClick();
            }
        }));
        findViewById(R.id.vDiamondWrapper).setOnClickListener(new OnDebounceListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onDiamondTvClick();
            }
        }));
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        //设置异形屏(Android9.0以上)
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.P) {
            Window window = getWindow();
            WindowManager.LayoutParams attributes = window.getAttributes();
            attributes.layoutInDisplayCutoutMode =
                    WindowManager.LayoutParams.LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES;
            window.setAttributes(attributes);
        }

        super.onCreate(savedInstanceState);

        EllaBookViewer.initLib(this);
        EllaBookViewer.initJNI(this, getAssets());
        //必须加
        EllaBookViewer.setUserDataInfomation("");

        readStartTime = System.currentTimeMillis();
        injectView();
        bookContainer = (BookContainer) getIntent().getSerializableExtra("bookContainer");
        isTryRead = getIntent().getBooleanExtra("isTryRead", false);
        isFinished = getIntent().getBooleanExtra("isFinished", false);
        mapId = getIntent().getLongExtra("mapId", 0);
        passNumber = getIntent().getIntExtra("passNumber", 0);
        EllaBookViewer.setBookCode(bookContainer.getBookCode());
        if (BookContainer.BOOK_TYPE_COURSE.equals(bookContainer.getBookType())) {
            tvDiamond.setText("0/" + bookContainer.getDiamondNum());
            getStoneNums();
        } else {
            menu.setBackgroundResource(R.drawable.pass_en_book_btn_exit);
        }
        btnDebugLastPage.setVisibility(ReaderModule.isDebugable() ? View.VISIBLE : View.GONE);
        int volume = UserInfoProvider.getReaderVolume();
        if (volume < 0 || volume > 100) {
            volume = 100;
        }
        EllaBookViewer.setVolume(volume);
    }

    @Override
    protected void onStop() {
        super.onStop();
        stopMachineRead();
    }

    private void stopMachineRead() {
        MediaPlayerUtil.stop();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("fetchedStoneNum", fetchedStoneNum);
        outState.putBoolean("isFinished", isFinished);
        outState.putBoolean("isTryRead", isTryRead);
        outState.putBoolean("mAutoNext", mAutoNext);
        outState.putStringArrayList("mReadStartEnds", mReadStartEnds);
        outState.putStringArrayList("mReadLastPageStartEnds", mReadLastPageStartEnds);
        Log.i(TAG, "onSaveInstanceState ");
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        isFinished = savedInstanceState.getBoolean("isFinished", false);
        isTryRead = savedInstanceState.getBoolean("isTryRead", isTryRead);
        mAutoNext = savedInstanceState.getBoolean("mAutoNext", false);
        fetchedStoneNum = savedInstanceState.getInt("fetchedStoneNum", 0);
        mReadStartEnds = savedInstanceState.getStringArrayList("mReadStartEnds");
        mReadLastPageStartEnds = savedInstanceState.getStringArrayList("mReadLastPageStartEnds");
        Log.i(TAG, "onRestoreInstanceState ");
    }

    @Override
    protected View createReaderControlView() {
        this.controlView = View.inflate(this, R.layout.ellabook_read_controll, null);
        return controlView;
    }

    void onLeftClick() {
        if (mStopController) {
            return;
        }
        if (!EllaBookViewer.isMenuEnable()) {
            return;
        }

        if (getReaderControler().getCurrentPage() == 1) {
            return;
        }

        getReaderControler().pageUp();
    }


    private boolean mStopController = false;

    void onRightClick(boolean fromAuto) {
        if ((!fromAuto) && mStopController) {
            return;
        }
        if ((!fromAuto) && EllaBookViewer.getCurrentPage() >= 2 && (!EllaBookViewer.isLastPage()) &&
                BookContainer.BOOK_TYPE_COURSE.equals(bookContainer.getBookType())) {//课程设置模式
            if (EllaBookViewer.getBookPlayMode() == EllaBookViewer.PLAY_MODE_CLASS) {

                if (!isPagePassed(EllaBookViewer.getCurrentPage())) {
                    if (UserInfoProvider.isGuideAvailable("firstLearnToReadFinish_" + bookContainer.getBookCode(), true)) {
                        EllaBookViewerHelper.pause();
                        ToastUtils.showToast("本页全部提问还没结束，暂时不能翻页哦");
                        mStopController = true;
                        playGuideVoice(R.raw.learn_to_read_not_finished,
                                new AudioPlayer.OnAudioPlayDone() {
                                    @Override
                                    public void onAudioPlayDone() {
                                        mStopController = false;
                                        EllaBookViewerHelper.resume();
                                    }
                                });
                        return;
                    }
                }
            }
        }
        mAutoNext = false;
        controlView.removeCallbacks(mAutoClickRunnable);
        if (diamondAnimation != null && diamondAnimation.isRunning()) {
            diamondAnimation.stop();
            ivDiamondAnimation.setVisibility(View.GONE);
            ivDiamond.setVisibility(View.VISIBLE);
        }
        if (!EllaBookViewer.isMenuEnable()) {
            return;
        }

        if (isTryRead && getReaderControler().getCurrentPage() >= bookContainer.getTryReadPage()) {
            if (ReaderModule.getTryReadController() != null) {
                ReaderModule.getTryReadController().onTryReadDone(this, bookContainer,
                        new TryReadController.onDoneListener() {
                            @Override
                            public void onResult(boolean done) {
                                if (done) {
                                    isTryRead = false;
                                }
                            }
                        });
            } else {
                ToastUtils.showCenterToast("试读模式只能阅读前" + bookContainer.getTryReadPage() +
                        "页，请购买后继续阅读");
            }
            return;
        }

        if (EllaBookViewer.isLastPage()) {
            UserInfoProvider.setGuide("firstLearnToReadFinish_" + bookContainer.getBookCode(),
                    false);

            goNext();
            return;
        }
        getReaderControler().pageDown();
    }

    public void goNext() {
        //        ArrayList<String> passReadStartEnds = new ArrayList<>(mReadStartEnds);
        //        passReadStartEnds.add(String.valueOf(System.currentTimeMillis()));
        //        Log.i(TAG, " go pass " + passReadStartEnds);
        if (BookContainer.BOOK_TYPE_COURSE.equals(bookContainer.getBookType())) {
            updateReadRecordForMission();
        }
        ArrayList<String> toEndPassReadStartEnds = new ArrayList<>(mReadLastPageStartEnds);
        toEndPassReadStartEnds.add(String.valueOf(System.currentTimeMillis()));
        Log.i(TAG, " go pass " + toEndPassReadStartEnds);
        ReaderModule.getReaderController().onBookReadPassed(
                bookContainer.getPicBookCode(),
                bookContainer.getBookType(),
                bookContainer.getId(),
                mapId,
                bookContainer.getBookCover(),
                (HashMap) EllaBookViewer.getQuestionQuantity(),
                BookReaderActivity.this,
                REQUEST_COURSE_PASS_CODE,
                toEndPassReadStartEnds,
                fetchedStoneNum,
                new IReaderController.AnalysisFinishCallback() {
                    @Override
                    public void isAnalysisFinish(boolean isFinish) {
                        if (isFinish) {
                            //标记已经读过了
                            isFinished = true;
                        }
                    }
                }
        );
        fetchedStoneNum = 0;
        mReadLastPageStartEnds.clear();
    }

    public BookContainer getBookContainer() {
        return bookContainer;
    }

    void onMenuClick() {

        if (mStopController) {
            return;
        }
        if (BookContainer.BOOK_TYPE_BOOK.equals(bookContainer.getBookType())) {
            Logger.record("en_read_exit");
            getReaderControler().endBookViewer();
        } else {
            Logger.record("en_read_buttons");
            if (menuFragment == null) {
                menuFragment = MenuFragment.get(bookContainer.getId(),
                        () -> getScoreTotalDiamond() >= passNumber);
            }
            menuFragment.show(getFragmentManager(), R.id.llBookViewControll, "menu",
                    getScoreTotalDiamond() >= passNumber,
                    BookContainer.BOOK_TYPE_COURSE.equals(bookContainer.getBookType()));
            EllaBookViewerHelper.pause();
            stopMachineRead();
        }
    }

    void onLastClick() {
        getReaderControler().gotoPage(getReaderControler().getBookPages());
    }

    void onDiamondTvClick() {
        if (mStopController) {
            return;
        }
        Logger.record("en_class_stone");
        EllaBookViewerHelper.pause();
        BookReader.showPowerStone(getFragmentManager(),
                bookContainer.getPassNum(),
                getAllCanScore(),
                bookContainer.getId(),
                mapId,
                bookContainer.getBookCover(),
                (HashMap<Integer, Integer>) EllaBookViewer.getQuestionQuantity(),
                !isFinished,
                false);
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (reachedLastPage) {
            Logger.record("en_read_complete");
        }
        //        EventBus.getDefault().unregister(this);
    }

    @Override
    public void onViewerNotice2(final int type) {
        switch (type) {
            case BookViewerCallback.NOTICE_PAUSE:
                ReaderAudioHelper.getInstance().releaseAudio();
                break;
            case BookViewerCallback.NOTICE_RESUME:
                ReaderAudioHelper.getInstance().requestAudio(this);
                break;
            case BookViewerCallback.NOTICE_START_SUCCESS:
                /**
                 * 绘本一进来就是自学模式
                 * 闯关一进来就是闯关模式
                 */
                if (BookContainer.BOOK_TYPE_COURSE.equals(bookContainer.getBookType())) {//课程设置模式
                    if (EllaBookViewer.getBookPlayMode() != EllaBookViewer.PLAY_MODE_CLASS) {
                        EllaBookViewer.setBookPlayMode(EllaBookViewer.PLAY_MODE_CLASS);
                    }
                    EllaBookViewer.setEvaluatingType(1);//设置语音测评模式，1表示离线模式，2表示在线模式，3表示混合模式，4表示自动模式

                    int questionNum = 0;
                    Map<Integer, Integer> map = EllaBookViewer.getQuestionQuantity();
                    if (map != null && map.size() > 0) {
                        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                            if (entry != null && entry.getValue() != null) {
                                questionNum += entry.getValue();
                            }
                        }

                    }
                    if (questionNum > 0) {
                        BizReader.getInstance().uploadCourseStoneNum(null,
                                bookContainer.getBookCode(),
                                questionNum * 3,
                                null
                        );
                    }
                } else {
                    if (EllaBookViewer.getBookPlayMode() != EllaBookViewer.PLAY_MODE_LEARN) {
                        EllaBookViewer.setBookPlayMode(EllaBookViewer.PLAY_MODE_LEARN);
                    }

                    EllaBookViewer.setEvaluatingType(1);//设置语音测评模式，1表示离线模式，2表示在线模式，3表示混合模式，4表示自动模式
                }
                break;
            case BookViewerCallback.NOTICE_END_SUCCESS:
                break;
            case BookViewerCallback.NOTICE_SAVE_INSTANCE:
                break;
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            // TODO:bqf 2019-08-09 为了修复 2.9.1.0.10 readCore的npe
            super.onActivityResult(requestCode, resultCode, data);
        } catch (Exception e) {

        }
        if (requestCode == REQUEST_COURSE_PASS_CODE && resultCode == RESULT_OK) {

            getReaderControler().gotoPage(1);
            Map<Integer, Boolean> map = EllaBookViewer.getExercisePages();

            if (map != null) {
                Log.v("reader_exercisePage", map.toString());
            }

            int currentPage = 1;
            if (map.containsKey(currentPage) && map.get(currentPage) != null && !(Boolean) map.get(currentPage)) {
                if (EllaBookViewer.getCurrentPage() < 2 || !SelfStudyGuideFragment.checkShowGuide(this)) {
                    ToastUtils.showCenterToast("已进入Read to learn模式，点击文本内容可查看翻译");
                    EllaBookViewer.setBookPlayMode(EllaBookViewer.PLAY_MODE_LEARN);
                    EllaBookViewerHelper.resume();
                }
            } else {
                ToastUtils.showCenterToast("当前页面暂时不支持自学模式，请选择其他页面进入自学模式");
            }
        } else if (requestCode == REQUEST_COURSE_PASS_CODE && resultCode == RESULT_GO_BACK_FIST_PAGE) {
            getReaderControler().gotoPage(1);
        } else if (requestCode == REQUEST_COURSE_PASS_CODE && resultCode == RESULT_FINISH) {
            EllaBookViewer.endBookViewer();
        }

        try {
            Iterator<PreferenceManager.OnActivityResultListener> listenerIterator =
                    onActivityResultListeners.iterator();
            while (listenerIterator.hasNext()) {
                boolean result = listenerIterator.next().onActivityResult(requestCode, resultCode
                        , data);
                if (result) {
                    listenerIterator.remove();
                }
            }

        } catch (Exception e) {

        }
    }

    //一次进入只显示一个guide
    public boolean guided = false;

    @Override
    public void isViewerReady2(boolean var1) {
        super.isViewerReady2(var1);

        maxPageNum = Math.max(maxPageNum, EllaBookViewer.getCurrentPage());
        maxPageTotalNum = Math.max(maxPageTotalNum, EllaBookViewer.getBookPages());
        left.setVisibility(var1 && getReaderControler().getCurrentPage() != 1
                ? View.VISIBLE
                : View.GONE);
        controlView.setVisibility(var1 ? View.VISIBLE : View.GONE);
        if (var1) {
            if (ReaderModule.showCopyRight() && getReaderControler().getCurrentPage() == 1) {
                vLogo.setVisibility(View.VISIBLE);
                ui4Watermark(false);
                vDiamond.setVisibility(View.INVISIBLE);
            } else {
                vLogo.setVisibility(View.GONE);
                if (!BookContainer.BOOK_TYPE_COURSE.equals(bookContainer.getBookType())) {
                    ui4Watermark(false);
                    vDiamond.setVisibility(View.INVISIBLE);
                } else {
                    ui4Watermark(true);
                    vDiamond.setVisibility(View.VISIBLE);
                }
            }

            if (BookContainer.BOOK_TYPE_COURSE.equals(bookContainer.getBookType())) {
                if (EllaBookViewer.getBookPlayMode() == EllaBookViewer.PLAY_MODE_LEARN &&
                        getReaderControler().getCurrentPage() >= 2) {
                    SelfStudyGuideFragment.checkShowGuide(this);
                } else if (!guided && getReaderControler().getCurrentPage() == 2) {
                    if (!CourseGuideFragment.checkShowGuide(BookReaderActivity.this,
                            vDiamond.getWidth())) {
                        if (isFinished && EllaBookViewer.getBookPlayMode() == EllaBookViewer.PLAY_MODE_CLASS) {
                            CourseSecondGuideFragment.checkShowGuide(BookReaderActivity.this,
                                    vDiamond.getWidth());
                        }
                    }
                    guided = true;
                }


            }
            saveReadRecord();

            if (EllaBookViewer.getBookPlayMode() == PLAY_MODE_CLASS && !PermissionUtils.isGranted(android.Manifest.permission.RECORD_AUDIO) && !isRequestPermission) {
                if (isVoiceQuestionPage == null) {
                    isVoiceQuestionPage = EllaBookViewer.getVoiceQuestionPage();
                    if (isVoiceQuestionPage == null) {
                        isVoiceQuestionPage = new HashMap<>();
                    }
                }
                Boolean isPage = isVoiceQuestionPage.get(EllaBookViewer.getCurrentPage());
                if (isPage != null && isPage) {
                    EllaBookViewerHelper.pause();
                    isRequestPermission = true;
                    //闯关模式需要录音权限(有语音题)
                    PermissionUtils.permission(android.Manifest.permission.RECORD_AUDIO).callback(new PermissionUtils.FullCallback() {
                        @Override
                        public void onGranted(@NonNull List<String> granted) {
                            isRequestPermission = false;
                            EllaBookViewerHelper.resume();
                        }

                        @Override
                        public void onDenied(@NonNull List<String> deniedForever,
                                             @NonNull List<String> denied) {
                            EllaBookViewerHelper.pause();
                            if (goSettingDialog == null) {
                                goSettingDialog =
                                        new AlertDialog.Builder(BookReaderActivity.this).setTitle("检测到您的麦克风权限已关闭,请在手机设置中开启")
                                                .setPositiveButton("去开启", (dialog, which) -> {
                                                    PermissionUtils.launchAppDetailsSettings();
                                                    isRequestPermission = false;
                                                    dialog.cancel();
                                                })
                                                .setNegativeButton("取消", (dialog, which) -> {
                                                    EllaBookViewerHelper.resume();
                                                    isRequestPermission = false;
                                                    dialog.cancel();
                                                })
                                                .create();

                                goSettingDialog.setCanceledOnTouchOutside(false);
                            }

                            goSettingDialog.show();
                        }
                    }).request();

                }
            }
        }
        if (var1 && EllaBookViewer.isLastPage()) {
            //到达了最后一页
            reachedLastPage = true;
        }
        if (var1 && EllaBookViewer.isLastPage() &&
                !ReaderModule.getReaderController().canDoneWith(
                        bookContainer.getPicBookCode(),
                        bookContainer.getBookType(),
                        EllaBookViewer.getBookPlayMode())
        ) {
            right.setVisibility(View.INVISIBLE);
            if (BookContainer.BOOK_TYPE_COURSE.equals(bookContainer.getBookType()) && EllaBookViewer.getBookPlayMode() == EllaBookViewer.PLAY_MODE_LEARN) {
                showSelfStudyDone();
            }
        } else if (right.getVisibility() != View.VISIBLE) {
            right.setVisibility(View.VISIBLE);
        }
    }


    private void showSelfStudyDone() {

        ArrayList<String> toEndPassReadStartEnds = new ArrayList<>(mReadLastPageStartEnds);
        toEndPassReadStartEnds.add(String.valueOf(System.currentTimeMillis()));
        Log.i(TAG, " go pass " + toEndPassReadStartEnds);
        BookReader.onSelfStudyDone(getFragmentManager(), R.id.llBookViewControll, "selfStudy",
                bookContainer.getPassNum() <= getScoreTotalDiamond(),
                mapId,
                bookContainer.getId(),
                toEndPassReadStartEnds);
        mReadLastPageStartEnds.clear();

    }

    private void saveReadRecord() {
        if (handler == null) {
            handler = new Handler();
        }

        //这里延迟一点，否则获取当前页数不准确
        handler.postDelayed(() -> {
            if (getReaderControler().getCurrentPage() >= getReaderControler().getBookPages()) {
                UserInfoProvider.putUserReadPage(bookContainer.getBookCode(), -1);
            } else {
                UserInfoProvider.putUserReadPage(bookContainer.getBookCode(),
                        getReaderControler().getCurrentPage());
            }
        }, 500);
    }

    @Override
    public void onClassModeResult2(String s) {
        uploadClassResult(s);


    }

    /**
     课堂模式结果回调函数，正常答题时数组只有一个结果，未答题翻页或者答题过程中
     翻页会存在多个结果,本地cache下记录
     */

    public static final String   GROUPID        = "groupid";
    public static final String   PAGEID         = "pageid";
    public static final String   QUESTIONID     = "questionid";
    public static final String   RESULT         = "result";
    public static final String   RESULT_PERFECT = "perfect";
    public static final String   RESULT_GREAT   = "great";
    public static final String   RESULT_GOOD    = "good";
    public static final String[] RESULT_VALUES  = {RESULT_GOOD, RESULT_GREAT, RESULT_PERFECT};

    public boolean isCurrentQuestionRight(String s) {
        if (!TextUtils.isEmpty(s)) {
            try {
                JSONObject jsonObject = new JSONObject(s);
                String groupId = getJsonString(jsonObject, GROUPID);
                String pageid = getJsonString(jsonObject, PAGEID);
                String questionid = getJsonString(jsonObject, QUESTIONID);
                String result = getJsonString(jsonObject, RESULT);
                String key = new StringBuilder()
                        .append("user_").append(UserInfoProvider.getUserId())
                        .append("book_").append(bookContainer.getBookCode())
                        .append(groupId).append("_")
                        .append(pageid).append("_")
                        .append(questionid).toString();
                String lastValue = SPSaveManager.getInstance().getInfo(key);
                if (findValueIndex(result, RESULT_VALUES) > findValueIndex(lastValue,
                        RESULT_VALUES)) {
                    SPSaveManager.getInstance().saveInfo(key, result);
                    return true;
                }
            } catch (Exception e) {
                return false;
            }


        }
        return false;
    }

    public int findValueIndex(String temp, String[] values) {
        if (temp == null || values == null || values.length == 0) {
            return -1;
        }
        for (int i = 0; i < values.length; i++) {
            if (TextUtils.equals(temp, values[i])) {
                return i;
            }
        }
        return -1;
    }

    public String getJsonString(JSONObject jsonObject, String key) {
        try {
            if (jsonObject.has(key)) {
                return jsonObject.opt(key).toString();
            }
        } catch (Exception e) {

        }
        return "";
    }

    @Override
    public void onViewerReadPermissionNotice(int i, String s) {

    }

    @Override
    public void onStateCodeNotice(int i) {

    }

    @Override
    public void bookPageButtonVisible(boolean b) {

    }

    @Override
    public void onClassModeResult(String[] results) {
        super.onClassModeResult(results);
        boolean shouldShowPowerAnimation = false;
        if (results != null) {
            for (String s : results) {
                uploadClassResult(s);
                shouldShowPowerAnimation = shouldShowPowerAnimation || isCurrentQuestionRight(s);
            }
        }

        if (shouldShowPowerAnimation) {
            tvDiamond.post(this::showAnimationAndSound);
        }
    }

    ListenableFrameAnimation diamondAnimation;


    private void showAnimationAndSound() {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play(Uri.parse("android.resource://" + getPackageName() + "/" + R.raw.animation_voice));
        }
        if (diamondAnimation == null) {

            int[] reses = new int[]{
                    R.drawable.light_00000,
                    R.drawable.light_00001,
                    R.drawable.light_00002,
                    R.drawable.light_00003,
                    R.drawable.light_00004,
                    R.drawable.light_00005,
                    R.drawable.light_00006,
                    R.drawable.light_00007,
                    R.drawable.light_00008,
                    R.drawable.light_00009,
                    R.drawable.light_00010,
                    R.drawable.light_00011
            };

            diamondAnimation = new ListenableFrameAnimation();
            diamondAnimation.setOnFrameAnimationListener(new ListenableFrameAnimation.OnFrameAnimationListener() {

                @Override
                public void onStart() {
                    ivDiamond.setVisibility(View.INVISIBLE);
                    ivDiamondAnimation.setVisibility(View.VISIBLE);
                }

                @Override
                public void onEnd() {
                    ivDiamondAnimation.setVisibility(View.GONE);
                    ivDiamond.setVisibility(View.VISIBLE);
                }
            });
            for (int res : reses) {
                diamondAnimation.addFrame(getResources().getDrawable(res), 1500 / reses.length);
            }
            ivDiamondAnimation.setImageDrawable(diamondAnimation);
        }
        int animationSize = 360;
        int pngSize = 76;
        int pngImageSize = ivDiamond.getWidth();
        int pngImageCenterX = (int) (vDiamond.getX() + ivDiamond.getX() + ivDiamond.getWidth() / 2);
        int pngImageCenterY =
                (int) (vDiamond.getY() + ivDiamond.getY() + ivDiamond.getHeight() / 2);
        int animationImageSize = pngImageSize * animationSize / pngSize;

        int animationImageX = pngImageCenterX - animationImageSize / 2;
        int animationImageY = pngImageCenterY - animationImageSize / 2;
        RelativeLayout.LayoutParams relativeLayout =
                new RelativeLayout.LayoutParams(animationImageSize, animationImageSize);
        ivDiamondAnimation.setLayoutParams(relativeLayout);
        ivDiamondAnimation.setX(animationImageX);
        ivDiamondAnimation.setY(animationImageY);

        diamondAnimation.start();
    }

    private void uploadClassResult(String s) {
        if (TextUtils.isEmpty(s)) {
            return;
        }
        ResultBean resultBean = new Gson().fromJson(s, ResultBean.class);
        if (localStoneMap.containsKey(resultBean.getIdKey())) {
            int counts = localStoneMap.get(resultBean.getIdKey());
            if (counts < resultBean.getScoreDiamond()) {
                localStoneMap.put(resultBean.getIdKey(), resultBean.getScoreDiamond());
            }
        } else {
            localStoneMap.put(resultBean.getIdKey(), resultBean.getScoreDiamond());
        }

        int currentPage = getReaderControler().getCurrentPage();
        //上报答题数据
        BizReader.getInstance().uploadAnswerRecord(RxLifecycle.bindUntilEvent(lifecycleSubject,
                ActivityEvent.PAUSE),
                bookContainer.getId(), getPageQuestionCounts(), s,
                new HttpServiceCallBack<StoneResult>() {
                    @Override
                    public void onHttpServiceFinished(StoneResult result) {

                        stoneArray.put(currentPage, result.stoneNum + stoneArray.get(currentPage));
                        fetchedStoneNum += result.stoneNum;
                        showStoneNum();
                        tvDiamond.post(new Runnable() {
                            @Override
                            public void run() {
                                if (result.stoneNum > 0) {
                                    int animationSize = 360;
                                    int pngSize = 76;
                                    int pngImageSize = ivDiamond.getWidth();
                                    int pngImageCenterX =
                                            (int) (vDiamond.getX() + ivDiamond.getX() + ivDiamond.getWidth() / 2);
                                    int pngImageCenterY =
                                            (int) (vDiamond.getY() + ivDiamond.getY() + ivDiamond.getHeight() / 2);
                                    int animationImageSize = pngImageSize * animationSize / pngSize;

                                    int animationImageX = pngImageCenterX - animationImageSize / 2;
                                    int animationImageY = pngImageCenterY - animationImageSize / 2;
                                    RelativeLayout.LayoutParams relativeLayout =
                                            new RelativeLayout.LayoutParams(animationImageSize,
                                                    animationImageSize);
                                    ivDiamondAnimation.setLayoutParams(relativeLayout);
                                    ivDiamondAnimation.setX(animationImageX);
                                    ivDiamondAnimation.setY(animationImageY);
                                }
                            }
                        });

                        if (shouldTryPostCoursePassed) {
                            if (getScoreTotalDiamond() >= passNumber) {
                                ReaderModule.getReaderController().postBookPassed(bookContainer.getBookCode(), bookContainer.getBookType(), bookContainer.getId());
                                shouldTryPostCoursePassed = false;
                            }
                        }
                    }

                    @Override
                    public void onHttpServiceError(int code, String msg) {
                        ToastUtils.showToast(msg);
                    }
                });
    }

    //获取一共得了多少个钻石
    private int getScoreTotalDiamond() {
        int total = 0;
        for (int i = 0; i < stoneArray.size(); i++) {
            total += stoneArray.valueAt(i);
        }

        return total;
    }


    private int     autoClickPage = 0;
    private boolean mAutoNext     = false;

    @Override
    public void onClassModeEnd2() {
        autoClickPage = EllaBookViewer.getCurrentPage();
        mAutoNext = true;
        tryMarkPagePassed(autoClickPage);
        controlView.postDelayed(mAutoClickRunnable, 1000 * 2);
    }

    public void cleanRunnable() {
        if (controlView != null) {
            controlView.removeCallbacks(mAutoClickRunnable);
        }
    }

    private Runnable mAutoClickRunnable = new AutoClickRunnable();

    private class AutoClickRunnable implements Runnable {
        @Override
        public void run() {
            if (isResumed) {
                if (!isAnyFragmentCovered()) {
                    if (autoClickPage == EllaBookViewer.getCurrentPage()) {
                        onRightClick(true);
                    }
                    mAutoNext = false;

                } else {
                    controlView.postDelayed(mAutoClickRunnable, 1000 * 2);
                }
            }
        }
    }

    ;
    List<SoftReference<Fragment>> softReferenceList = new ArrayList<>();

    @Override
    public void onAttachFragment(Fragment fragment) {
        super.onAttachFragment(fragment);
        softReferenceList.add(new SoftReference<>(fragment));
    }


    private boolean isAnyFragmentCovered() {
        for (SoftReference<Fragment> sf : softReferenceList) {
            if (sf != null) {
                Fragment fragment = sf.get();
                if (fragment != null) {
                    if (fragment.isVisible()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private Set<Integer> readedPages = new HashSet<>();

    /**
     如果无网，本地标记改页已经阅读过

     @return
     */
    private void tryMarkPagePassed(int page) {
        readedPages.add(page);
    }

    private boolean isPagePassed(int page) {
        return isFinished || readedPages.contains(page) || stoneArray.get(page) != 0;
    }

    private int getPageScoreDiamond() {
        int total = 0;
        for (String key : localStoneMap.keySet()) {
            if (key.startsWith(getReaderControler().getCurrentPage() + "_")) {
                total += localStoneMap.get(key);
            }
        }
        return total;
    }

    //一页最高可得
    private int getPageCanScoreDiamond() {
        return getPageQuestionCounts() * 3;
    }

    private int getPageQuestionCounts() {
        Map<Integer, Integer> map = EllaBookViewer.getQuestionQuantity();
        if (map != null && map.containsKey(getReaderControler().getCurrentPage())) {
            return map.get(getReaderControler().getCurrentPage());
        }
        return 0;
    }

    private int getAllCanScore() {
        int total = 0;
        Map<Integer, Integer> map = EllaBookViewer.getQuestionQuantity();
        for (int value : map.values()) {
            total = total + value * 3;
        }
        return total;
    }

    public void onSubtitleSelect(Object[] vSubtitleSplitData) {
        //        if (!Arrays.asList(EllaBookViewer.PLAY_MODE_CLASS, EllaBookViewer
        //        .PLAY_MODE_READ, EllaBookViewer.PLAY_MODE_LEARN).contains(EllaBookViewer
        //        .getBookPlayMode())) {
        EllaBookViewerHelper.pause();
        SplitedWordDialogFragment.show(this,
                SplitedSentence.toLocalListSentence(vSubtitleSplitData), 0, 0, "",
                bookContainer.getBookCode(),
                bookContainer.getMissionCode(), getReaderControler().getCurrentPage());
        //        }
    }

    @Override
    public void onSubtitleDeacon(String s) {
        //朗读
        if (wordsMap.containsKey(s)) {
            MediaPlayerUtil.play(wordsMap.get(s));
        } else {
            getWordInfo(s);
        }
    }

    @Override
    public void onControllDeaconPlay() {
        //停止朗读
        stopMachineRead();
    }

    @Override
    public void onBookDownloadProgress(float v) {

    }

    @Override
    public void onBookDownloadFinish() {

    }

    private void getWordInfo(String word) {
        /*if (TextUtils.isEmpty(word) || !Pattern.matches(".*[A-Za-z]+.*", word)) {
            ToastUtils.showToast(R.string.select_word_error);
            return;
        }*/
        if (TextUtils.isEmpty(word)) {
            ToastUtils.showToast(R.string.select_word_error);
            return;
        }
        BizReader.getInstance().getWordDetails(RxLifecycle.bindUntilEvent(lifecycleSubject,
                ActivityEvent.PAUSE),
                UserInfoProvider.getUserId(),
                word,
                bookContainer.getBookCode(),
                getReaderControler().getCurrentPage(),
                new HttpServiceCallBack<HttpWordDetails>() {
                    @Override
                    public void onHttpServiceFinished(HttpWordDetails result) {
                        if (!TextUtils.isEmpty(result.usSpeech)) {
                            wordsMap.put(word, result.usSpeech);
                            MediaPlayerUtil.play(result.usSpeech);
                        }
                    }

                    @Override
                    public void onHttpServiceError(int code, String msg) {
                        ToastUtils.showToast(msg);
                    }
                }
        );

    }

    @Override
    public void onSubtitleSplit2(int segmentID,
                                 int sentenceID,
                                 Object[] vSubtitleSplitData,
                                 String soundFile) {
        if (!isVoiced("welcome_split_words")) {
            playGuideVoice(R.raw.welcome_split_words, null);
        }
        EllaBookViewerHelper.pause();
        SplitedWordDialogFragment.show(this, SplitedSentence.toLocalList(vSubtitleSplitData),
                segmentID, sentenceID, soundFile, bookContainer.getBookCode(),
                bookContainer.getMissionCode(), getReaderControler().getCurrentPage());
    }

    @Override
    public void onBookEnd2() {
        super.onBookEnd2();
    }

    @Override
    public void onMemoryOverflow2() {
        super.onMemoryOverflow2();
    }

    private void getStoneNums() {
        BizReader.getInstance().getStoneNums(RxLifecycle.bindUntilEvent(lifecycleSubject,
                ActivityEvent.PAUSE),
                bookContainer.getId(), new HttpServiceCallBack<List<StoneNum>>() {
                    @Override
                    public void onHttpServiceFinished(List<StoneNum> result) {
                        if (result != null) {
                            for (StoneNum stoneNum : result) {
                                stoneArray.put(stoneNum.pageNumber, stoneNum.stoneNum);
                            }
                            showStoneNum();
                            if (getScoreTotalDiamond() >= passNumber) {
                                shouldTryPostCoursePassed = false;
                            } else {
                                shouldTryPostCoursePassed = true;
                            }
                        }
                    }

                    @Override
                    public void onHttpServiceError(int code, String msg) {
                        ToastUtils.showToast(msg);
                        shouldTryPostCoursePassed = false;
                    }
                });
    }

    private void showStoneNum() {
        int getted = getScoreTotalDiamond();
        int bookTotal = bookContainer.getDiamondNum();
        tvDiamond.setText(getted + "/" + Math.max(getted, bookTotal));
    }

    boolean isResumed = false;

    @Override
    protected void onResume() {
        super.onResume();
        readStartTime = System.currentTimeMillis();
        mReadStartEnds.add(String.valueOf(readStartTime));
        if (mReadLastPageStartEnds.size() == 1) {
            mReadLastPageStartEnds.clear();
        }
        mReadLastPageStartEnds.add(String.valueOf(readStartTime));
        Log.i(TAG, "onResume " + mReadStartEnds);
        isResumed = true;
        if (mAutoNext) {
            controlView.removeCallbacks(mAutoClickRunnable);
            controlView.postDelayed(mAutoClickRunnable, 2 * 1000);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        EllaBookViewerHelper.resume();
    }

    @Override
    protected void onPause() {
        if (BookContainer.BOOK_TYPE_BOOK.equals(bookContainer.getBookType())) {
            updateReadRecordForEnBook();
        }
        if (!isFinishing()) {
            if (mReadStartEnds.size() % 2 == 1) {
                mReadStartEnds.add(String.valueOf(System.currentTimeMillis()));
            }
            if (mReadLastPageStartEnds.size() % 2 == 1) {
                mReadLastPageStartEnds.add(String.valueOf(System.currentTimeMillis()));
            }
        } else {
            if (BookContainer.BOOK_TYPE_COURSE.equals(bookContainer.getBookType())) {
                updateReadRecordForMission();
            }
        }
        Log.i(TAG, "onPause " + isFinishing() + "  " + mReadStartEnds);
        super.onPause();
        isResumed = false;

    }

    private void updateReadRecordForMission() {
        if (isResumed) {
            mReadStartEnds.add(String.valueOf(System.currentTimeMillis()));
            Log.i(TAG, "upload record on resume " + mReadStartEnds.toString());
        } else {
            Log.i(TAG, "upload record  " + mReadStartEnds.toString());

        }
        BizReader.getInstance().uploadReadInfoMission(null, bookContainer.getId(),
                bookContainer.getPicBookCode(),
                maxPageNum,
                maxPageTotalNum,
                new ArrayList<>(mReadStartEnds),
                null);
        mReadStartEnds.clear();
    }

    private void updateReadRecordForEnBook() {
        BizReader.getInstance().uploadReadInfoEnBook(null, bookContainer.getPicBookCode(),
                maxPageNum,
                maxPageTotalNum,
                readStartTime,
                System.currentTimeMillis(),
                null);
        readStartTime = System.currentTimeMillis();
    }


    public boolean isVoiced(String voiceName) {
        if (UserInfoProvider.isGuideAvailable(voiceName, false)) {
            return true;
        } else {
            UserInfoProvider.setGuide(voiceName, true);
            return false;
        }
    }

    public void playGuideVoice(int voiceId, AudioPlayer.OnAudioPlayDone onAudioPlayDone) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play(
                    AudioPlayer.DEFAULT_CHANNEL,
                    Uri.parse("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId),
                    AudioPlayer.DEFAULT_BREAK_BACKGROUND,
                    AudioPlayer.DEFAULT_VOLUMN,
                    onAudioPlayDone
            );
        } else if (onAudioPlayDone != null) {
            onAudioPlayDone.onAudioPlayDone();
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == KEYCODE_BACK) {
            if (getReaderControler() != null) {
                getReaderControler().endBookViewer();
            }
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private void ui4Watermark(boolean isDiamondShow){
        ViewGroup.LayoutParams lp = ivWartermark.getLayoutParams();
        if (lp == null){
            return;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) lp;
        if (isDiamondShow){
            layoutParams.addRule(RelativeLayout.ALIGN_RIGHT,R.id.vDiamondWrapper);
        }else {
            layoutParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        }
        layoutParams.rightMargin = Converter.dip2px(12);
        ivWartermark.setLayoutParams(layoutParams);
        ivWartermark.setVisibility(View.VISIBLE);
    }
}
