package com.ellabook.project.ellareader.book.download;

import androidx.fragment.app.FragmentActivity;

import com.ellabook.project.base.tool.Callback;
import com.ellabook.project.ellareader.book.bean.BookContainer;

import java.util.ArrayList;
import java.util.List;

import ellax.bookmanager.BookManager;

/**
 * created by dongdaqing 2018-08-03 13:50
 */
@Deprecated
public class BookListDownloadHelper implements Callback<Boolean> {
    private List<BookContainer> mList;
    private Callback<Integer> mCallback;

    public BookListDownloadHelper(List<BookContainer> list) {
        mList = list;
    }

    public BookListDownloadHelper(BookContainer book) {
        mList = new ArrayList<>();
        mList.add(book);
    }

    public void start(FragmentActivity activity, Callback<Integer> callback, boolean isNeedCheckOnlyWifi) {
        mCallback = callback;

        if (isNeedCheckOnlyWifi) {
            new DownloadHelper(activity, this).start();
        } else {
            new DownloadHelper(activity, this).startByNoCheck();
        }
    }

    public void start(FragmentActivity activity, Callback<Integer> callback) {
        start(activity, callback, true);
    }

    public void start(FragmentActivity activity) {
        start(activity, null, true);
    }

    public void start(FragmentActivity activity, boolean isNeedCheckOnlyWifi) {
        start(activity, null, isNeedCheckOnlyWifi);
    }

    public void addBook(BookContainer book) {
        if (mList == null) {
            mList = new ArrayList<>();
        }
        mList.add(book);
    }

    @Override
    public void callback(Boolean wifi) {
        int size = mList.size();
        for (int i = 0; i < mList.size(); i++) {
            if (BookManager.isBookInstalled(mList.get(i).getBookCode())) {
                mList.remove(i--);
            }
        }

        //回调：有多少本书已下载
        if (mCallback != null)
            mCallback.callback(size - mList.size());

        if (mList.size() == 0) {
            return;
        }

        for (BookContainer book : mList) {
            download(book, wifi);
        }
    }

    private void download(BookContainer book, boolean wifi) {
        //执行下载操作
        BookManager.download(book, wifi);
    }
}
