package com.ellabook.project.ellareader;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

public class AudioWordLayout extends FrameLayout {
    boolean inited = false;
    private RecordListener listener;

    public void setListener(RecordListener listener) {
        this.listener = listener;
    }

    public AudioWordLayout(@NonNull Context context) {
        super(context);
        init();
    }

    public AudioWordLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public AudioWordLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public AudioWordLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private View vPlay;
    private ImageView vAnimation;
    private TextView vScore;
    private View vRecording;
    private RoundProgressBar roundProgressBar;
    private Integer score = null;
    private String url = null;

    private void init() {
        if (!inited) {
            inited = true;
            addView(LayoutInflater.from(getContext()).inflate(R.layout.word_record_layout, this, false));
            roundProgressBar = findViewById(R.id.vProgress);
            vPlay = findViewById(R.id.vPlay);
            vAnimation = findViewById(R.id.vAnimation);
            vScore = findViewById(R.id.vScore);
            vRecording = findViewById(R.id.vRecording);
            vRecording.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (roundProgressBar.getBackground() != null) {

                        if (listener != null) {
                            listener.onRecordClick(false);
                        }
                    } else {
                        if (listener != null) {
                            listener.onRecordClick(true);
                        }
                    }
                }
            });
        }
    }

    public void showRecordingUI() {
        vAnimation.setVisibility(VISIBLE);
        ((AnimationDrawable) vAnimation.getDrawable()).start();
        vPlay.setVisibility(INVISIBLE);
        vScore.setVisibility(INVISIBLE);
        roundProgressBar.setBackground(null);
        roundProgressBar.setProgress(0);
    }

    public void hideRecodingUI() {
        vAnimation.setVisibility(INVISIBLE);
        ((AnimationDrawable) vAnimation.getDrawable()).stop();
        if (url != null) {
            vPlay.setVisibility(INVISIBLE);
            vScore.setVisibility(INVISIBLE);
        }
        roundProgressBar.setBackgroundResource(R.drawable.word_recording_progressing_bg);
        roundProgressBar.setProgress(0);
    }

    public void setProgress(int time, int max) {
        roundProgressBar.setProgress(time);
        roundProgressBar.setMax(max);
    }

    public void setScore(Integer score) {
        this.score = score;
        vScore.setText("得分" + score + "分");
    }

    public void setUrl(String url) {
        this.url = url;
        vPlay.setVisibility(VISIBLE);
    }

    public interface RecordListener {
        void onRecordClick(boolean isRecording);

        void onPlayClick();
    }
}
