/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.viewholder;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ellabook.project.base.img.BookDefaultDrawable;
import com.ellabook.project.base.img.ImageLoader;
import ellaenglish.data.HttpPicBookInfo;
import ellaenglish.picbook.R;

public class PicReadPassRecommendViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private ImageView ivBookCover;
    private TextView tvBookTitle;
    private HttpPicBookInfo info;
    private OnClickBook onClickBook;

    public PicReadPassRecommendViewHolder(@NonNull View itemView, OnClickBook onClickBook) {
        super(itemView);
        this.onClickBook = onClickBook;
        this.ivBookCover = (ImageView)itemView.findViewById(R.id.ivBookCover);
        this.tvBookTitle = (TextView)itemView.findViewById(R.id.tvBookTitle);
        itemView.setOnClickListener((View.OnClickListener)this);
    }

    public void bind(HttpPicBookInfo info) {
        this.info = info;
        ImageLoader.getInstance().loadCircleRoundedCornersTransformation(this.itemView.getContext(), info.coverUrl, this.ivBookCover, (Drawable)new BookDefaultDrawable());
        this.tvBookTitle.setText((CharSequence)info.goodsName);
    }

    public void onClick(View v) {
        if (this.onClickBook != null) {
            this.onClickBook.onClick(this.info);
        }
    }

    public static interface OnClickBook {
        public void onClick(HttpPicBookInfo var1);
    }
}

