/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.list;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ellabook.project.base.async.Executors;
import com.ellabook.project.base.mvp.EllaBaseFragment;
import com.ellabook.project.base.ui.theme.dialog.DialogFactory;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.book.BookManager;
import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.book.download.BookListDownloadHelper;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import ellaenglish.EditDoneEvent;
import ellaenglish.OffsetItemDecoration;
import ellaenglish.data.HttpPicBookInfo;
import ellaenglish.list.PicBookBuyItemAdapter;
import ellaenglish.list.PicBookBuyItemHolder;
import ellaenglish.list.PicbookListContract;
import ellaenglish.list.PicbookListPresent;
import ellaenglish.picbook.R;
import ellax.base.simple.SimpleAnimatorListener;
import ellax.base.transition.TransitionHelper;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class PicBookBuyListFragment
extends EllaBaseFragment<PicbookListContract.IPresent>
implements PicbookListContract.IView {
    RecyclerView recyclerView;
    SmartRefreshLayout smartRefresh;
    TextView tvSelectAllBooks;
    TextView tvDeteleBooks;
    TextView tvDownloadBooks;
    View rlDeleteAll;
    View vListBack;
    private List<HttpPicBookInfo> mHttpPicBookInfos;
    private List<HttpPicBookInfo> mDownHttpPicBookInfos;
    private List<HttpPicBookInfo> mDeleteHttpPicBookInfos;
    private PicBookBuyItemAdapter mPicBookItemAdapter;
    private String levelCode;
    private String type;
    boolean editMode = false;
    private ValueAnimator transAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
    private ValueAnimator alphaAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
    private AnimatorSet animatorSet = new AnimatorSet();
    private boolean targetVisible = false;

    protected PicbookListContract.IPresent createPresenter() {
        return new PicbookListPresent(this);
    }

    private void injectView(View view) {
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.smartRefresh = (SmartRefreshLayout)view.findViewById(R.id.smartRefresh);
        this.tvSelectAllBooks = (TextView)view.findViewById(R.id.tvSelectAllBooks);
        this.tvDeteleBooks = (TextView)view.findViewById(R.id.tvDeteleBooks);
        this.tvDownloadBooks = (TextView)view.findViewById(R.id.tvDownloadBooks);
        this.rlDeleteAll = view.findViewById(R.id.rlDeleteAll);
        this.vListBack = view.findViewById(R.id.vListBack);
        this.vListBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicBookBuyListFragment.this.recyclerView.smoothScrollToPosition(0);
            }
        });
        view.findViewById(R.id.tvSelectAllBooks).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicBookBuyListFragment.this.selectAllBooks();
            }
        });
        view.findViewById(R.id.tvDeteleBooks).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicBookBuyListFragment.this.deleteBooks();
            }
        });
        view.findViewById(R.id.tvDownloadBooks).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicBookBuyListFragment.this.downLoadBooks();
            }
        });
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View convertView = inflater.inflate(R.layout.fragment_picbook_list, container, false);
        this.injectView(convertView);
        this.init();
        TransitionHelper.bindTransition((Object)this, (View)convertView, null);
        TransitionHelper.register((Fragment)this, (int)0x7FFFFFFC, (int)R.layout.fragment_picbook_list_buy_empty);
        TransitionHelper.register((Fragment)this, (int)0x7FFFFFFD, (int)R.layout.page_network_down_purple_dark_bg);
        return convertView;
    }

    private void hideTab() {
        if (!this.targetVisible) {
            return;
        }
        this.targetVisible = false;
        if (this.animatorSet.isRunning()) {
            this.animatorSet.cancel();
        }
        this.transAnimation.setFloatValues(new float[]{this.rlDeleteAll.getTranslationY(), this.rlDeleteAll.getHeight()});
        this.alphaAnimation.setFloatValues(new float[]{this.rlDeleteAll.getAlpha(), 0.0f});
        this.animatorSet.playTogether(new Animator[]{this.transAnimation, this.alphaAnimation});
        this.animatorSet.start();
    }

    private void showTab() {
        if (this.targetVisible) {
            return;
        }
        this.targetVisible = true;
        if (this.animatorSet.isRunning()) {
            this.animatorSet.cancel();
        }
        this.transAnimation.setFloatValues(new float[]{this.rlDeleteAll.getTranslationY(), 0.0f});
        this.alphaAnimation.setFloatValues(new float[]{this.rlDeleteAll.getAlpha(), 1.0f});
        this.animatorSet.playTogether(new Animator[]{this.transAnimation, this.alphaAnimation});
        this.animatorSet.start();
    }

    private void init() {
        this.transAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PicBookBuyListFragment.this.rlDeleteAll.setTranslationY(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        this.alphaAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PicBookBuyListFragment.this.rlDeleteAll.setAlpha(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        this.alphaAnimation.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (PicBookBuyListFragment.this.rlDeleteAll.getAlpha() <= 0.0f) {
                    PicBookBuyListFragment.this.rlDeleteAll.setVisibility(8);
                }
            }

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                PicBookBuyListFragment.this.rlDeleteAll.setVisibility(0);
            }
        });
        if (this.getArguments() != null) {
            this.levelCode = this.getArguments().getString("levelCode");
            this.type = this.getArguments().getString("type");
        }
        this.mDownHttpPicBookInfos = new ArrayList<HttpPicBookInfo>();
        this.mDeleteHttpPicBookInfos = new ArrayList<HttpPicBookInfo>();
        this.smartRefresh.setEnableRefresh(true);
        this.smartRefresh.setEnableLoadMore(false);
        this.smartRefresh.setPrimaryColors(new int[]{10654463});
        this.smartRefresh.setOnRefreshListener(new OnRefreshListener(){

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                PicBookBuyListFragment.this.getPicBookList(PicBookBuyListFragment.this.levelCode, PicBookBuyListFragment.this.type, false);
                if (PicBookBuyListFragment.this.rlDeleteAll.getVisibility() == 0) {
                    PicBookBuyListFragment.this.tvSelectAllBooks.setSelected(false);
                    PicBookBuyListFragment.this.tvSelectAllBooks.setText((CharSequence)"\u5168\u9009");
                }
            }
        });
        this.mPicBookItemAdapter = new PicBookBuyItemAdapter(this, this.type);
        final GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this.getActivity(), 2, 0, false);
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                int fist = gridLayoutManager.findFirstVisibleItemPosition();
                if (fist < 2) {
                    PicBookBuyListFragment.this.vListBack.setVisibility(8);
                } else {
                    PicBookBuyListFragment.this.vListBack.setVisibility(0);
                }
            }
        });
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new OffsetItemDecoration(140, 35, 35, 0));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new OffsetItemDecoration(0, 10, 0, 1));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.mPicBookItemAdapter);
    }

    public void onResume() {
        super.onResume();
        this.getPicBookList(this.levelCode, this.type, true);
    }

    @Override
    public void showGetPicBookList(List<HttpPicBookInfo> httpPicBookInfos) {
        if (this.smartRefresh != null) {
            this.smartRefresh.finishRefresh();
            this.stopProgress();
            this.bindPicBookList(httpPicBookInfos);
        }
    }

    @Override
    public void showGetPicBookListFail(String msg) {
        this.stopProgress();
        this.showNetworkError();
        if (this.smartRefresh != null) {
            this.smartRefresh.finishRefresh();
            this.recyclerView.setVisibility(8);
        }
        try {
            ((TextView)this.getView().findViewById(R.id.tvError)).setText((CharSequence)msg);
        }
        catch (Exception e) {
            Log.e((String)"omg", (String)"tv error not found", (Throwable)e);
        }
    }

    public void getPicBookList(String levelCode, String type, boolean isShowLoading) {
        this.showProgress();
        ((PicbookListContract.IPresent)this.getPresenter()).doGetPicBookListAction(this, levelCode, type, isShowLoading);
    }

    private void bindPicBookList(List<HttpPicBookInfo> httpPicBookInfoList) {
        this.stopProgress();
        HttpPicBookInfo eventInfo = new HttpPicBookInfo();
        this.mHttpPicBookInfos = httpPicBookInfoList;
        if (httpPicBookInfoList != null && httpPicBookInfoList.size() > 0) {
            this.recyclerView.setVisibility(0);
            eventInfo.picBookCode = "ALL";
            this.mPicBookItemAdapter.addData(httpPicBookInfoList);
        } else {
            this.showEmpty();
        }
        EventBus.getDefault().post((Object)eventInfo);
    }

    public void selectAllBooksByUser(boolean isSelectAll) {
        this.tvSelectAllBooks.setSelected(isSelectAll);
        this.tvSelectAllBooks.postInvalidate();
        int selectedCount = 0;
        for (HttpPicBookInfo info : this.mHttpPicBookInfos) {
            if (info.selectType != 1) continue;
            ++selectedCount;
        }
        EventBus.getDefault().post((Object)new EditDoneEvent(true, selectedCount));
    }

    void selectAllBooks() {
        if (this.tvSelectAllBooks.isSelected()) {
            this.tvSelectAllBooks.setSelected(false);
        } else {
            this.tvSelectAllBooks.setSelected(true);
        }
        this.updateSelectAll(this.tvSelectAllBooks.isSelected());
    }

    void deleteBooks() {
        if (this.mHttpPicBookInfos != null && this.mHttpPicBookInfos.size() > 0) {
            if (this.mDeleteHttpPicBookInfos == null) {
                this.mDeleteHttpPicBookInfos = new ArrayList<HttpPicBookInfo>();
            }
            this.mDeleteHttpPicBookInfos.clear();
            for (HttpPicBookInfo info : this.mHttpPicBookInfos) {
                boolean isDownLoad;
                if (info.selectType != 1 || !(isDownLoad = BookManager.isBookInstalled((String)info.getBookCode()))) continue;
                this.mDeleteHttpPicBookInfos.add(info);
            }
            if (this.mDeleteHttpPicBookInfos.size() > 0) {
                DialogFactory.getTwoButtonDialog((Context)this.getContext(), (String)"\u662f\u5426\u5220\u9664\u9009\u4e2d\u7ed8\u672c", (DialogInterface.OnClickListener)new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        switch (which) {
                            case 0: {
                                dialog.dismiss();
                                break;
                            }
                            case 1: {
                                dialog.dismiss();
                                final ArrayList needDeletes = new ArrayList(PicBookBuyListFragment.this.mDeleteHttpPicBookInfos);
                                final SoftReference<PicBookBuyItemAdapter> srAdapter = new SoftReference<PicBookBuyItemAdapter>(PicBookBuyListFragment.this.mPicBookItemAdapter);
                                PicBookBuyListFragment.this.showProgress();
                                Executors.exec((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        for (HttpPicBookInfo item : needDeletes) {
                                            BookManager.uninstallSync((BookContainer)item);
                                        }
                                        FragmentActivity activity = PicBookBuyListFragment.this.getActivity();
                                        if (activity != null) {
                                            activity.runOnUiThread(new Runnable(){

                                                @Override
                                                public void run() {
                                                    PicBookBuyItemAdapter adapter = (PicBookBuyItemAdapter)((Object)srAdapter.get());
                                                    if (adapter != null) {
                                                        adapter.notifyDataSetChanged();
                                                    }
                                                    PicBookBuyListFragment.this.stopProgress();
                                                    PicBookBuyListFragment.this.postExitEditMode();
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    }
                }).show(this.getFragmentManager());
            } else {
                ToastUtils.showCenterToast((String)"\u6ca1\u6709\u53ef\u4ee5\u5220\u9664\u7684\u7ed8\u672c\u54e6~");
            }
        }
    }

    void downLoadBooks() {
        if (this.mHttpPicBookInfos != null && this.mHttpPicBookInfos.size() > 0) {
            if (this.mDownHttpPicBookInfos == null) {
                this.mDownHttpPicBookInfos = new ArrayList<HttpPicBookInfo>();
            }
            this.mDownHttpPicBookInfos.clear();
            for (HttpPicBookInfo info : this.mHttpPicBookInfos) {
                boolean isDownLoad;
                if (info.selectType != 1 || (isDownLoad = BookManager.isBookInstalled((String)info.getBookCode()))) continue;
                this.mDownHttpPicBookInfos.add(info);
            }
            if (this.mDownHttpPicBookInfos.size() > 0) {
                ArrayList<HttpPicBookInfo> needDownloads = new ArrayList<HttpPicBookInfo>();
                for (HttpPicBookInfo bookInfo : this.mDownHttpPicBookInfos) {
                    needDownloads.add(bookInfo);
                }
                new BookListDownloadHelper(needDownloads).start(this.getActivity());
                this.postExitEditMode();
            } else {
                ToastUtils.showCenterToast((String)"\u6ca1\u6709\u7ed8\u672c\u53ef\u4ee5\u4e0b\u8f7d\u54e6~");
            }
        }
    }

    public int getPicBookInfoSize() {
        return this.mHttpPicBookInfos != null && this.mHttpPicBookInfos.size() > 0 ? this.mHttpPicBookInfos.size() : 0;
    }

    public void showDeleteAllLayout(boolean isShow) {
        if (isShow) {
            this.showTab();
        } else {
            this.hideTab();
        }
    }

    public void updateEditImgVisiable(int visiableState) {
        if (this.mPicBookItemAdapter != null) {
            this.mPicBookItemAdapter.updateEditImgVisiable(visiableState);
        }
        if (this.recyclerView != null) {
            int childSize = this.recyclerView.getChildCount();
            for (int i = 0; i < childSize; ++i) {
                View child = this.recyclerView.getChildAt(i);
                RecyclerView.ViewHolder viewHolder = this.recyclerView.getChildViewHolder(child);
                if (viewHolder == null || !(viewHolder instanceof PicBookBuyItemHolder)) continue;
                PicBookBuyItemHolder picBookBuyItemHolder = (PicBookBuyItemHolder)viewHolder;
                picBookBuyItemHolder.refreshWithVisibleState(visiableState, this.mPicBookItemAdapter.isUpdateEdit);
            }
        }
    }

    public void updateSelectAll(boolean isSelectAll) {
        if (this.mHttpPicBookInfos != null) {
            for (HttpPicBookInfo httpPicBookInfo : this.mHttpPicBookInfos) {
                if (isSelectAll) {
                    httpPicBookInfo.selectType = 1;
                    continue;
                }
                httpPicBookInfo.selectType = 0;
            }
            this.updateEditImgVisiable(1);
            if (isSelectAll) {
                EventBus.getDefault().post((Object)new EditDoneEvent(true, this.mHttpPicBookInfos.size()));
            } else {
                EventBus.getDefault().post((Object)new EditDoneEvent(true, 0));
            }
        }
    }

    public void setLevelCode(String levelCode) {
        this.levelCode = levelCode;
    }

    public void postExitEditMode() {
        EventBus.getDefault().post((Object)new EditDoneEvent(false, 0));
    }
}

