/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.list;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.img.BookDefaultDrawable;
import com.ellabook.project.base.img.ImageLoader;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.biz.BizReader;
import com.ellabook.project.ellareader.book.BookManager;
import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.book.download.BookDownloadHelper;
import com.ellabook.project.ellareader.ui.read.BookReader;
import ellaenglish.data.HttpPicBookInfo;
import ellaenglish.list.PicBookBuyItemAdapter;
import ellaenglish.picbook.R;
import ellax.bookmanager.BookEvent;
import ellax.log.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class PicBookBuyItemHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    ImageView picEditImageView;
    ViewGroup picBookLayout;
    ImageView picBookImageView;
    TextView picBookLevelImageView;
    TextView picBookTextView;
    View picDownloadImageView;
    View vProgressWrapper;
    View vOffShelves;
    ProgressBar vProgress;
    private PicBookBuyItemAdapter.PicBookItemHolderListener listener;
    private HttpPicBookInfo httpPicBookInfo;
    private String type;
    private int editImgVisiableState;

    private void injectView(View view) {
        this.vOffShelves = view.findViewById(R.id.vOffShelves);
        this.vProgressWrapper = view.findViewById(R.id.vProgressWrapper);
        this.vProgress = (ProgressBar)view.findViewById(R.id.vProgress);
        this.picEditImageView = (ImageView)view.findViewById(R.id.picEditImageView);
        this.picBookLayout = (ViewGroup)view.findViewById(R.id.lldsa);
        this.picBookImageView = (ImageView)view.findViewById(R.id.picBookImageView);
        this.picBookLevelImageView = (TextView)view.findViewById(R.id.picBookLevelImageView);
        this.picBookTextView = (TextView)view.findViewById(R.id.picBookTextView);
        this.picDownloadImageView = view.findViewById(R.id.picDownloadImageView);
    }

    public PicBookBuyItemHolder(View itemView, String type) {
        super(itemView);
        this.type = type;
        this.injectView(itemView);
        itemView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                EventBus.getDefault().register((Object)PicBookBuyItemHolder.this);
            }

            public void onViewDetachedFromWindow(View v) {
                EventBus.getDefault().unregister((Object)PicBookBuyItemHolder.this);
            }
        });
    }

    public void refreshWithVisibleState(int editImgVisiableState, boolean isUpdateEdit) {
        this.editImgVisiableState = editImgVisiableState;
        if (this.httpPicBookInfo != null && isUpdateEdit) {
            if (editImgVisiableState == 1) {
                this.picEditImageView.setVisibility(0);
                if (this.httpPicBookInfo.selectType == 0) {
                    this.picEditImageView.setSelected(false);
                } else {
                    this.picEditImageView.setSelected(true);
                }
            } else {
                this.picEditImageView.setVisibility(4);
            }
        }
    }

    public void bind(Context context, final HttpPicBookInfo item, int imgVisiableState, int startDownload, boolean isUpdateEdit) {
        this.httpPicBookInfo = item;
        this.editImgVisiableState = imgVisiableState;
        if (this.vOffShelves != null) {
            if (!item.available) {
                this.vOffShelves.setVisibility(0);
            } else {
                this.vOffShelves.setVisibility(4);
            }
        }
        this.refreshWithVisibleState(imgVisiableState, isUpdateEdit);
        ImageLoader.getInstance().loadCircleRoundedCornersTransformation(context, item.coverUrl, this.picBookImageView, (Drawable)new BookDefaultDrawable());
        this.picBookLevelImageView.setText((CharSequence)item.lexileLevelCode);
        this.picBookTextView.setText((CharSequence)item.goodsName);
        this.picBookImageView.setOnClickListener((View.OnClickListener)this);
        this.vProgressWrapper.setOnClickListener((View.OnClickListener)this);
        this.picDownloadImageView.setOnClickListener((View.OnClickListener)this);
        this.picEditImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                v.setSelected(!v.isSelected());
                if (PicBookBuyItemHolder.this.listener != null) {
                    PicBookBuyItemHolder.this.listener.onItemClicked(item);
                }
            }
        });
        this.refreshDownloadUI(null);
    }

    public void onClick(View v) {
        if (this.httpPicBookInfo == null) {
            return;
        }
        if (this.editImgVisiableState == 1) {
            if (this.httpPicBookInfo != null && this.picEditImageView != null) {
                this.picEditImageView.setSelected(!this.picEditImageView.isSelected());
                if (this.listener != null) {
                    this.listener.onItemClicked(this.httpPicBookInfo);
                }
            }
            return;
        }
        boolean isBookCurrentVersionInstalled = BookManager.isBookInstalled((String)this.httpPicBookInfo.getBookCode());
        if (!BookManager.isBookUp2Date((String)this.httpPicBookInfo.getBookCode(), (String)this.httpPicBookInfo.version, (boolean)this.httpPicBookInfo.isPublicResource())) {
            isBookCurrentVersionInstalled = false;
        }
        if (isBookCurrentVersionInstalled) {
            Logger.record((String)"ch_study_look");
            BookReader.bookRead((Context)v.getContext(), (BookContainer)this.httpPicBookInfo, (boolean)false, ("LESSON".equals(ApplicationHolder.getContext().getString(R.string.pic_book_type)) ? 1 : 0) != 0);
            return;
        }
        if (!BookManager.isDownloading((BookContainer)this.httpPicBookInfo)) {
            BizReader.getInstance().bookStatus(null, this.httpPicBookInfo.bookCode, null, (HttpServiceCallBack)new HttpServiceCallBack<Boolean>(){

                public void onHttpServiceFinished(Boolean aBoolean) {
                    if (aBoolean != null && aBoolean.booleanValue()) {
                        Logger.record((String)"ch_study_download", (String)"1");
                        new BookDownloadHelper((BookContainer)PicBookBuyItemHolder.this.httpPicBookInfo).start(null, false);
                    } else {
                        ToastUtils.showCenterToast((String)ApplicationHolder.getContext().getString(R.string.book_offshelves_please_get_out));
                    }
                }

                public void onHttpServiceError(int i, String s) {
                    ToastUtils.showCenterToast((String)(s == null ? "\u670d\u52a1\u5668\u8fd4\u56de\u5f02\u5e38" : s));
                }
            });
        } else {
            BookManager.pause((BookContainer)this.httpPicBookInfo);
        }
    }

    private FragmentActivity getActivity(Context context) {
        if (context instanceof FragmentActivity) {
            return (FragmentActivity)context;
        }
        if (context instanceof ContextWrapper) {
            return this.getActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public void onDestroy() {
    }

    private void refreshDownloadUI(BookEvent event) {
        if (this.httpPicBookInfo == null) {
            return;
        }
        if (event != null && event.eventType == -12) {
            this.picDownloadImageView.setVisibility(0);
            this.vProgressWrapper.setVisibility(8);
            return;
        }
        if (BookManager.isBookInstalled((String)this.httpPicBookInfo.getBookCode())) {
            this.picDownloadImageView.setVisibility(8);
            this.vProgressWrapper.setVisibility(8);
        } else if (event == null || !TextUtils.equals((CharSequence)this.httpPicBookInfo.getBookCode(), (CharSequence)event.bookCode)) {
            if (ellax.bookmanager.BookManager.isDownloading((ellax.bookmanager.BookContainer)this.httpPicBookInfo)) {
                this.picDownloadImageView.setVisibility(8);
                this.vProgressWrapper.setVisibility(0);
                this.vProgress.setProgress(0);
            } else {
                this.picDownloadImageView.setVisibility(0);
                this.vProgressWrapper.setVisibility(8);
            }
        } else {
            switch (event.eventType) {
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -1: {
                    this.picDownloadImageView.setVisibility(0);
                    this.vProgressWrapper.setVisibility(8);
                    break;
                }
                case -7: 
                case -6: 
                case -2: {
                    event.progress = 100;
                }
                case -5: 
                case -3: {
                    this.picDownloadImageView.setVisibility(8);
                    this.vProgressWrapper.setVisibility(0);
                    this.vProgress.setProgress(event.progress);
                    break;
                }
                case -4: {
                    this.picDownloadImageView.setVisibility(0);
                    this.vProgressWrapper.setVisibility(8);
                }
            }
            if (event.success) {
                Logger.record((String)"ch_study_download", (String)"2");
                this.picDownloadImageView.setVisibility(8);
                this.vProgressWrapper.setVisibility(8);
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onDownloadEvent(BookEvent event) {
        if (this.httpPicBookInfo == null || !TextUtils.equals((CharSequence)this.httpPicBookInfo.getBookCode(), (CharSequence)event.bookCode)) {
            return;
        }
        this.refreshDownloadUI(event);
    }

    public void setOnPicBookItemHolderListener(PicBookBuyItemAdapter.PicBookItemHolderListener listener) {
        this.listener = listener;
    }
}

