/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.list;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import ellaenglish.data.HttpPicBookInfo;
import ellaenglish.list.PicBookBuyItemHolder;
import ellaenglish.list.PicBookBuyListFragment;
import ellaenglish.picbook.R;
import java.util.ArrayList;
import java.util.List;

public class PicBookBuyItemAdapter
extends RecyclerView.Adapter<PicBookBuyItemHolder> {
    private Context context;
    private int editImgVisiableState = 0;
    private int startDownload = 0;
    public boolean isUpdateEdit = false;
    private PicBookBuyListFragment fragment;
    private List<HttpPicBookInfo> list;
    private String type;

    public PicBookBuyItemAdapter(PicBookBuyListFragment fragment, String type) {
        this.fragment = fragment;
        this.context = fragment.getContext();
        this.type = type;
        this.list = new ArrayList<HttpPicBookInfo>();
    }

    public void addData(List<HttpPicBookInfo> list) {
        this.list.clear();
        this.list.addAll(list);
        this.notifyDataSetChanged();
    }

    @NonNull
    public PicBookBuyItemHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.picbook_item, parent, false);
        return new PicBookBuyItemHolder(view, this.type);
    }

    public void onViewRecycled(@NonNull PicBookBuyItemHolder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.onDestroy();
    }

    public void onBindViewHolder(@NonNull PicBookBuyItemHolder holder, int position) {
        HttpPicBookInfo info = this.list.get(position);
        holder.bind(this.context, info, this.editImgVisiableState, this.startDownload, this.isUpdateEdit);
        holder.setOnPicBookItemHolderListener(new PicBookItemHolderListener(){

            @Override
            public void onItemClicked(HttpPicBookInfo item) {
                PicBookBuyItemAdapter.this.updateSelectState(item);
            }
        });
    }

    public void onViewAttachedToWindow(@NonNull PicBookBuyItemHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.refreshWithVisibleState(this.editImgVisiableState, this.isUpdateEdit);
    }

    public int getItemCount() {
        return this.list.size();
    }

    public void doDownloadAction(int indexAction) {
        this.startDownload = indexAction;
        this.isUpdateEdit = false;
        this.notifyDataSetChanged();
    }

    public void updateEditImgVisiable(int editImgVisiableState) {
        this.editImgVisiableState = editImgVisiableState;
        this.isUpdateEdit = true;
    }

    public void updateSelectState(HttpPicBookInfo item) {
        if (this.editImgVisiableState == 0) {
            return;
        }
        if (item == null) {
            return;
        }
        item.selectType = item.selectType == 0 ? 1 : 0;
        boolean allSelect = true;
        for (HttpPicBookInfo itemInfo : this.list) {
            if (itemInfo.selectType != 0) continue;
            allSelect = false;
        }
        this.fragment.selectAllBooksByUser(allSelect);
    }

    static interface PicBookItemHolderListener {
        public void onItemClicked(HttpPicBookInfo var1);
    }
}

