/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.list;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ellabook.project.base.mvp.EllaBaseFragment;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import ellaenglish.OffsetItemDecoration;
import ellaenglish.data.HttpPicBookInfo;
import ellaenglish.list.PicBookAllItemAdapter;
import ellaenglish.list.PicbookListContract;
import ellaenglish.list.PicbookListPresent;
import ellaenglish.picbook.R;
import ellax.base.transition.TransitionHelper;
import java.util.ArrayList;
import java.util.List;

public class PicBookAllListFragment
extends EllaBaseFragment<PicbookListContract.IPresent>
implements PicbookListContract.IView {
    RecyclerView recyclerView;
    SmartRefreshLayout smartRefresh;
    TextView tvSelectAllBooks;
    TextView tvDeteleBooks;
    TextView tvDownloadBooks;
    View rlDeleteAll;
    View vListBack;
    private PicBookAllItemAdapter mPicBookItemAdapter;
    private String levelCode;
    private String type;
    private boolean isRecommend;

    protected PicbookListContract.IPresent createPresenter() {
        return new PicbookListPresent(this);
    }

    private void injectView(final View view) {
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.smartRefresh = (SmartRefreshLayout)view.findViewById(R.id.smartRefresh);
        this.tvSelectAllBooks = (TextView)view.findViewById(R.id.tvSelectAllBooks);
        this.tvDeteleBooks = (TextView)view.findViewById(R.id.tvDeteleBooks);
        this.tvDownloadBooks = (TextView)view.findViewById(R.id.tvDownloadBooks);
        this.rlDeleteAll = view.findViewById(R.id.rlDeleteAll);
        this.vListBack = view.findViewById(R.id.vListBack);
        this.vListBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicBookAllListFragment.this.recyclerView.smoothScrollToPosition(0);
            }
        });
        if (this.getResources().getBoolean(R.bool.pic_search_shown)) {
            view.findViewById(R.id.vSearchWrapper).setVisibility(0);
            view.findViewById(R.id.vSearch).setOnClickListener(new View.OnClickListener(){
                List<HttpPicBookInfo> totalData = null;

                public void onClick(View v) {
                    String text = ((EditText)view.findViewById(R.id.vInput)).getText().toString();
                    if (this.totalData == null || this.totalData.isEmpty()) {
                        this.totalData = PicBookAllListFragment.this.mPicBookItemAdapter.getData();
                        if (this.totalData != null) {
                            this.totalData = new ArrayList<HttpPicBookInfo>(this.totalData);
                        }
                    }
                    if (this.totalData != null) {
                        if (!TextUtils.isEmpty((CharSequence)text)) {
                            ArrayList<HttpPicBookInfo> filteredData = new ArrayList<HttpPicBookInfo>();
                            for (HttpPicBookInfo info : this.totalData) {
                                if (info == null || TextUtils.isEmpty((CharSequence)info.getBookName()) || !info.getBookName().toUpperCase().contains(text.toUpperCase())) continue;
                                filteredData.add(info);
                            }
                            PicBookAllListFragment.this.mPicBookItemAdapter.addData(filteredData);
                        } else {
                            PicBookAllListFragment.this.mPicBookItemAdapter.addData(new ArrayList<HttpPicBookInfo>(this.totalData));
                        }
                    }
                }
            });
        }
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.getArguments().getString("type");
        }
        return this.type;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View convertView = inflater.inflate(R.layout.fragment_picbook_list, container, false);
        this.injectView(convertView);
        this.init();
        TransitionHelper.bindTransition((Object)this, (View)convertView, null);
        TransitionHelper.register((Fragment)this, (int)0x7FFFFFFD, (int)R.layout.page_network_down_purple_dark_bg);
        if ("ALL".equals(this.type)) {
            TransitionHelper.register((Fragment)this, (int)0x7FFFFFFC, (int)R.layout.fragment_picbook_list_all_empty);
        } else if ("COMMAND".equals(this.type)) {
            TransitionHelper.register((Fragment)this, (int)0x7FFFFFFC, (int)R.layout.fragment_picbook_list_recommend_empty);
        }
        return convertView;
    }

    private void init() {
        if (this.getArguments() != null) {
            this.levelCode = this.getArguments().getString("levelCode");
            this.type = this.getArguments().getString("type");
            this.isRecommend = this.getArguments().getBoolean("isRecommend");
        }
        this.smartRefresh.setEnableRefresh(true);
        this.smartRefresh.setPrimaryColors(new int[]{10654463});
        this.smartRefresh.setEnableLoadMore(false);
        this.smartRefresh.setOnRefreshListener(new OnRefreshListener(){

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                PicBookAllListFragment.this.getPicBookList(PicBookAllListFragment.this.levelCode, PicBookAllListFragment.this.type, false);
            }
        });
        this.mPicBookItemAdapter = new PicBookAllItemAdapter(this.getContext(), this.getType(), this);
        final GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this.getActivity(), 2, 0, false);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                int fist = gridLayoutManager.findFirstVisibleItemPosition();
                if (fist < 2) {
                    PicBookAllListFragment.this.vListBack.setVisibility(8);
                } else {
                    PicBookAllListFragment.this.vListBack.setVisibility(0);
                }
            }
        });
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new OffsetItemDecoration(140, 35, 35, 0));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new OffsetItemDecoration(0, 10, 0, 1));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.mPicBookItemAdapter);
    }

    public void onResume() {
        super.onResume();
        this.refresh();
    }

    public void refresh() {
        this.getPicBookList(this.levelCode, this.type, true);
    }

    @Override
    public void showGetPicBookList(List<HttpPicBookInfo> httpPicBookInfos) {
        this.stopProgress();
        if (this.smartRefresh != null) {
            this.smartRefresh.finishRefresh();
            this.bindPicBookList(httpPicBookInfos);
        } else {
            this.showEmpty();
        }
    }

    @Override
    public void showGetPicBookListFail(String msg) {
        this.stopProgress();
        this.showNetworkError();
        if (this.smartRefresh != null) {
            this.smartRefresh.finishRefresh();
            this.recyclerView.setVisibility(8);
        }
        try {
            ((TextView)this.getView().findViewById(R.id.tvError)).setText((CharSequence)msg);
        }
        catch (Exception e) {
            Log.e((String)"omg", (String)"tv error not found", (Throwable)e);
        }
    }

    public void getPicBookList(String levelCode, String type, boolean isShowLoading) {
        this.showProgress();
        ((PicbookListContract.IPresent)this.getPresenter()).doGetPicBookListAction(this, levelCode, type, isShowLoading);
    }

    private void bindPicBookList(List<HttpPicBookInfo> httpPicBookInfoList) {
        this.stopProgress();
        if (httpPicBookInfoList != null && httpPicBookInfoList.size() > 0) {
            this.recyclerView.setVisibility(0);
            this.mPicBookItemAdapter.addData(httpPicBookInfoList);
        } else {
            this.showEmpty();
        }
    }

    public void setLevelCode(String levelCode) {
        this.levelCode = levelCode;
    }
}

