/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.list;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.img.BookDefaultDrawable;
import com.ellabook.project.base.img.ImageLoader;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.biz.BizReader;
import ellaenglish.data.HttpPicBookInfo;
import ellaenglish.list.PicBookAllListFragment;
import ellaenglish.picbook.R;
import ellax.log.Logger;

public class PicBookAllItemHolder
extends RecyclerView.ViewHolder {
    private View itemView;
    private String type;
    private PicBookAllListFragment fragment;

    public PicBookAllItemHolder(View itemView, String tp, PicBookAllListFragment fragment) {
        super(itemView);
        this.itemView = itemView;
        this.type = tp;
        this.fragment = fragment;
    }

    public void bind(Context context, final HttpPicBookInfo item) {
        this.itemView.setTag((Object)item);
        View vOffShelves = this.itemView.findViewById(R.id.vOffShelves);
        View picBookLayout = this.itemView.findViewById(R.id.lldsa);
        ImageView picBookImageView = (ImageView)this.itemView.findViewById(R.id.picBookImageView);
        TextView picBookLevelImageView = (TextView)this.itemView.findViewById(R.id.picBookLevelImageView);
        TextView picBookTextView = (TextView)this.itemView.findViewById(R.id.picBookTextView);
        View picBookBoughtImageView = this.itemView.findViewById(R.id.picBookBoughtImageView);
        if (vOffShelves != null) {
            if (!item.available) {
                vOffShelves.setVisibility(0);
            } else {
                vOffShelves.setVisibility(4);
            }
        }
        ImageLoader.getInstance().loadCircleRoundedCornersTransformation(context, item.coverUrl, picBookImageView, (Drawable)new BookDefaultDrawable());
        picBookLevelImageView.setText((CharSequence)item.lexileLevelCode);
        picBookTextView.setText((CharSequence)item.goodsName);
        picBookBoughtImageView.setVisibility(item.bought ? 0 : 8);
        picBookLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TextUtils.equals((CharSequence)"ALL", (CharSequence)PicBookAllItemHolder.this.type)) {
                    Logger.record((String)"en_studyall_buybook");
                } else {
                    Logger.record((String)"en_studyintroduce_buybook");
                }
                BizReader.getInstance().bookStatus(null, item.bookCode, null, (HttpServiceCallBack)new HttpServiceCallBack<Boolean>(){

                    public void onHttpServiceFinished(Boolean aBoolean) {
                        if (aBoolean != null && aBoolean.booleanValue()) {
                            PicBookAllItemHolder.this.routerPicDetail(item);
                        } else {
                            ToastUtils.showToast((String)ApplicationHolder.getContext().getString(R.string.book_offshelves_please_get_out));
                            if (PicBookAllItemHolder.this.fragment != null) {
                                PicBookAllItemHolder.this.fragment.refresh();
                            }
                        }
                    }

                    public void onHttpServiceError(int i, String s) {
                        ToastUtils.showCenterToast((String)(s == null ? "\u670d\u52a1\u5668\u8fd4\u56de\u5f02\u5e38" : s));
                    }
                });
            }
        });
    }

    private void routerPicDetail(HttpPicBookInfo item) {
        ARouter.getInstance().build(Uri.parse((String)"/picbook/detail")).withString("goodsCode", item.goodsCode).withString("picBookCode", item.picBookCode).withTransition(0x10A0000, 0x10A0001).navigation();
    }
}

