/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.detail.banner;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ellabook.project.base.img.ImgLoader;
import com.ellabook.project.base.ui.export.preview.PhotoBrowseView;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.base.util.VideoUtil;
import ellaenglish.PicRouteConfig;
import ellaenglish.detail.PicBookDetailActivity;
import ellaenglish.detail.banner.PreBannerEntity;
import ellaenglish.picbook.R;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import jp.wasabeef.glide.transformations.RoundedCornersTransformation;

public class PreBannerQuickAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<PreBannerEntity> bannerList;
    private PhotoBrowseView photoBrowseView;
    private Context context;

    public PreBannerQuickAdapter(Context context) {
        this.context = context;
        this.bannerList = new ArrayList<PreBannerEntity>();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.picbook_item_banner_pre, null));
    }

    public void onBindViewHolder(final @NonNull ViewHolder holder, int position) {
        final PreBannerEntity item = this.bannerList.get(position);
        if (!TextUtils.isEmpty((CharSequence)item.getVideoPath())) {
            holder.ivPlayer.setVisibility(0);
            holder.ivPlayer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!TextUtils.isEmpty((CharSequence)item.getVideoPath())) {
                        PicRouteConfig.getInstance().getRouter().routerVideoPlay(item.getVideoPath(), PreBannerQuickAdapter.this.context);
                    } else {
                        ToastUtils.showCenterToast((String)PreBannerQuickAdapter.this.context.getResources().getString(R.string.video_path_empty));
                    }
                }
            });
            ImgLoader.getInstance().loadCircleImg(this.context, RoundedCornersTransformation.CornerType.ALL, 16, "", holder.ivCoverUrl, PicBookDetailActivity.getDetailPreBannerDefault());
            Observable.fromArray((Object[])new String[]{item.getVideoPath()}).map((Function)new Function<String, Bitmap>(){

                public Bitmap apply(String s) {
                    try {
                        return VideoUtil.getNetVideoBitmap((String)s);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Bitmap>(){

                public void accept(Bitmap bitmap) {
                    if (((Activity)PreBannerQuickAdapter.this.context).isDestroyed()) {
                        return;
                    }
                    if (bitmap != null) {
                        ImgLoader.getInstance().loadRoundImg(PreBannerQuickAdapter.this.context, RoundedCornersTransformation.CornerType.ALL, 16, bitmap, holder.ivCoverUrl, PicBookDetailActivity.getDetailPreBannerDefault());
                    } else {
                        holder.ivCoverUrl.setImageResource(PicBookDetailActivity.getDetailPreBannerDefault());
                    }
                }
            });
        } else {
            holder.ivPlayer.setVisibility(8);
            ImgLoader.getInstance().loadCircleImg(this.context, RoundedCornersTransformation.CornerType.ALL, 16, item.getCoverUrl(), holder.ivCoverUrl, PicBookDetailActivity.getDetailPreBannerDefault());
        }
        holder.itemView.setTag((Object)position);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PreBannerQuickAdapter.this.notPic((Integer)view.getTag())) {
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)item.getCoverUrl())) {
                    PreBannerQuickAdapter.this.photoBrowseView.setVisibility(0);
                    PreBannerQuickAdapter.this.photoBrowseView.switchPage(PreBannerQuickAdapter.this.calcPicPosition((Integer)view.getTag()));
                }
            }
        });
    }

    public boolean notPic(int x) {
        if (this.bannerList == null || x >= this.bannerList.size()) {
            return true;
        }
        PreBannerEntity temp = this.bannerList.get(x);
        return temp == null || !TextUtils.isEmpty((CharSequence)temp.getVideoPath());
    }

    public int calcPicPosition(int x) {
        if (this.bannerList == null || x >= this.bannerList.size()) {
            return 0;
        }
        int newPosition = 0;
        PreBannerEntity temp = null;
        for (int i = 0; i < this.bannerList.size() && i < x; ++i) {
            temp = this.bannerList.get(i);
            if (temp == null || !TextUtils.isEmpty((CharSequence)temp.getVideoPath())) continue;
            ++newPosition;
        }
        return newPosition;
    }

    public int getItemCount() {
        return this.bannerList.size();
    }

    public void replaceData(List<PreBannerEntity> bannerList, PhotoBrowseView photoBrowseView) {
        this.photoBrowseView = photoBrowseView;
        this.bannerList.clear();
        this.bannerList.addAll(bannerList);
        ArrayList<String> images = new ArrayList<String>();
        for (PreBannerEntity entity : bannerList) {
            String coverUrl = entity.getCoverUrl();
            if (TextUtils.isEmpty((CharSequence)coverUrl)) continue;
            images.add(coverUrl);
        }
        this.photoBrowseView.setData(images);
        this.notifyDataSetChanged();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivPlayer;
        ImageView ivCoverUrl;

        public ViewHolder(View itemView) {
            super(itemView);
            this.ivPlayer = (ImageView)itemView.findViewById(R.id.ivPlayer);
            this.ivCoverUrl = (ImageView)itemView.findViewById(R.id.ivCoverUrl);
        }
    }
}

