/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.detail;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.ellabook.netwrok.bean.order.HttpOrderRequest;
import com.ellabook.netwrok.bean.order.HttpOrderResponse;
import com.ellabook.netwrok.bean.profile.HttpJuge;
import com.ellabook.netwrok.http.EllaHttpService;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.mvp.EllaBaseActivity;
import com.ellabook.project.base.mvp.MvpBaseModel;
import com.ellabook.project.base.orderpay.EllaPayHelper;
import com.ellabook.project.base.storage.SPSaveManager;
import com.ellabook.project.base.trade.HttpCoin;
import com.ellabook.project.base.util.NetworkUtil;
import com.ellabook.project.base.util.ToastUtils;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.trello.rxlifecycle2.android.ActivityEvent;
import ellaenglish.biz.BizPicbook;
import ellaenglish.data.HttpPicBookDetailInfo;
import ellaenglish.detail.PicBookDetailContract;
import java.util.List;
import org.json.JSONObject;

public class PicBookDetailModel
extends MvpBaseModel<PicBookDetailContract.IPresent>
implements PicBookDetailContract.IModel {
    @Override
    public void doGetBookDetailInfo(EllaBaseActivity activity, String goodsCode, String picBookCode) {
        activity.showProgress();
        LifecycleTransformer lifecycleTransformer = activity.bindUntilEvent(ActivityEvent.PAUSE);
        BizPicbook.getInstance().getPicBookDetailInfo(lifecycleTransformer, goodsCode, picBookCode, new HttpServiceCallBack<HttpPicBookDetailInfo>(){

            public void onHttpServiceFinished(HttpPicBookDetailInfo result) {
                ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showGetBookDetailInfoSuc(result);
            }

            public void onHttpServiceError(int code, String msg) {
                ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showGetBokkDetailInfoFail(msg);
            }
        });
    }

    @Override
    public void doGetCommentListAction(EllaBaseActivity activity, String picBookCode, String pageNo, String pageSize) {
        if (NetworkUtil.networkAvailable()) {
            LifecycleTransformer lifecycleTransformer = activity.bindUntilEvent(ActivityEvent.PAUSE);
            EllaHttpService.getInstance((Context)activity).getCommentList(lifecycleTransformer, picBookCode, pageNo, pageSize, (HttpServiceCallBack)new HttpServiceCallBack<HttpJuge>(){

                public void onHttpServiceFinished(HttpJuge result) {
                    ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showGetCommentListSuc(result);
                }

                public void onHttpServiceError(int code, String msg) {
                    ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showGetCommentListFail(msg);
                }
            });
        }
    }

    @Override
    public void doCommentAction(EllaBaseActivity activity, String resId, String resName, String resType, String reviewContent, String reviewType) {
        if (NetworkUtil.networkAvailable()) {
            activity.showProgress();
            LifecycleTransformer lifecycleTransformer = activity.bindUntilEvent(ActivityEvent.PAUSE);
            EllaHttpService.getInstance((Context)activity).doComment(lifecycleTransformer, resId, resName, resType, reviewContent, reviewType, (HttpServiceCallBack)new HttpServiceCallBack<Boolean>(){

                public void onHttpServiceFinished(Boolean result) {
                    ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showCommentSuccess();
                    ToastUtils.showCenterToast((String)"\u6dfb\u52a0\u8bc4\u8bba\u6210\u529f");
                }

                public void onHttpServiceError(int code, String msg) {
                    ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showCommentFail();
                    ToastUtils.showCenterToast((String)msg);
                }
            });
        }
    }

    @Override
    public void doReEllaCoinRecharge(final EllaBaseActivity activity, HttpOrderRequest request, final int indexType) {
        LifecycleTransformer transformer = activity.bindUntilEvent(ActivityEvent.PAUSE);
        EllaHttpService.getInstance((Context)activity).createPayOrder(transformer, request, (HttpServiceCallBack)new HttpServiceCallBack<HttpOrderResponse>(){

            public void onHttpServiceFinished(HttpOrderResponse result) {
                try {
                    Log.i((String)"CM TAG", (String)(result.getOrderNo() + "=========" + result.getSign()));
                    if (indexType == 0) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("orderNo", (Object)result.getOrderNo());
                        jsonObject.put("appid", (Object)result.getAppid());
                        jsonObject.put("sign", (Object)result.getSign());
                        jsonObject.put("partnerid", (Object)result.getPartnerid());
                        jsonObject.put("prepayid", (Object)result.getPrepayid());
                        jsonObject.put("noncestr", (Object)result.getNoncestr());
                        jsonObject.put("timestamp", (Object)result.getTimestamp());
                        EllaPayHelper.getInstance().doPayAction(1, jsonObject.toString(), (Activity)activity);
                    } else {
                        EllaPayHelper.getInstance().doPayAction(0, result.getSign(), (Activity)activity);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onHttpServiceError(int code, String msg) {
                Log.i((String)"CM TAG", (String)(code + "======onHttpServiceError===" + msg));
            }
        });
    }

    @Override
    public void doEllaPayAction(EllaBaseActivity activity, HttpOrderRequest request) {
        if (NetworkUtil.networkAvailable()) {
            LifecycleTransformer lifecycleTransformer = activity.bindUntilEvent(ActivityEvent.PAUSE);
            EllaHttpService.getInstance((Context)activity).createPayOrder(lifecycleTransformer, request, (HttpServiceCallBack)new HttpServiceCallBack<HttpOrderResponse>(){

                public void onHttpServiceFinished(HttpOrderResponse result) {
                    ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showEllaPaySucess(result);
                }

                public void onHttpServiceError(int code, String msg) {
                    ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showEllaPayFail(msg);
                }
            });
        }
    }

    @Override
    public void loadEllaConfig(EllaBaseActivity activity) {
        if (NetworkUtil.networkAvailable()) {
            LifecycleTransformer lifecycleTransformer = activity.bindUntilEvent(ActivityEvent.PAUSE);
            String uid = SPSaveManager.getInstance((Context)activity).getInfo("user_id");
            EllaHttpService.getInstance((Context)activity).getConConfig(lifecycleTransformer, uid, (HttpServiceCallBack)new HttpServiceCallBack<List<HttpCoin>>(){

                public void onHttpServiceFinished(List<HttpCoin> httpCoins) {
                    ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showGetCoinConfigSuc(httpCoins);
                }

                public void onHttpServiceError(int code, String msg) {
                    ((PicBookDetailContract.IPresent)PicBookDetailModel.this.getPresenter()).showGetCoinConfigFail(msg);
                }
            });
        }
    }
}

