/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.detail;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import co.lujun.androidtagview.TagContainerLayout;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.ellabook.netwrok.MapOrderCommonDialog;
import com.ellabook.netwrok.bean.order.HttpOrderResponse;
import com.ellabook.netwrok.bean.profile.HttpJuge;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.netwrok.recharge.EllaRechargeEvent;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.HttpUserInfo;
import com.ellabook.project.base.event.RayResultEvent;
import com.ellabook.project.base.img.BookDefaultDrawable;
import com.ellabook.project.base.img.ImageLoader;
import com.ellabook.project.base.log.EllaLog;
import com.ellabook.project.base.mvp.EllaBaseActivity;
import com.ellabook.project.base.orderpay.EllaPayHelper;
import com.ellabook.project.base.storage.SPConstantConfig;
import com.ellabook.project.base.trade.HttpCoin;
import com.ellabook.project.base.ui.export.preview.PhotoBrowseView;
import com.ellabook.project.base.ui.theme.widget.ExpandableTextView;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.biz.BizReader;
import com.ellabook.project.ellareader.book.BookManager;
import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.book.download.BookDownloadHelper;
import com.ellabook.project.ellareader.ui.read.BookOffShelvesDialog;
import com.ellabook.project.ellareader.ui.read.BookReader;
import ellaenglish.CenterAlignImageSpan;
import ellaenglish.OffsetItemDecoration;
import ellaenglish.PicRouteConfig;
import ellaenglish.data.HttpPicBookDetailInfo;
import ellaenglish.detail.BookBuyFragment;
import ellaenglish.detail.PicBookDetailContract;
import ellaenglish.detail.PicBookDetailPresent;
import ellaenglish.detail.banner.PreBannerEntity;
import ellaenglish.detail.banner.PreBannerQuickAdapter;
import ellaenglish.detail.banner.RecommendBannerQuickAdapter;
import ellaenglish.picbook.R;
import ellax.base.helper.AppExecutors;
import ellax.base.transition.TransitionHelper;
import ellax.base.transition.TransitionStateListener;
import ellax.bookmanager.BookEvent;
import ellax.log.Logger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.json.JSONObject;

@Route(path="/picbook/detail")
public class PicBookDetailActivity
extends EllaBaseActivity<PicBookDetailContract.IPresent>
implements PicBookDetailContract.IView,
TransitionStateListener {
    ImageView vBack;
    TextView vVipTag;
    TextView tvGuidePrice;
    TextView tvReadPicBook;
    TextView tvShopPicBook;
    TextView tvRecommendTitle;
    TextView tvBuyVip;
    NestedScrollView scrollView;
    ImageView ivBookImg;
    TextView tvLexileLevel;
    TextView tvBookName;
    TextView tvBookAuther;
    TagContainerLayout tagContainer;
    TextView tvBookPrice;
    ExpandableTextView expandBookDes;
    View vPreView;
    RecyclerView preRecyclerView;
    RecyclerView recommendRecyclerView;
    ViewGroup vMoreInfo;
    PhotoBrowseView picPhotoBrowseView;
    View vPhotoGone;
    View mapAllView;
    private MapOrderCommonDialog orderDialog = null;
    private int count = 0;
    private PreBannerQuickAdapter mPreBannerQuickAdapter;
    private RecommendBannerQuickAdapter mRecommendBannerQuickAdapter;
    private String goodsCode;
    private String picBookCode;
    private String bookName;
    private boolean mAllReadFinish;
    private int indexType;
    private HttpPicBookDetailInfo mHttpPicBookDetailInfo;
    boolean directReadMark = false;

    public static int getDetailPreBannerDefault() {
        return R.drawable.ic_en_book_detail_pre_banner_default;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onDownloadEvent(BookEvent event) {
        if (this.mHttpPicBookDetailInfo == null) {
            return;
        }
        if (event.eventType == -12) {
            this.setTextForRead("\u6682\u505c");
            if (event.noEnoughSpace()) {
                ToastUtils.showToast((String)"\u8bf7\u68c0\u67e5\u8bbe\u5907\u5269\u4f59\u7a7a\u95f4");
            }
            return;
        }
        if (!TextUtils.equals((CharSequence)this.mHttpPicBookDetailInfo.bookCode, (CharSequence)event.bookCode)) {
            return;
        }
        switch (event.eventType) {
            case -7: {
                this.setTextForRead("\u89e3\u538b\u4e2d");
                break;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -1: {
                this.setTextForRead("\u9605\u8bfb");
                break;
            }
            case -6: 
            case -2: {
                event.progress = 100;
                this.setTextForRead("\u9605\u8bfb");
            }
            case -5: 
            case -3: {
                this.setTextForRead(event.progress + "%");
                break;
            }
            case -4: {
                this.setTextForRead("\u6682\u505c");
            }
        }
        if (event.success) {
            BookReader.bookRead((Context)this, (BookContainer)this.mHttpPicBookDetailInfo, (!this.mHttpPicBookDetailInfo.isBuy ? 1 : 0) != 0, (boolean)("LESSON".equals(this.getString(R.string.pic_book_type)) ? true : this.mHttpPicBookDetailInfo.isReadFinish));
            this.setTextForRead("\u9605\u8bfb");
        }
    }

    @Override
    public void showGetCoinConfigFail(String m) {
        this.stopProgress();
    }

    @Override
    public void showGetCoinConfigSuc(List<HttpCoin> httpCoins) {
        this.stopProgress();
        if (this.orderDialog != null) {
            HttpUserInfo userInfo = SPConstantConfig.getHttpUserInfo((Context)this);
            EllaRechargeEvent event = new EllaRechargeEvent();
            event.balance = userInfo.accountDto.balance + "";
            event.list = httpCoins;
            this.orderDialog.showEllaConfig(event);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onRechargeLoadingEvent(EllaRechargeEvent event) {
        ((PicBookDetailContract.IPresent)this.getPresenter()).loadEllaConfig(this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void handleRechargeEvent(RayResultEvent resultEvent) {
        EllaLog.i((String)"CM TAG", (String)"=======handleRechargeEvent=========");
        if (resultEvent.payResultType == 1) {
            if (this.orderDialog != null) {
                this.orderDialog.dismiss();
                this.orderDialog = null;
            }
            this.getPicBookDetailInfo(this.goodsCode, this.picBookCode);
        }
    }

    protected PicBookDetailContract.IPresent createPresenter() {
        return new PicBookDetailPresent(this);
    }

    private void injectView() {
        this.vBack = (ImageView)this.findViewById(R.id.vBack);
        this.scrollView = (NestedScrollView)this.findViewById(R.id.scrollView);
        this.ivBookImg = (ImageView)this.findViewById(R.id.ivBookImg);
        this.tvLexileLevel = (TextView)this.findViewById(R.id.tvLexileLevel);
        this.tvBookName = (TextView)this.findViewById(R.id.tvBookName);
        this.tvBookAuther = (TextView)this.findViewById(R.id.tvBookAuther);
        this.tagContainer = (TagContainerLayout)this.findViewById(R.id.tagContainer);
        this.tvBookPrice = (TextView)this.findViewById(R.id.tvBookStone);
        this.tvRecommendTitle = (TextView)this.findViewById(R.id.tvRecommendTitle);
        this.expandBookDes = (ExpandableTextView)this.findViewById(R.id.expandBookDes);
        this.vPreView = this.findViewById(R.id.vPreView);
        this.preRecyclerView = (RecyclerView)this.findViewById(R.id.preRecyclerView);
        this.recommendRecyclerView = (RecyclerView)this.findViewById(R.id.recommendRecyclerView);
        this.vMoreInfo = (ViewGroup)this.findViewById(R.id.vMoreInfo);
        this.picPhotoBrowseView = (PhotoBrowseView)this.findViewById(R.id.picPhotoBrowseView);
        this.vPhotoGone = this.picPhotoBrowseView.findViewById(R.id.vPhotoGone);
        this.mapAllView = this.findViewById(R.id.mapAllView);
        this.tvReadPicBook = (TextView)this.findViewById(R.id.tvReadPicBook);
        this.tvShopPicBook = (TextView)this.findViewById(R.id.tvShopPicBook);
        this.vVipTag = (TextView)this.findViewById(R.id.vPriceVip);
        this.tvGuidePrice = (TextView)this.findViewById(R.id.tvOriginPrice);
        this.tvBuyVip = (TextView)this.findViewById(R.id.tvBuyVip);
        this.findViewById(R.id.tvReadPicBook).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicBookDetailActivity.this.doDownload();
            }
        });
        this.findViewById(R.id.tvShopPicBook).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicBookDetailActivity.this.doShop();
            }
        });
        this.findViewById(R.id.vBack).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicBookDetailActivity.this.finish();
            }
        });
        this.findViewById(R.id.vPhotoGone).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicBookDetailActivity.this.picPhotoBrowseView.setVisibility(8);
            }
        });
        this.tvBuyVip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                intent.setComponent(new ComponentName((Context)PicBookDetailActivity.this, "com.ellamix.profile.ProfileActivity"));
                intent.putExtra("ProfileActivity.TYPE", "ProfileActivity.TYPE_MEMBER");
                intent.putExtra("ProfileActivity.ZH", false);
                PicBookDetailActivity.this.startActivity(intent);
            }
        });
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TransitionHelper.setContentView((Activity)this, (int)R.layout.picbook_details, (int)R.id.vBack);
        this.injectView();
        this.init();
    }

    protected void onResume() {
        super.onResume();
        UserInfoProvider.requestUpdateUserInfo(null);
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.getPicBookDetailInfo(this.goodsCode, this.picBookCode);
    }

    protected void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister((Object)this);
    }

    public void onBackPressed() {
        if (this.picPhotoBrowseView.getVisibility() == 0) {
            this.picPhotoBrowseView.setVisibility(8);
        } else {
            this.finish();
        }
    }

    @Override
    public void showGetBookDetailInfoSuc(HttpPicBookDetailInfo httpPicBookDetailInfo) {
        this.stopProgress();
        this.bookName = httpPicBookDetailInfo.bookName;
        this.bindPicBookDetailInfo(httpPicBookDetailInfo);
    }

    @Override
    public void showGetBokkDetailInfoFail(String msg) {
        this.stopProgress();
        this.showNetworkError();
        try {
            ((TextView)this.findViewById(R.id.tvError)).setText((CharSequence)msg);
        }
        catch (Exception e) {
            Log.e((String)"omg", (String)"tv error not found", (Throwable)e);
        }
    }

    @Override
    public void showGetCommentListSuc(HttpJuge result) {
        this.count = result.total;
    }

    @Override
    public void showGetCommentListFail(String ms) {
    }

    @Override
    public void showCommentSuccess() {
        this.getPicBookDetailInfo(this.goodsCode, this.picBookCode);
    }

    private void init() {
        if (this.getIntent() != null && this.getIntent().getExtras() != null) {
            this.goodsCode = this.getIntent().getExtras().getString("goodsCode");
            this.picBookCode = this.getIntent().getExtras().getString("picBookCode");
        }
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        linearLayoutManager.setOrientation(1);
        this.mPreBannerQuickAdapter = new PreBannerQuickAdapter((Context)this);
        LinearLayoutManager linearLayoutManagerPre = new LinearLayoutManager((Context)this);
        linearLayoutManagerPre.setOrientation(0);
        this.preRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManagerPre);
        this.preRecyclerView.setAdapter((RecyclerView.Adapter)this.mPreBannerQuickAdapter);
        this.preRecyclerView.setHasFixedSize(true);
        this.preRecyclerView.setNestedScrollingEnabled(false);
        this.preRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new OffsetItemDecoration(32, 13));
        this.mRecommendBannerQuickAdapter = new RecommendBannerQuickAdapter(null);
        this.recommendRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        this.recommendRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new OffsetItemDecoration(32, 30));
        this.recommendRecyclerView.setHasFixedSize(true);
        this.recommendRecyclerView.setNestedScrollingEnabled(false);
        this.recommendRecyclerView.setAdapter((RecyclerView.Adapter)this.mRecommendBannerQuickAdapter);
        this.setTextForShop("\u8d2d\u4e70/\u5151\u6362");
        this.setTextForRead("\u8bd5\u8bfb");
    }

    public void markRefreshAndRead() {
        this.directReadMark = true;
        this.getPicBookDetailInfo(this.goodsCode, this.picBookCode);
    }

    public void refreshPage() {
        this.getPicBookDetailInfo(this.goodsCode, this.picBookCode);
    }

    private void showBookOffShelvesDialog() {
        new BookOffShelvesDialog().show(this.getSupportFragmentManager(), "offshelves");
    }

    private void doDownload() {
        if (this.mHttpPicBookDetailInfo == null) {
            return;
        }
        BizReader.getInstance().bookStatus(null, this.mHttpPicBookDetailInfo.bookCode, null, (HttpServiceCallBack)new HttpServiceCallBack<Boolean>(){

            public void onHttpServiceFinished(Boolean aBoolean) {
                if (aBoolean != null && aBoolean.booleanValue()) {
                    PicBookDetailActivity.this._doDownload();
                } else {
                    PicBookDetailActivity.this.showBookOffShelvesDialog();
                }
            }

            public void onHttpServiceError(int i, String s) {
                ToastUtils.showCenterToast((String)(s == null ? "\u670d\u52a1\u5668\u8fd4\u56de\u5f02\u5e38" : s));
            }
        });
    }

    private void _doDownload() {
        if (BookManager.isDownloading((BookContainer)this.mHttpPicBookDetailInfo)) {
            BookManager.pause((BookContainer)this.mHttpPicBookDetailInfo);
        } else {
            boolean isCurrentVersionInstall = false;
            if (BookManager.isBookInstalled((String)this.mHttpPicBookDetailInfo.getBookCode()) && BookManager.isBookUp2Date((String)this.mHttpPicBookDetailInfo.getBookCode(), (String)this.mHttpPicBookDetailInfo.version, (boolean)this.mHttpPicBookDetailInfo.isPublicResource())) {
                isCurrentVersionInstall = true;
            }
            if (isCurrentVersionInstall) {
                Logger.record((String)"en_introduce_try");
                BookReader.bookRead((Context)this, (BookContainer)this.mHttpPicBookDetailInfo, (!this.mHttpPicBookDetailInfo.isBuy ? 1 : 0) != 0, (boolean)("LESSON".equals(this.getString(R.string.pic_book_type)) ? true : this.mHttpPicBookDetailInfo.isReadFinish));
            } else {
                this.download();
            }
        }
    }

    public void download() {
        BizReader.getInstance().bookStatus(null, this.mHttpPicBookDetailInfo.bookCode, null, (HttpServiceCallBack)new HttpServiceCallBack<Boolean>(){

            public void onHttpServiceFinished(Boolean aBoolean) {
                if (aBoolean != null && aBoolean.booleanValue()) {
                    new BookDownloadHelper((BookContainer)PicBookDetailActivity.this.mHttpPicBookDetailInfo).start((FragmentActivity)PicBookDetailActivity.this);
                } else {
                    ToastUtils.showCenterToast((String)ApplicationHolder.getContext().getString(R.string.book_offshelves_please_get_out));
                }
            }

            public void onHttpServiceError(int i, String s) {
                ToastUtils.showCenterToast((String)(s == null ? "\u670d\u52a1\u5668\u8fd4\u56de\u5f02\u5e38" : s));
            }
        });
    }

    void doShop() {
        if (this.mHttpPicBookDetailInfo == null) {
            return;
        }
        BizReader.getInstance().bookStatus(null, this.mHttpPicBookDetailInfo.bookCode, null, (HttpServiceCallBack)new HttpServiceCallBack<Boolean>(){

            public void onHttpServiceFinished(Boolean aBoolean) {
                if (aBoolean != null && aBoolean.booleanValue()) {
                    PicBookDetailActivity.this._doShop();
                } else {
                    PicBookDetailActivity.this.showBookOffShelvesDialog();
                }
            }

            public void onHttpServiceError(int i, String s) {
                ToastUtils.showCenterToast((String)(s == null ? "\u670d\u52a1\u5668\u8fd4\u56de\u5f02\u5e38" : s));
            }
        });
    }

    void _doShop() {
        if (!UserInfoProvider.isLogin()) {
            PicRouteConfig.getInstance().getRouter().routerLogin((Activity)this);
            return;
        }
        Logger.record((String)"en_introduce_buy");
        BookBuyFragment orderFragment = BookBuyFragment.buildInstance(this.mHttpPicBookDetailInfo, null);
        orderFragment.show(this.getFragmentManager(), "buy");
    }

    @Override
    public void showEllaPaySucess(HttpOrderResponse response) {
        if (this.indexType == 2) {
            float daa;
            this.stopProgress();
            if (this.orderDialog != null) {
                this.orderDialog.dismiss();
            }
            this.orderDialog = null;
            HttpUserInfo httpUserInfo = SPConstantConfig.getHttpUserInfo((Context)this);
            int goodsPrice = (int)(this.mHttpPicBookDetailInfo.goodsPrice * 100.0);
            int balance = (int)(httpUserInfo.accountDto.balance * 100.0f);
            httpUserInfo.accountDto.balance = daa = (float)(balance -= goodsPrice) / 100.0f;
            SPConstantConfig.saveHttpUserInfo((Context)this, (HttpUserInfo)httpUserInfo);
            ToastUtils.showCenterToast((String)"\u652f\u4ed8\u6210\u529f");
            this.getPicBookDetailInfo(this.goodsCode, this.picBookCode);
        } else if (this.indexType == 0) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("appid", (Object)response.getAppid());
                jsonObject.put("sign", (Object)response.getSign());
                jsonObject.put("partnerid", (Object)response.getPartnerid());
                jsonObject.put("prepayid", (Object)response.getPrepayid());
                jsonObject.put("noncestr", (Object)response.getNoncestr());
                jsonObject.put("timestamp", (Object)response.getTimestamp());
                EllaPayHelper.getInstance().doPayAction(this.indexType, jsonObject.toString(), (Activity)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            EllaPayHelper.getInstance().doPayAction(this.indexType, response.getOrderNo(), (Activity)this);
        }
    }

    @Override
    public void showEllaPayFail(String response) {
        this.stopProgress();
        ToastUtils.showToast((String)response);
        if (this.orderDialog != null) {
            this.orderDialog.showBatchViewAgain();
        }
    }

    private void getPicBookDetailInfo(String goodsCode, String picBookCode) {
        this.showProgress();
        ((PicBookDetailContract.IPresent)this.getPresenter()).doGetBookDetailInfoAction(this, goodsCode, picBookCode);
        ((PicBookDetailContract.IPresent)this.getPresenter()).doGetCommentListAction(this, picBookCode, "1", "3");
    }

    private void bindPicBookDetailInfo(final HttpPicBookDetailInfo httpPicBookDetailInfo) {
        this.mHttpPicBookDetailInfo = httpPicBookDetailInfo;
        if (httpPicBookDetailInfo != null) {
            if (BookManager.isBookInstalled((String)this.mHttpPicBookDetailInfo.getBookCode()) && !BookManager.isBookUp2Date((String)this.mHttpPicBookDetailInfo.getBookCode(), (String)this.mHttpPicBookDetailInfo.version, (boolean)this.mHttpPicBookDetailInfo.isPublicResource())) {
                AppExecutors.diskIO((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BookManager.uninstallSync((BookContainer)PicBookDetailActivity.this.mHttpPicBookDetailInfo);
                    }
                });
            }
            ImageLoader.getInstance().loadCircleRoundedCornersTransformation((Context)this, httpPicBookDetailInfo.coverUrl, this.ivBookImg, (Drawable)new BookDefaultDrawable());
            if (TextUtils.isEmpty((CharSequence)httpPicBookDetailInfo.lexileLevelCode)) {
                this.tvLexileLevel.setVisibility(8);
            } else {
                this.tvLexileLevel.setVisibility(0);
                this.tvLexileLevel.setText((CharSequence)httpPicBookDetailInfo.lexileLevelCode);
            }
            this.tvBookName.setText((CharSequence)httpPicBookDetailInfo.bookName);
            if (UserInfoProvider.isVipAvailable()) {
                DecimalFormat df = new DecimalFormat("#0.00");
                this.tvBookPrice.setText((CharSequence)df.format(httpPicBookDetailInfo.goodsPrice));
                this.vVipTag.setVisibility(0);
                this.tvGuidePrice.getPaint().setFlags(16);
                this.tvGuidePrice.setText((CharSequence)this.getString(R.string.book_detail_goods_origin_price, new Object[]{httpPicBookDetailInfo.originalGoodsPrice}));
                this.tvBuyVip.setVisibility(8);
            } else {
                this.tvBookPrice.setText((CharSequence)httpPicBookDetailInfo.originalGoodsPrice);
                this.vVipTag.setVisibility(8);
                this.tvGuidePrice.setText((CharSequence)this.getString(R.string.book_detail_vip_price, new Object[]{String.valueOf(httpPicBookDetailInfo.goodsPrice)}));
                this.tvBuyVip.setVisibility(0);
            }
            this.tvRecommendTitle.setText((CharSequence)this.getString(R.string.en_book_detail_recommend_title_with_level, new Object[]{httpPicBookDetailInfo.levelCode}));
            if (!TextUtils.isEmpty((CharSequence)httpPicBookDetailInfo.tags)) {
                this.tagContainer.setVisibility(0);
                String[] tagArrays = httpPicBookDetailInfo.tags.split(",");
                List<String> tags = Arrays.asList(tagArrays);
                this.tagContainer.setTags(tags);
            } else {
                this.tagContainer.setVisibility(8);
            }
            SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)"");
            if (!TextUtils.isEmpty((CharSequence)httpPicBookDetailInfo.publishName)) {
                ssb.append((CharSequence)httpPicBookDetailInfo.publishName);
                if (!TextUtils.isEmpty((CharSequence)httpPicBookDetailInfo.authorText)) {
                    ssb.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#8478F5")), 0, ssb.length(), 17);
                    ssb.append((CharSequence)"   |   ");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)httpPicBookDetailInfo.authorText)) {
                ssb.append((CharSequence)httpPicBookDetailInfo.authorText);
            }
            if (ssb.length() <= 0) {
                this.tvBookAuther.setText((CharSequence)"\u7a7a");
            } else {
                this.tvBookAuther.setText((CharSequence)ssb);
            }
            this.expandBookDes.setText((CharSequence)httpPicBookDetailInfo.description);
            ArrayList<PreBannerEntity> bannerList = new ArrayList<PreBannerEntity>();
            if (!TextUtils.isEmpty((CharSequence)httpPicBookDetailInfo.videoUrl)) {
                PreBannerEntity preBannerEntity = new PreBannerEntity("", httpPicBookDetailInfo.videoUrl);
                bannerList.add(preBannerEntity);
            }
            ArrayList<PreBannerEntity> bannerImageList = new ArrayList<PreBannerEntity>();
            if (httpPicBookDetailInfo.preImage != null && httpPicBookDetailInfo.preImage.size() > 0) {
                for (String coverUrl : httpPicBookDetailInfo.preImage) {
                    PreBannerEntity preBannerEntity = new PreBannerEntity(coverUrl, "");
                    bannerImageList.add(preBannerEntity);
                }
            }
            bannerList.addAll(bannerImageList);
            if (bannerList.size() > 0) {
                this.vPreView.setVisibility(0);
                this.preRecyclerView.setVisibility(0);
                this.mPreBannerQuickAdapter.replaceData(bannerList, this.picPhotoBrowseView);
            } else {
                this.vPreView.setVisibility(8);
                this.preRecyclerView.setVisibility(8);
            }
            if (httpPicBookDetailInfo.levelRecommend != null && httpPicBookDetailInfo.levelRecommend.size() > 0) {
                this.tvRecommendTitle.setVisibility(0);
                this.recommendRecyclerView.setVisibility(0);
                this.mRecommendBannerQuickAdapter.replaceData(httpPicBookDetailInfo.levelRecommend);
            } else {
                this.tvRecommendTitle.setVisibility(8);
                this.recommendRecyclerView.setVisibility(8);
            }
            ValueGetter[] valueGetters = new ValueGetter[]{new ValueGetter("\u4e0a\u67b6\u65f6\u95f4"){

                @Override
                public String getValue() {
                    if (!TextUtils.isEmpty((CharSequence)httpPicBookDetailInfo.salingDate) && httpPicBookDetailInfo.salingDate.contains(" ")) {
                        return httpPicBookDetailInfo.salingDate.substring(0, httpPicBookDetailInfo.salingDate.indexOf(" "));
                    }
                    return httpPicBookDetailInfo.salingDate;
                }
            }, new ValueGetter("\u7248\u6743\u65b9"){

                @Override
                public String getValue() {
                    return httpPicBookDetailInfo.bookPressName;
                }
            }, new ValueGetter("\u4f5c\u8005"){

                @Override
                public String getValue() {
                    return httpPicBookDetailInfo.authorText;
                }
            }, new ValueGetter("\u7ed8\u8005"){

                @Override
                public String getValue() {
                    return httpPicBookDetailInfo.painting;
                }
            }, new ValueGetter("\u5267\u672c"){

                @Override
                public String getValue() {
                    return httpPicBookDetailInfo.script;
                }
            }, new ValueGetter("\u7f8e\u672f"){

                @Override
                public String getValue() {
                    return httpPicBookDetailInfo.picHandle;
                }
            }, new ValueGetter("\u52a8\u753b\u8bbe\u8ba1"){

                @Override
                public String getValue() {
                    return httpPicBookDetailInfo.interactionEffect;
                }
            }, new ValueGetter("\u97f3\u9891"){

                @Override
                public String getValue() {
                    return httpPicBookDetailInfo.radioMan;
                }
            }, new ValueGetter("\u5ba1\u6821"){

                @Override
                public String getValue() {
                    return httpPicBookDetailInfo.reviewerMan;
                }
            }};
            View childView = null;
            ValueGetter getter = null;
            for (int i = 0; i < this.vMoreInfo.getChildCount() && i < valueGetters.length; ++i) {
                childView = this.vMoreInfo.getChildAt(i);
                getter = valueGetters[i];
                ((TextView)childView.findViewById(R.id.header)).setText((CharSequence)getter.name);
                String value = getter.getValue();
                if (TextUtils.isEmpty((CharSequence)value)) {
                    ((TextView)childView.findViewById(R.id.content)).setText((CharSequence)"");
                    continue;
                }
                ((TextView)childView.findViewById(R.id.content)).setText((CharSequence)value);
            }
            if (httpPicBookDetailInfo.isBuy) {
                this.tvShopPicBook.setVisibility(8);
                this.setTextForRead("\u9605\u8bfb");
                if (this.directReadMark) {
                    this.doDownload();
                }
            } else {
                String supportType = httpPicBookDetailInfo.supportPayType;
                if (supportType != null) {
                    String[] pays = supportType.split(",");
                    boolean firstPay = true;
                    if (pays != null && pays.length == 1 && TextUtils.equals((CharSequence)pays[0], (CharSequence)"STONE")) {
                        this.setTextForShop("\u5151\u6362");
                    } else if (pays != null && pays.length == 1 && TextUtils.equals((CharSequence)pays[0], (CharSequence)"CASH_PAY")) {
                        this.setTextForShop("\u8d2d\u4e70");
                    } else if (pays != null && pays.length == 2) {
                        this.setTextForShop("\u8d2d\u4e70/\u5151\u6362");
                    } else {
                        this.setTextForShop("\u8d2d\u4e70/\u5151\u6362");
                    }
                }
                this.tvShopPicBook.setVisibility(0);
                this.setTextForRead("\u8bd5\u8bfb");
            }
            this.directReadMark = false;
        }
    }

    private void setTextForRead(String text) {
        this.setTextWithImage(R.drawable.ic_en_book_detail_read, text, this.tvReadPicBook);
    }

    private void setTextForShop(String text) {
        this.setTextWithImage(R.drawable.ic_en_book_detail_buy, text, this.tvShopPicBook);
    }

    private void setTextWithImage(int resId, String text, TextView textView) {
        String imageReplace = " image ";
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)imageReplace);
        Drawable fuDrawable = this.getResources().getDrawable(resId);
        fuDrawable.setBounds(0, 0, textView.getLineHeight(), textView.getLineHeight());
        CenterAlignImageSpan imageSpan = new CenterAlignImageSpan(fuDrawable);
        ssb.setSpan((Object)imageSpan, 0, imageReplace.length(), 17);
        ssb.append((CharSequence)" ");
        ssb.append((CharSequence)text);
        textView.setText((CharSequence)ssb);
    }

    public void onViewStateChanged(int i, View view) {
        if (this.vBack != null) {
            if (i != Integer.MAX_VALUE) {
                this.vBack.setColorFilter((ColorFilter)new LightingColorFilter(0, 10654463));
            } else {
                this.vBack.setColorFilter((ColorFilter)new LightingColorFilter(0xFFFFFF, 0));
            }
        }
    }

    public abstract class ValueGetter {
        public String name;

        public abstract String getValue();

        public ValueGetter(String name) {
            this.name = name;
        }
    }
}

