/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.detail;

import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.TryReadController;
import com.ellamix.common.pay.PayQrStringGeneratorBuilder;
import com.ellamix.common.pay.PayQrStringGeneratorEnBookBuilder;
import com.ellamix.common.pay.QrView;
import com.ellamix.network.pay.QrRepository;
import ellaenglish.PicBookModule;
import ellaenglish.data.HttpPicBookDetailInfo;
import ellaenglish.detail.BookBuySuccessFragment;
import ellaenglish.picbook.R;
import ellax.base.helper.ToastHelper;
import ellax.log.Logger;
import java.text.DecimalFormat;

public class BookBuyFragment
extends DialogFragment {
    public static final String BOOK_DETAIL = "BOOK_DETAIL";
    @Deprecated
    public static final String ELLA_PAY = "ELLA_PAY";
    public static final String CASH_PAY = "CASH_PAY";
    public static final String STONE = "STONE";
    QrView vQRCode;
    View vQrBuy;
    View vPowerBuy;
    View vQrWrapper;
    View vPriceVip;
    View vPowerWrapper;
    TextView tvMyPower;
    TextView tvMyPowerX;
    TextView tvCostPower;
    TextView tvCostPowerX;
    View vPowerBuyConfirm;
    TextView tvPayPrice;
    View vClose;
    String bookCode;
    TryReadController.onDoneListener listener;
    HttpPicBookDetailInfo mBookDetailInfo;

    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getDialog().getWindow().setLayout(-1, -1);
        this.getDialog().setCancelable(true);
        this.getDialog().setCanceledOnTouchOutside(true);
    }

    public static BookBuyFragment buildInstance(@NonNull HttpPicBookDetailInfo picBookDetailInfo, TryReadController.onDoneListener listener) {
        BookBuyFragment orderFragment = new BookBuyFragment();
        Bundle args = new Bundle();
        args.putParcelable(BOOK_DETAIL, (Parcelable)picBookDetailInfo);
        orderFragment.setArguments(args);
        orderFragment.listener = listener;
        return orderFragment;
    }

    private void injectView(View view) {
        this.vQRCode = (QrView)view.findViewById(R.id.vQRCode);
        this.vQrBuy = view.findViewById(R.id.vQrBuy);
        this.vPowerBuy = view.findViewById(R.id.vPowerBuy);
        this.vQrWrapper = view.findViewById(R.id.vQrWrapper);
        this.vPowerWrapper = view.findViewById(R.id.vPowerWrapper);
        this.tvMyPower = (TextView)view.findViewById(R.id.tvMyPower);
        this.tvMyPowerX = (TextView)view.findViewById(R.id.tvMyPowerX);
        this.tvCostPower = (TextView)view.findViewById(R.id.tvCostPower);
        this.tvCostPowerX = (TextView)view.findViewById(R.id.tvCostPowerX);
        this.vPriceVip = view.findViewById(R.id.vPriceVip);
        this.vPowerBuyConfirm = view.findViewById(R.id.vPowerBuyConfirm);
        this.tvPayPrice = (TextView)view.findViewById(R.id.tvPayPrice);
        this.vClose = view.findViewById(R.id.vClose);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        View view = inflater.inflate(R.layout.activity_pic_book_buy, container, false);
        this.injectView(view);
        this.mBookDetailInfo = (HttpPicBookDetailInfo)this.getArguments().getParcelable(BOOK_DETAIL);
        this.bookCode = this.mBookDetailInfo.picBookCode;
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.vQrBuy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BookBuyFragment.this.vPowerBuy.setSelected(false);
                BookBuyFragment.this.vQrBuy.setSelected(true);
                BookBuyFragment.this.vPowerWrapper.setVisibility(4);
                BookBuyFragment.this.vQrWrapper.setVisibility(0);
            }
        });
        this.vPowerBuy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BookBuyFragment.this.vPowerBuy.setSelected(true);
                BookBuyFragment.this.vQrBuy.setSelected(false);
                BookBuyFragment.this.vPowerWrapper.setVisibility(0);
                BookBuyFragment.this.vQrWrapper.setVisibility(4);
            }
        });
        this.vClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BookBuyFragment.this.dismiss();
            }
        });
        this.vPriceVip.setVisibility(UserInfoProvider.isVipAvailable() ? 0 : 4);
        this.tvMyPower.setText((CharSequence)String.valueOf(this.getMyPower()));
        if (this.getMyPower() < this.getCostPower()) {
            this.tvMyPowerX.setTextColor(Color.parseColor((String)"#FF5F73"));
            this.tvMyPower.setTextColor(Color.parseColor((String)"#FF5F73"));
            this.vPowerBuyConfirm.setEnabled(false);
        } else {
            this.tvMyPower.setTextColor(Color.parseColor((String)"#ff8478f5"));
            this.tvMyPowerX.setTextColor(Color.parseColor((String)"#ff8478f5"));
            this.vPowerBuyConfirm.setEnabled(true);
            this.vPowerBuyConfirm.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Logger.record((String)"en_bugbook_stone");
                    if (PicBookModule.getInstance().getPay() != null) {
                        PicBookModule.getInstance().getPay().pay(BookBuyFragment.this.bookCode, new HttpServiceCallBack<Boolean>(){

                            public void onHttpServiceFinished(Boolean aBoolean) {
                                if (aBoolean != null && aBoolean.booleanValue()) {
                                    Logger.record((String)"en_exchangebooksuccess");
                                    BookBuyFragment.this.onBoughtSuccess(true);
                                } else {
                                    ToastHelper.showToast((String)"\u5151\u6362\u5931\u8d25");
                                }
                            }

                            public void onHttpServiceError(int i, String s) {
                                ToastHelper.showToast((String)"\u5151\u6362\u5931\u8d25,\u8bf7\u68c0\u67e5\u7f51\u7edc");
                            }
                        });
                    } else {
                        ToastHelper.showToast((String)"\u7a0b\u5e8f\u521d\u59cb\u5316\u5f02\u5e38");
                    }
                }
            });
        }
        this.tvCostPower.setText((CharSequence)String.valueOf(this.getCostPower()));
        this.vQRCode.setUp((QrView.QrFunction)new QrRepository((PayQrStringGeneratorBuilder)new PayQrStringGeneratorEnBookBuilder(UserInfoProvider.getUserId(), this.bookCode)), new QrView.PaySuccessCallback(){

            public void onPaySuccess(String vipEndDate) {
                BookBuyFragment.this.onBoughtSuccess(false);
                Logger.record((String)"en_buybooksuccesss");
            }

            public void onQrCodeScaned() {
                Logger.record((String)"en_buybook_qrcode");
            }
        });
        this.tvPayPrice.setText((CharSequence)this.getBookPrice());
        this.vQrWrapper.setVisibility(8);
        this.vPowerWrapper.setVisibility(8);
        this.vQrBuy.setVisibility(8);
        this.vPowerBuy.setVisibility(8);
        String supportType = this.mBookDetailInfo.supportPayType;
        if (supportType != null) {
            String[] pays = supportType.split(",");
            boolean firstPay = true;
            if (this.contains(pays, STONE)) {
                this.vPowerBuy.setVisibility(0);
                if (firstPay) {
                    this.vPowerBuy.performClick();
                    firstPay = false;
                }
            }
            if (this.contains(pays, CASH_PAY)) {
                this.vQrBuy.setVisibility(0);
                if (firstPay) {
                    this.vQrBuy.performClick();
                    firstPay = false;
                }
            }
        }
    }

    private int getCostPower() {
        if (UserInfoProvider.isVipAvailable()) {
            return this.mBookDetailInfo.goodsPriceStone;
        }
        return this.mBookDetailInfo.originalGoodsPriceStone;
    }

    private int getMyPower() {
        String myPower = UserInfoProvider.getUserStone();
        if (TextUtils.isEmpty((CharSequence)myPower)) {
            return 0;
        }
        try {
            return Integer.parseInt(myPower);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String getBookPrice() {
        if (UserInfoProvider.isVipAvailable()) {
            DecimalFormat df = new DecimalFormat("#0.00");
            return df.format(this.mBookDetailInfo.goodsPrice);
        }
        return this.mBookDetailInfo.originalGoodsPrice;
    }

    public boolean contains(String[] array2, String dest) {
        if (array2 != null) {
            for (String temp : array2) {
                if (!TextUtils.equals((CharSequence)temp, (CharSequence)dest)) continue;
                return true;
            }
        }
        return false;
    }

    private void onBoughtSuccess(boolean powerBought) {
        this.dismiss();
        if (this.listener != null) {
            this.listener.onResult(true);
        } else {
            FragmentManager fm = this.getFragmentManager();
            if (fm != null) {
                BookBuySuccessFragment bookBuySuccessFragment = BookBuySuccessFragment.buildInstance(this.bookCode, powerBought);
                bookBuySuccessFragment.show(fm, "success");
            }
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        Logger.record((String)"en_buybook_shut");
    }
}

