/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish.biz;

import android.content.Context;
import com.ellabook.netwrok.http.EllaHttpService;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.device.ScreenUtil;
import com.ellabook.project.ellareader.bean.picbook.HttpPicBookPopInfo;
import com.trello.rxlifecycle2.LifecycleTransformer;
import ellaenglish.biz.ApiPicbook;
import ellaenglish.data.HttpPicBookDetailInfo;
import ellaenglish.data.HttpPicBookInfo;
import ellaenglish.data.PicBookReadInfo;
import java.util.List;
import java.util.Map;

public class BizPicbook {
    private BizPicbook() {
        EllaHttpService.getInstance((Context)ApplicationHolder.getContext()).addCacheableRequest("/en/picBook/getPicBookInfo/v1");
        EllaHttpService.getInstance((Context)ApplicationHolder.getContext()).addCacheableRequest("/en/picBook/picBookStore/v1");
    }

    public static BizPicbook getInstance() {
        return Holder.sBizPicbook;
    }

    public void getPicBookList(LifecycleTransformer lifecycleTransformer, String levelCode, String type, HttpServiceCallBack<List<HttpPicBookInfo>> callBack) {
        Map map = EllaHttpService.createReuestMap();
        map.put("levelCode", levelCode);
        map.put("type", type);
        map.put("fullScreen", ScreenUtil.checkIfFullScreen((Context)ApplicationHolder.getContext()));
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiPicbook)EllaHttpService.buildInterfaceImpl(ApiPicbook.class)).getPicBookList(EllaHttpService.generateRequestBody((Map)map)), callBack);
    }

    public void getPicBookDetailInfo(LifecycleTransformer lifecycleTransformer, String goodsCode, String picBookCode, HttpServiceCallBack<HttpPicBookDetailInfo> callback) {
        Map map = EllaHttpService.createReuestMap();
        map.put("goodsCode", goodsCode);
        map.put("picBookCode", picBookCode);
        map.put("fullScreen", ScreenUtil.checkIfFullScreen((Context)ApplicationHolder.getContext()));
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiPicbook)EllaHttpService.buildInterfaceImpl(ApiPicbook.class)).getPicBookDetailInfo(EllaHttpService.generateRequestBody((Map)map)), callback);
    }

    public void getPicBookPopInfo(LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<HttpPicBookPopInfo> callBack) {
        Map map = EllaHttpService.createReuestMap();
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiPicbook)EllaHttpService.buildInterfaceImpl(ApiPicbook.class)).getPicBookPopup(EllaHttpService.generateRequestBody((Map)map)), callBack);
    }

    public void getPickPassInfo(String bookCode, LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<PicBookReadInfo> callBack) {
        Map map = EllaHttpService.createReuestMap();
        map.put("bookCode", bookCode);
        map.put("uid", UserInfoProvider.getUserId());
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiPicbook)EllaHttpService.buildInterfaceImpl(ApiPicbook.class)).getPickPassInfo(EllaHttpService.generateRequestBody((Map)map)), callBack);
    }

    public void addReadCount(String picBookCode, LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<String> callBack) {
        Map map = EllaHttpService.createReuestMap();
        map.put("picBookCode", picBookCode);
        map.put("uid", UserInfoProvider.getUserId());
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiPicbook)EllaHttpService.buildInterfaceImpl(ApiPicbook.class)).addReadCount(EllaHttpService.generateRequestBody((Map)map)), callBack);
    }

    private static class Holder {
        private static BizPicbook sBizPicbook = new BizPicbook();

        private Holder() {
        }
    }
}

