/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish;

import android.app.Fragment;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import cn.ellabook.EllaBookViewerHelper;
import com.alibaba.android.arouter.launcher.ARouter;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.Converter;
import com.ellabook.project.ellareader.TryReadController;
import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.ui.read.BookReaderActivity;
import ellaenglish.OffsetItemDecoration;
import ellaenglish.adapter.PicReadPassRecommendAdapter;
import ellaenglish.biz.BizPicbook;
import ellaenglish.data.HttpPicBookDetailInfo;
import ellaenglish.data.HttpPicBookInfo;
import ellaenglish.detail.BookBuyFragment;
import ellaenglish.picbook.R;
import ellaenglish.viewholder.PicReadPassRecommendViewHolder;
import java.io.Serializable;
import java.util.List;

public class PicTryReadFragment
extends Fragment {
    private View vClose;
    private View vTryReadBuy;
    private View vTryReadExit;
    private RecyclerView rcRecommend;
    private PicReadPassRecommendAdapter adapter;
    private TryReadController.onDoneListener listener;
    private BookContainer container;

    public static void show(BookReaderActivity activity, BookContainer container, TryReadController.onDoneListener listener) {
        PicTryReadFragment picTryReadFragment = new PicTryReadFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("container", (Serializable)container);
        picTryReadFragment.setArguments(bundle);
        picTryReadFragment.listener = listener;
        EllaBookViewerHelper.pause();
        activity.getFragmentManager().beginTransaction().replace(R.id.llBookViewControll, (Fragment)picTryReadFragment).commitAllowingStateLoss();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.activity_pic_book_try_read, container, false);
        return view;
    }

    private void injectView(View view) {
        this.vClose = view.findViewById(R.id.vClose);
        this.vTryReadBuy = view.findViewById(R.id.vTryReadBuy);
        this.vTryReadExit = view.findViewById(R.id.vTryReadExit);
        this.rcRecommend = (RecyclerView)view.findViewById(R.id.rcRecommend);
    }

    private void dismiss() {
        try {
            this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
            EllaBookViewerHelper.resume();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initView() {
        this.vClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicTryReadFragment.this.dismiss();
            }
        });
        this.vTryReadBuy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicTryReadFragment.this.tryBuy();
            }
        });
        this.vTryReadExit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicTryReadFragment.this.getActivity().finish();
            }
        });
        this.rcRecommend.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        this.adapter = new PicReadPassRecommendAdapter(new PicReadPassRecommendViewHolder.OnClickBook(){

            @Override
            public void onClick(HttpPicBookInfo info) {
                PicTryReadFragment.this.jumper(info);
            }
        });
        this.rcRecommend.setAdapter((RecyclerView.Adapter)this.adapter);
        this.rcRecommend.addItemDecoration((RecyclerView.ItemDecoration)new OffsetItemDecoration(Converter.dip2px((float)22.0f), Converter.dip2px((float)22.0f), Converter.dip2px((float)22.0f), 0));
        LinearSnapHelper snapHelper = new LinearSnapHelper();
        snapHelper.attachToRecyclerView(this.rcRecommend);
    }

    private void tryBuy() {
        HttpPicBookDetailInfo picBookDetailInfo = (HttpPicBookDetailInfo)this.container;
        BookBuyFragment orderFragment = BookBuyFragment.buildInstance(picBookDetailInfo, new TryReadController.onDoneListener(){

            public void onResult(boolean b) {
                if (b) {
                    PicTryReadFragment.this.dismiss();
                    PicTryReadFragment.this.listener.onResult(b);
                }
            }
        });
        orderFragment.show(this.getFragmentManager(), "buy");
    }

    private void initParams() {
        this.container = (BookContainer)this.getArguments().getSerializable("container");
    }

    public void jumper(HttpPicBookInfo info) {
        this.getActivity().finish();
        ARouter.getInstance().build(Uri.parse((String)"/picbook/detail")).withString("goodsCode", info.goodsCode).withString("picBookCode", info.picBookCode).withTransition(0x10A0000, 0x10A0001).navigation();
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initParams();
        this.injectView(view);
        this.initView();
        BizPicbook.getInstance().getPicBookList(null, UserInfoProvider.getUserLevel(), "COMMAND", new HttpServiceCallBack<List<HttpPicBookInfo>>(){

            public void onHttpServiceFinished(List<HttpPicBookInfo> httpPicBookInfos) {
                if (httpPicBookInfos != null) {
                    for (int i = httpPicBookInfos.size() - 1; i >= 0; --i) {
                        if (!TextUtils.equals((CharSequence)PicTryReadFragment.this.container.getBookCode(), (CharSequence)httpPicBookInfos.get((int)i).picBookCode)) continue;
                        httpPicBookInfos.remove(i);
                    }
                    if (httpPicBookInfos.size() > 5) {
                        httpPicBookInfos = httpPicBookInfos.subList(0, 5);
                    }
                    PicTryReadFragment.this.adapter.setData(httpPicBookInfos);
                }
            }

            public void onHttpServiceError(int i, String s) {
            }
        });
    }
}

