/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.mvp.EllaBaseActivity;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.Converter;
import com.ellabook.project.ellareader.ui.read.BookReaderActivity;
import com.trello.rxlifecycle2.android.ActivityEvent;
import ellaenglish.OffsetItemDecoration;
import ellaenglish.adapter.PicReadPassRecommendAdapter;
import ellaenglish.biz.BizPicbook;
import ellaenglish.data.HttpPicBookInfo;
import ellaenglish.data.PicBookReadInfo;
import ellaenglish.picbook.R;
import ellaenglish.viewholder.PicReadPassRecommendViewHolder;
import ellax.base.transition.TransitionHelper;
import ellax.log.Logger;
import java.util.ArrayList;
import java.util.List;

public class PicReadPassActivity
extends EllaBaseActivity {
    private View vClose;
    private ImageView ivAvator;
    private TextView tvNameAndAge;
    private TextView tvVipRemineDays;
    private TextView tvReadDuration;
    private TextView tvReadBookNums;
    private TextView tvReadBookTotalTime;
    private View vReadAgain;
    private View vReadExit;
    private RecyclerView rcRecommend;
    private PicReadPassRecommendAdapter adapter;
    private ArrayList<String> readStartEnds;
    private String bookCode;

    private void injectView() {
        this.vClose = this.findViewById(R.id.vClose);
        this.ivAvator = (ImageView)this.findViewById(R.id.ivAvator);
        this.tvNameAndAge = (TextView)this.findViewById(R.id.tvNameAndAge);
        this.tvVipRemineDays = (TextView)this.findViewById(R.id.tvVipRemineDays);
        this.tvReadDuration = (TextView)this.findViewById(R.id.tvReadDuration);
        this.tvReadBookNums = (TextView)this.findViewById(R.id.tvReadBookNums);
        this.tvReadBookTotalTime = (TextView)this.findViewById(R.id.tvReadBookTotalTime);
        this.vReadAgain = this.findViewById(R.id.vReadAgain);
        this.vReadExit = this.findViewById(R.id.vReadExit);
        this.rcRecommend = (RecyclerView)this.findViewById(R.id.rcRecommend);
    }

    private void superFinish() {
        super.finish();
    }

    public void finish() {
        this.setResult(1000);
        super.finish();
    }

    private void initView() {
        this.vClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicReadPassActivity.this.superFinish();
            }
        });
        this.vReadAgain.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Logger.record((String)"en_readlast_again");
                PicReadPassActivity.this.setResult(1001);
                PicReadPassActivity.this.superFinish();
            }
        });
        this.vReadExit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicReadPassActivity.this.setResult(1000);
                PicReadPassActivity.this.superFinish();
            }
        });
        Glide.with((View)this.ivAvator).load(UserInfoProvider.getAvator()).apply((BaseRequestOptions)RequestOptions.circleCropTransform()).into(this.ivAvator);
        StringBuilder builder = new StringBuilder();
        builder.append(UserInfoProvider.getUserEname());
        builder.append(" ");
        builder.append(UserInfoProvider.getAge());
        this.tvNameAndAge.setText((CharSequence)builder);
        int remindDays = UserInfoProvider.getVipRemineDays();
        if (remindDays > 0) {
            this.tvVipRemineDays.setText((CharSequence)("\u4f1a\u5458\u6709\u6548\u671f\u5269\u4f59:" + remindDays + "\u5929"));
        } else {
            this.tvVipRemineDays.setText((CharSequence)"\u4f1a\u5458\u6709\u6548\u671f\u5269\u4f59:\u5df2\u8fc7\u671f");
        }
        this.rcRecommend.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        this.adapter = new PicReadPassRecommendAdapter(new PicReadPassRecommendViewHolder.OnClickBook(){

            @Override
            public void onClick(HttpPicBookInfo info) {
                PicReadPassActivity.this.jumper(info);
            }
        });
        this.rcRecommend.setAdapter((RecyclerView.Adapter)this.adapter);
        this.rcRecommend.addItemDecoration((RecyclerView.ItemDecoration)new OffsetItemDecoration(Converter.dip2px((float)22.0f), Converter.dip2px((float)22.0f), Converter.dip2px((float)22.0f), 0));
        LinearSnapHelper snapHelper = new LinearSnapHelper();
        snapHelper.attachToRecyclerView(this.rcRecommend);
    }

    public void jumper(HttpPicBookInfo info) {
        Logger.record((String)"en_readlast_guess");
        this.setResult(1000);
        this.superFinish();
        final HttpPicBookInfo httpPicBookInfo = info;
        BookReaderActivity.add((PreferenceManager.OnActivityResultListener)new PreferenceManager.OnActivityResultListener(){

            public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
                ARouter.getInstance().build(Uri.parse((String)"/picbook/detail")).withString("goodsCode", httpPicBookInfo.goodsCode).withString("picBookCode", httpPicBookInfo.picBookCode).withTransition(0x10A0000, 0x10A0001).navigation();
                return true;
            }
        });
    }

    private void initParams() {
        this.bookCode = this.getIntent().getStringExtra("bookCode");
        if (this.getIntent().getExtras() != null) {
            this.readStartEnds = this.getIntent().getExtras().getStringArrayList("readStartEnds");
        }
    }

    private int calcReadDuration() {
        int result;
        long durationInMillions = 0L;
        if (this.readStartEnds != null) {
            int i = 0;
            while (i + 1 < this.readStartEnds.size()) {
                try {
                    long start = Long.parseLong(this.readStartEnds.get(i));
                    long end = Long.parseLong(this.readStartEnds.get(i + 1));
                    if (end > start) {
                        durationInMillions += end - start;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                i += 2;
            }
        }
        return (result = (int)(durationInMillions / 1000L / 60L)) <= 0 ? 1 : result;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TransitionHelper.setContentView((Activity)this, (int)R.layout.activity_pic_book_pass, (int)R.id.vClose);
        this.injectView();
        this.initView();
        this.initParams();
        this.showProgress();
        BizPicbook.getInstance().getPickPassInfo(this.bookCode, this.bindUntilEvent(ActivityEvent.PAUSE), new HttpServiceCallBack<PicBookReadInfo>(){

            public void onHttpServiceFinished(PicBookReadInfo picBookReadInfo) {
                PicReadPassActivity.this.stopProgress();
                if (picBookReadInfo != null) {
                    int sp2Px = Converter.dip2px((float)50.0f);
                    SpannableStringBuilder builder = new SpannableStringBuilder();
                    AbsoluteSizeSpan span = new AbsoluteSizeSpan(sp2Px, false);
                    builder.append((CharSequence)String.valueOf(PicReadPassActivity.this.calcReadDuration()), (Object)span, 17);
                    builder.setSpan((Object)new TextAppearanceSpan((Context)PicReadPassActivity.this, 1), 0, builder.length(), 17);
                    builder.append((CharSequence)"\u5206");
                    PicReadPassActivity.this.tvReadDuration.setText((CharSequence)builder);
                    builder = new SpannableStringBuilder();
                    builder.append((CharSequence)String.valueOf(picBookReadInfo.readTotalNum), (Object)span, 17);
                    builder.setSpan((Object)new TextAppearanceSpan((Context)PicReadPassActivity.this, 1), 0, builder.length(), 17);
                    builder.append((CharSequence)"\u672c");
                    PicReadPassActivity.this.tvReadBookNums.setText((CharSequence)builder);
                    builder = new SpannableStringBuilder();
                    builder.append((CharSequence)String.valueOf(picBookReadInfo.readTotalTimes), (Object)span, 17);
                    builder.setSpan((Object)new TextAppearanceSpan((Context)PicReadPassActivity.this, 1), 0, builder.length(), 17);
                    builder.append((CharSequence)"\u5206");
                    PicReadPassActivity.this.tvReadBookTotalTime.setText((CharSequence)builder);
                } else {
                    PicReadPassActivity.this.showEmpty();
                }
            }

            public void onHttpServiceError(int i, String s) {
                PicReadPassActivity.this.showNetworkError();
                try {
                    ((TextView)PicReadPassActivity.this.findViewById(R.id.tvError)).setText((CharSequence)s);
                }
                catch (Exception e) {
                    Log.e((String)"omg", (String)"tv error not found", (Throwable)e);
                }
            }
        });
        BizPicbook.getInstance().getPicBookList(this.bindUntilEvent(ActivityEvent.PAUSE), UserInfoProvider.getUserLevel(), "COMMAND", new HttpServiceCallBack<List<HttpPicBookInfo>>(){

            public void onHttpServiceFinished(List<HttpPicBookInfo> httpPicBookInfos) {
                if (httpPicBookInfos != null) {
                    for (int i = httpPicBookInfos.size() - 1; i >= 0; --i) {
                        if (!TextUtils.equals((CharSequence)PicReadPassActivity.this.bookCode, (CharSequence)httpPicBookInfos.get((int)i).picBookCode)) continue;
                        httpPicBookInfos.remove(i);
                    }
                    if (httpPicBookInfos.size() > 5) {
                        httpPicBookInfos = httpPicBookInfos.subList(0, 5);
                    }
                    PicReadPassActivity.this.adapter.setData(httpPicBookInfos);
                }
            }

            public void onHttpServiceError(int i, String s) {
            }
        });
    }
}

