/*
 * Decompiled with CFR 0.152.
 */
package ellaenglish;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.util.Converter;

public class OffsetItemDecoration
extends RecyclerView.ItemDecoration {
    public static final String TAG = "OffsetItemDecoration";
    int startOffsetsInDp = 0;
    int itemOffsetsInDp = 0;
    int endOffsetsInDp = 0;
    int orizontal = 0;

    public OffsetItemDecoration(int startOffsetsInDp, int itemOffsetsInDp) {
        this(startOffsetsInDp, itemOffsetsInDp, 0);
    }

    public OffsetItemDecoration(int startOffsetsInDp, int itemOffsetsInDp, int orizontal) {
        this(startOffsetsInDp, itemOffsetsInDp, 0, 0);
    }

    public OffsetItemDecoration(int startOffsetsInDp, int itemOffsetsInDp, int endOffsetsInDp, int orizontal) {
        this.startOffsetsInDp = Converter.dip2px((Context)ApplicationHolder.getContext(), (float)startOffsetsInDp);
        this.itemOffsetsInDp = Converter.dip2px((Context)ApplicationHolder.getContext(), (float)itemOffsetsInDp);
        this.endOffsetsInDp = Converter.dip2px((Context)ApplicationHolder.getContext(), (float)endOffsetsInDp);
        this.orizontal = orizontal;
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int adaperPosition = parent.getChildAdapterPosition(view);
        if (this.isStart(adaperPosition, parent)) {
            if (this.orizontal == 0) {
                outRect.left = this.startOffsetsInDp;
            } else {
                outRect.top = this.startOffsetsInDp;
            }
        } else if (this.orizontal == 0) {
            outRect.left = this.itemOffsetsInDp;
        } else {
            outRect.top = this.itemOffsetsInDp;
        }
        if (this.isEnd(adaperPosition, parent)) {
            if (this.orizontal == 0) {
                outRect.right = this.endOffsetsInDp;
            } else {
                outRect.bottom = this.endOffsetsInDp;
            }
        }
    }

    private boolean isStart(int position, RecyclerView parent) {
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager manager = (GridLayoutManager)parent.getLayoutManager();
            int spanCount = ((GridLayoutManager)parent.getLayoutManager()).getSpanCount();
            if (this.orizontal != manager.getOrientation()) {
                return position % spanCount == 0;
            }
            return position < spanCount;
        }
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            return position == 0;
        }
        return false;
    }

    private boolean isEnd(int position, RecyclerView parent) {
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager manager = (GridLayoutManager)parent.getLayoutManager();
            int spanCount = ((GridLayoutManager)parent.getLayoutManager()).getSpanCount();
            if (this.orizontal != manager.getOrientation()) {
                return position % spanCount == spanCount - 1;
            }
            return position + spanCount > parent.getAdapter().getItemCount();
        }
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            return position == parent.getAdapter().getItemCount() - 1;
        }
        return false;
    }
}

