/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util.parameterChecking;

import com.ellabook.util.parameterChecking.CheckValue;
import com.ellabook.util.parameterChecking.ContainsValue;
import com.ellabook.util.parameterChecking.DefaultValue;
import com.ellabook.util.parameterChecking.NotBlank;
import com.ellabook.util.parameterChecking.NotEmpty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtil {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationUtil.class);

    public static String checkValue(Object obj) {
        return AnnotationUtil.parseAnnotation(CheckValue.class, obj, true);
    }

    public static String checkBlank(Object obj) {
        return AnnotationUtil.parseNotBlankAnnotation(NotBlank.class, obj, true);
    }

    public static String checkParam(Object obj) {
        AnnotationUtil.parseDefaultValueAnnotation(DefaultValue.class, obj, true);
        String s = AnnotationUtil.parseContainsValueAnnotation(ContainsValue.class, obj, true);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return s;
        }
        return AnnotationUtil.parseNotBlankAnnotation(NotBlank.class, obj, true);
    }

    public static String checkEmpty(Object obj) {
        return AnnotationUtil.parseAnnotation(NotEmpty.class, obj, true);
    }

    private static String parseAnnotation(Class<? extends Annotation> aClazz, Object obj, boolean hasParent) {
        Object[] fields;
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        Class<?> clazz = obj.getClass();
        Object[] bothField = fields = clazz.getDeclaredFields();
        if (hasParent) {
            Class<?> superClazz = clazz.getSuperclass();
            Object[] superFields = superClazz.getDeclaredFields();
            bothField = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])superFields);
        }
        for (Object field : bothField) {
            Annotation annotation = ((Field)field).getAnnotation(aClazz);
            if (annotation == null) continue;
            ((Field)field).setAccessible(true);
            try {
                if (annotation instanceof CheckValue) {
                    String value;
                    CheckValue cv = (CheckValue)annotation;
                    String regex = cv.value();
                    if (StringUtils.isEmpty((CharSequence)regex)) {
                        Object oValue = ((Field)field).get(obj);
                        if (oValue == null) {
                            sb.append("\u5b57\u6bb5" + ((Field)field).getName() + "\u4e0d\u80fd\u4e3anull|");
                            flag = true;
                            continue;
                        }
                        if (oValue instanceof String) {
                            value = (String)oValue;
                            if (!StringUtils.isBlank((CharSequence)value)) continue;
                            sb.append("\u5b57\u6bb5" + ((Field)field).getName() + "\u4e0d\u80fd\u4e3a\u7a7a|");
                            flag = true;
                            continue;
                        }
                        logger.info("\u5b57\u6bb5" + ((Field)field).getName() + "\u4e0d\u662f\u5b57\u7b26\u4e32\uff0c\u4e0d\u80fd\u5224\u65ad\u662f\u5426\u4e3a\u7a7a");
                        continue;
                    }
                    Pattern pattern = Pattern.compile(regex);
                    Matcher m = pattern.matcher(value = (String)((Field)field).get(obj));
                    if (m.matches()) continue;
                    if (regex.indexOf("^.{") == 0 && regex.endsWith("}$")) {
                        sb.append("\u5b57\u6bb5" + ((Field)field).getName() + "\u957f\u5ea6\u9650\u5236\u4e3a" + AnnotationUtil.subString(regex, "{", ",") + "-" + AnnotationUtil.subString(regex, ",", "}") + "|");
                    } else {
                        sb.append("\u5b57\u6bb5" + ((Field)field).getName() + "\u683c\u5f0f\u9519\u8bef|");
                    }
                    flag = true;
                    continue;
                }
                if (!(annotation instanceof NotEmpty)) continue;
                Object oValue = ((Field)field).get(obj);
                if (oValue == null) {
                    sb.append("\u5b57\u6bb5" + ((Field)field).getName() + "\u4e0d\u80fd\u4e3anull|");
                    flag = true;
                    continue;
                }
                if (oValue instanceof String) {
                    String value = (String)oValue;
                    if (!StringUtils.isBlank((CharSequence)value)) continue;
                    sb.append("\u5b57\u6bb5" + ((Field)field).getName() + "\u4e0d\u80fd\u4e3a\u7a7a|");
                    flag = true;
                    continue;
                }
                logger.info("\u5b57\u6bb5" + ((Field)field).getName() + "\u4e0d\u662f\u5b57\u7b26\u4e32\uff0c\u4e0d\u80fd\u5224\u65ad\u662f\u5426\u4e3a\u7a7a");
            }
            catch (Exception e) {
                sb.append(e.getMessage());
                flag = true;
                logger.error("\u89e3\u6790\u6ce8\u89e3\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
        if (flag) {
            return sb.toString();
        }
        return null;
    }

    private static String parseNotBlankAnnotation(Class<? extends Annotation> aClazz, Object obj, boolean hasParent) {
        Object[] fields;
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        Class<?> clazz = obj.getClass();
        Object[] bothField = fields = clazz.getDeclaredFields();
        if (hasParent) {
            Class<?> superClazz = clazz.getSuperclass();
            Object[] superFields = superClazz.getDeclaredFields();
            bothField = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])superFields);
        }
        for (Object field : bothField) {
            Annotation annotation = ((Field)field).getAnnotation(aClazz);
            if (annotation == null) continue;
            ((Field)field).setAccessible(true);
            try {
                if (!(annotation instanceof NotBlank)) continue;
                NotBlank blankAnnotation = (NotBlank)annotation;
                Object oValue = ((Field)field).get(obj);
                if (oValue == null) {
                    AnnotationUtil.appendValue(sb, blankAnnotation);
                    flag = true;
                    continue;
                }
                if (oValue instanceof String) {
                    String value = (String)oValue;
                    if (!StringUtils.isBlank((CharSequence)value)) continue;
                    AnnotationUtil.appendValue(sb, blankAnnotation);
                    flag = true;
                    continue;
                }
                logger.info(blankAnnotation.value());
            }
            catch (Exception e) {
                sb.append(e.getMessage());
                flag = true;
                logger.error("\u89e3\u6790\u6ce8\u89e3\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            sb.append("\u3002");
        }
        if (flag) {
            return sb.toString();
        }
        return null;
    }

    private static String parseContainsValueAnnotation(Class<? extends Annotation> aClazz, Object obj, boolean hasParent) {
        Object[] fields;
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        Class<?> clazz = obj.getClass();
        Object[] bothField = fields = clazz.getDeclaredFields();
        if (hasParent) {
            Class<?> superClazz = clazz.getSuperclass();
            Object[] superFields = superClazz.getDeclaredFields();
            bothField = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])superFields);
        }
        for (Object field : bothField) {
            Annotation annotation = ((Field)field).getAnnotation(aClazz);
            if (annotation == null) continue;
            ((Field)field).setAccessible(true);
            try {
                HashSet set;
                if (!(annotation instanceof ContainsValue)) continue;
                ContainsValue defaultValue = (ContainsValue)annotation;
                Object oValue = ((Field)field).get(obj);
                if (((Field)field).getType() != String.class) continue;
                String value = (String)oValue;
                String v = defaultValue.value();
                HashSet<Object> hashSet = set = v == null ? new HashSet() : new HashSet<String>(Arrays.asList(v.split(",")));
                if (set.contains(value)) continue;
                AnnotationUtil.appendValue(sb, defaultValue);
            }
            catch (Exception e) {
                sb.append(e.getMessage());
                flag = true;
                logger.error("\u89e3\u6790\u6ce8\u89e3\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            sb.append("\u3002");
        }
        if (flag) {
            return sb.toString();
        }
        return null;
    }

    private static void parseDefaultValueAnnotation(Class<? extends Annotation> aClazz, Object obj, boolean hasParent) {
        Class<?> clazz = obj.getClass();
        Object[] fields = clazz.getDeclaredFields();
        Object[] methods = clazz.getDeclaredMethods();
        Object[] bothField = fields;
        Object[] bothMethods = methods;
        if (hasParent) {
            Class<?> superClazz = clazz.getSuperclass();
            Object[] superFields = superClazz.getDeclaredFields();
            bothField = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])superFields);
            Object[] superMethods = superClazz.getDeclaredMethods();
            bothMethods = (Method[])ArrayUtils.addAll((Object[])methods, (Object[])superMethods);
        }
        for (Object field : bothField) {
            Annotation annotation = ((Field)field).getAnnotation(aClazz);
            if (annotation == null) continue;
            ((Field)field).setAccessible(true);
            try {
                Method method;
                String name;
                Object value;
                if (!(annotation instanceof DefaultValue)) continue;
                DefaultValue defaultValue = (DefaultValue)annotation;
                Object oValue = ((Field)field).get(obj);
                if (((Field)field).getType() == String.class) {
                    String v;
                    value = (String)oValue;
                    if (!StringUtils.isBlank((CharSequence)value) || !StringUtils.isNotBlank((CharSequence)(v = defaultValue.value()))) continue;
                    name = AnnotationUtil.parSetName(((Field)field).getName());
                    method = clazz.getMethod(name, String.class);
                    method.invoke(obj, v);
                    continue;
                }
                if (((Field)field).getType() == Integer.class) {
                    value = (Integer)oValue;
                    if (null != value) continue;
                    int v = defaultValue.num();
                    name = AnnotationUtil.parSetName(((Field)field).getName());
                    method = clazz.getMethod(name, Integer.class);
                    method.invoke(obj, v);
                    continue;
                }
                if (((Field)field).getType() != Date.class || null != (value = (Date)oValue)) continue;
                String name2 = AnnotationUtil.parSetName(((Field)field).getName());
                Method method2 = clazz.getMethod(name2, Date.class);
                method2.invoke(obj, new Date());
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u6ce8\u89e3\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
    }

    public static String parSetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_') {
            startIndex = 1;
        }
        return "set" + fieldName.substring(startIndex, startIndex + 1).toUpperCase() + fieldName.substring(startIndex + 1);
    }

    private static void appendValue(StringBuilder sb, NotBlank annotation) {
        if (StringUtils.isBlank((CharSequence)sb.toString())) {
            sb.append(annotation.value());
        } else {
            sb.append("\uff1b" + annotation.value());
        }
    }

    private static void appendValue(StringBuilder sb, ContainsValue annotation) {
        if (StringUtils.isBlank((CharSequence)sb.toString())) {
            sb.append(annotation.value());
        } else {
            sb.append("\uff1b" + annotation.value());
        }
    }

    public static Integer versionConvert(String version) {
        version = version != null ? version : "2.0.0";
        Integer v = Integer.parseInt(version.replace(".", ""));
        return v;
    }

    public static String subString(String str, String strStart, String strEnd) {
        int strStartIndex = str.indexOf(strStart);
        int strEndIndex = str.indexOf(strEnd);
        if (strStartIndex < 0) {
            return "\u5b57\u7b26\u4e32 :---->" + str + "<---- \u4e2d\u4e0d\u5b58\u5728 " + strStart + ", \u65e0\u6cd5\u622a\u53d6\u76ee\u6807\u5b57\u7b26\u4e32";
        }
        if (strEndIndex < 0) {
            return "\u5b57\u7b26\u4e32 :---->" + str + "<---- \u4e2d\u4e0d\u5b58\u5728 " + strEnd + ", \u65e0\u6cd5\u622a\u53d6\u76ee\u6807\u5b57\u7b26\u4e32";
        }
        String result = str.substring(strStartIndex, strEndIndex).substring(strStart.length());
        return result;
    }
}

