/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util.doc.enums;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;

public enum DocTypeAlias {
    _BYTE(Byte.TYPE, "int"),
    _SHORT(Short.TYPE, "int"),
    _INT(Integer.TYPE, "int"),
    _LONG(Long.TYPE, "int"),
    _FLOAT(Float.TYPE, "int"),
    _DOUBLE(Double.TYPE, "int"),
    _BOOLEAN(Boolean.TYPE, "int"),
    _CHAR(Character.TYPE, "string"),
    BYTE(Byte.class, "int"),
    SHORT(Short.class, "int"),
    INTEGER(Integer.class, "int"),
    LONG(Long.class, "int"),
    FLOAT(Float.class, "float"),
    DOUBLE(Double.class, "float"),
    BIGDECIMAL(BigDecimal.class, "float"),
    BOOLEAN(Boolean.class, "boolean"),
    CHARACTER(Character.class, "string"),
    STRING(String.class, "string"),
    DATE(Date.class, "date");

    private Class<?> javaType;
    private String typeAlias;

    private DocTypeAlias(Class<?> javaType, String typeAlias) {
        this.javaType = javaType;
        this.typeAlias = typeAlias;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class javaType) {
        this.javaType = javaType;
    }

    public String getTypeAlias() {
        return this.typeAlias;
    }

    public void setTypeAlias(String typeAlias) {
        this.typeAlias = typeAlias;
    }

    public static String getAlias(Class<?> clz) throws Exception {
        for (DocTypeAlias docTypeAlias : DocTypeAlias.values()) {
            if (clz != docTypeAlias.getJavaType()) continue;
            return docTypeAlias.getTypeAlias();
        }
        if (Collection.class.isAssignableFrom(clz)) {
            return "array";
        }
        return "object";
    }

    public static boolean containsJavaType(Class<?> clz) {
        for (DocTypeAlias docTypeAlias : DocTypeAlias.values()) {
            if (clz != docTypeAlias.getJavaType()) continue;
            return true;
        }
        return false;
    }
}

