/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util.datx;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public class Util {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");

    public static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static long bytesToLong(byte a, byte b, byte c, byte d) {
        return Util.int2long((a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF);
    }

    private static int str2Ip(String ip) {
        String[] ss = ip.split("\\.");
        int a = Integer.parseInt(ss[0]);
        int b = Integer.parseInt(ss[1]);
        int c = Integer.parseInt(ss[2]);
        int d = Integer.parseInt(ss[3]);
        return a << 24 | b << 16 | c << 8 | d;
    }

    public static int str2Ip2(String ip) {
        try {
            byte[] bytes = InetAddress.getByName(ip).getAddress();
            return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3];
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static long ip2long(String ip) {
        return Util.int2long(Util.str2Ip(ip));
    }

    private static long int2long(int i) {
        long l = (long)i & Integer.MAX_VALUE;
        if (i < 0) {
            l |= 0x80000000L;
        }
        return l;
    }
}

