/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util.datx;

import com.ellabook.util.datx.IPv4FormatException;
import com.ellabook.util.datx.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

public class City {
    private byte[] data;
    private long indexSize;

    public City(String name) throws IOException {
        Path path = Paths.get(name, new String[0]);
        this.data = Files.readAllBytes(path);
        this.indexSize = Util.bytesToLong(this.data[0], this.data[1], this.data[2], this.data[3]);
    }

    private City(byte[] data, long indexSize) {
        this.data = data;
        this.indexSize = indexSize;
    }

    public static City newInstance(String name) throws IOException {
        ClassPathResource resource = new ClassPathResource(name);
        InputStream inputStream = resource.getInputStream();
        byte[] data = IOUtils.toByteArray((InputStream)inputStream);
        long indexSize = Util.bytesToLong(data[0], data[1], data[2], data[3]);
        return new City(data, indexSize);
    }

    public String[] find(String ips) throws IPv4FormatException {
        if (!Util.isIPv4Address(ips)) {
            throw new IPv4FormatException();
        }
        long val = Util.ip2long(ips);
        int start = 262148;
        int low = 0;
        int mid = 0;
        int high = new Long((this.indexSize - 262144L - 262148L) / 9L).intValue() - 1;
        int pos = 0;
        while (low <= high) {
            long end;
            mid = new Double((low + high) / 2).intValue();
            pos = mid * 9;
            long s = 0L;
            if (mid > 0) {
                int pos1 = (mid - 1) * 9;
                s = Util.bytesToLong(this.data[start + pos1], this.data[start + pos1 + 1], this.data[start + pos1 + 2], this.data[start + pos1 + 3]);
            }
            if (val > (end = Util.bytesToLong(this.data[start + pos], this.data[start + pos + 1], this.data[start + pos + 2], this.data[start + pos + 3]))) {
                low = mid + 1;
                continue;
            }
            if (val < s) {
                high = mid - 1;
                continue;
            }
            byte b = 0;
            long off = Util.bytesToLong(b, this.data[start + pos + 6], this.data[start + pos + 5], this.data[start + pos + 4]);
            long len = Util.bytesToLong(b, b, this.data[start + pos + 7], this.data[start + pos + 8]);
            int offset = new Long(off - 262144L + this.indexSize).intValue();
            byte[] loc = Arrays.copyOfRange(this.data, offset, offset + new Long(len).intValue());
            return new String(loc, Charset.forName("UTF-8")).split("\t", -1);
        }
        return null;
    }
}

