/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import com.ellabook.entity.AccessToken;
import com.ellabook.entity.business.KeyNote;
import com.ellabook.entity.business.NoticeMessage;
import com.ellabook.util.DateUtil;
import com.ellabook.util.HttpConnectUtil;
import com.ellabook.util.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinUtil {
    private static Logger log = LoggerFactory.getLogger(WeiXinUtil.class);
    public static final String access_token_url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={appid}&secret={secret}";
    public static String uploadTempMaterial_url = "https://api.weixin.qq.com/cgi-bin/media/upload?access_token=ACCESS_TOKEN&type=TYPE";

    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (null != outputStr) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            jsonObject = JSONObject.fromObject((Object)buffer.toString());
        }
        catch (ConnectException ce) {
            log.error("Weixin server connection timed out.");
        }
        catch (Exception e) {
            log.error("https request error:{}", (Throwable)e);
        }
        return jsonObject;
    }

    public static String httpRequest(String requestUrl, File file) {
        StringBuffer buffer = new StringBuffer();
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
            httpUrlConn.setDoInput(true);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestProperty("Connection", "Keep-Alive");
            httpUrlConn.setRequestProperty("Charset", "UTF-8");
            String BOUNDARY = "----------" + System.currentTimeMillis();
            httpUrlConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            StringBuilder sb = new StringBuilder();
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"media\";filelength=\"" + file.length() + "\";filename=\"" + file.getName() + "\"\r\n");
            sb.append("Content-Type:application/octet-stream\r\n\r\n");
            byte[] head = sb.toString().getBytes("utf-8");
            DataOutputStream outputStream = new DataOutputStream(httpUrlConn.getOutputStream());
            ((OutputStream)outputStream).write(head);
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                ((OutputStream)outputStream).write(bufferOut, 0, bytes);
            }
            in.close();
            byte[] foot = ("\r\n--" + BOUNDARY + "--\r\n").getBytes("utf-8");
            ((OutputStream)outputStream).write(foot);
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
        }
        catch (IOException e) {
            System.out.println("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static String httpRequest(String requestUrl) {
        StringBuffer buffer = new StringBuffer();
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
            httpUrlConn.setDoOutput(false);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod("GET");
            httpUrlConn.connect();
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer.toString();
    }

    public static AccessToken getAccessToken(String appid, String appsecret) {
        AccessToken accessToken = null;
        String requestUrl = access_token_url.replace("{appid}", appid).replace("{secret}", appsecret);
        JSONObject jsonObject = WeiXinUtil.httpRequest(requestUrl, "GET", null);
        if (null != jsonObject) {
            try {
                accessToken = new AccessToken();
                accessToken.setToken(jsonObject.getString("access_token"));
                accessToken.setExpiresIn(jsonObject.getInt("expires_in"));
            }
            catch (JSONException e) {
                accessToken = null;
                log.error("\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}", (Object)jsonObject.getInt("errcode"), (Object)jsonObject.getString("errmsg"));
            }
        }
        return accessToken;
    }

    public static Map<String, Object> getWxConfig(HttpServletRequest request) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String appId = "wxa0064ea657f80062";
        String secret = "fcc960840df869ad1a46af7993784917";
        String requestUrl = request.getRequestURL().toString();
        String access_token = "";
        String jsapi_ticket = "";
        String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
        String nonceStr = UUID.randomUUID().toString();
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + appId + "&secret=" + secret;
        JSONObject json = WeiXinUtil.httpRequest(url, "GET", null);
        System.out.println(" \u83b7\u53d6access_token " + json);
        if (json != null) {
            access_token = json.getString("access_token");
            url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + access_token + "&type=jsapi";
            json = WeiXinUtil.httpRequest(url, "GET", null);
            System.out.println("jsapi_ticket " + json);
            if (json != null) {
                jsapi_ticket = json.getString("ticket");
            }
        }
        String signature = "";
        String sign = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + requestUrl;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(sign.getBytes("UTF-8"));
            signature = WeiXinUtil.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ret.put("appId", appId);
        ret.put("timestamp", timestamp);
        ret.put("nonceStr", nonceStr);
        ret.put("signature", signature);
        return ret;
    }

    public static Map<String, String> uploadTempMaterial(String accessToken, String type, String fileUrl) {
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(fileUrl);
        String fileName = file.getName();
        uploadTempMaterial_url = uploadTempMaterial_url.replace("ACCESS_TOKEN", accessToken).replace("TYPE", type);
        String result = WeiXinUtil.httpRequest(uploadTempMaterial_url, file);
        result = result.replaceAll("[\\\\]", "");
        System.out.println("result:" + result);
        JSONObject resultJSON = JSONObject.fromObject((Object)result);
        if (resultJSON != null) {
            if (resultJSON.get("media_id") != null) {
                System.out.println("\u4e0a\u4f20" + type + "\u6c38\u4e45\u7d20\u6750\u6210\u529f");
                map.put("fileName", fileName);
                map.put("media_id", resultJSON.get("media_id").toString());
                return map;
            }
            System.out.println("\u4e0a\u4f20" + type + "\u6c38\u4e45\u7d20\u6750\u5931\u8d25");
        }
        return null;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public static boolean checkSignature(String token, String signature, String timestamp, String nonce) {
        Object[] arr = new String[]{token, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            content.append((String)arr[i]);
        }
        MessageDigest md = null;
        String tmpStr = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            tmpStr = WeiXinUtil.byteToStr(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        content = null;
        return tmpStr != null ? tmpStr.equals(signature.toUpperCase()) : false;
    }

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = strDigest + WeiXinUtil.byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }

    public static String getEllaPartnerAccessToken() {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("grant_type", "client_credential");
        param.put("appid", "wxca187025bd70cab8");
        param.put("secret", "8ea56b893801ae7b02868f3769e9fe4d");
        String token = HttpConnectUtil.getConnectionJsonResponse("https://api.weixin.qq.com/cgi-bin/token", param, "POST");
        com.alibaba.fastjson.JSONObject json = com.alibaba.fastjson.JSONObject.parseObject((String)token);
        return json.getString("access_token");
    }

    public static String getBusinessAccessToken() {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("grant_type", "client_credential");
        param.put("appid", "wxca187025bd70cab8");
        param.put("secret", "8ea56b893801ae7b02868f3769e9fe4d");
        String token = HttpConnectUtil.getConnectionJsonResponse("https://api.weixin.qq.com/cgi-bin/token", param, "POST");
        com.alibaba.fastjson.JSONObject json = com.alibaba.fastjson.JSONObject.parseObject((String)token);
        return json.getString("access_token");
    }

    public static String buildMessage(String openid, String income, String totalIncome, String type) {
        NoticeMessage message = new NoticeMessage();
        message.setTouser(openid);
        message.setTemplate_id("wBspZdoJlM-iXhWY8-xySQCe9O3WH9XLsu3luVuPCRM");
        message.setUrl("");
        message.setData(WeiXinUtil.buildData(income, totalIncome, type));
        return com.alibaba.fastjson.JSONObject.toJSONString((Object)message);
    }

    public static String buildMessage(String openid, String templateId, String url, Map<String, KeyNote> data) {
        NoticeMessage message = new NoticeMessage();
        message.setTouser(openid);
        message.setTemplate_id(templateId);
        message.setUrl(url);
        message.setData(data);
        return com.alibaba.fastjson.JSONObject.toJSONString((Object)message);
    }

    public static Map buildData(String income, String totalIncome, String type) {
        HashMap<String, KeyNote> map = new HashMap<String, KeyNote>();
        map.put("first", WeiXinUtil.buildFirst(type));
        map.put("keyword1", WeiXinUtil.buildKeynote1());
        map.put("keyword2", WeiXinUtil.buildKeynote2(income));
        map.put("keyword3", WeiXinUtil.buildKeynote3());
        map.put("remark", WeiXinUtil.buildRemark(totalIncome));
        return map;
    }

    public static Map<String, KeyNote> buildData(KeyNote first, KeyNote remark, KeyNote ... keyWords) {
        HashMap<String, KeyNote> map = new HashMap<String, KeyNote>();
        map.put("first", first);
        map.put("remark", remark);
        for (int i = 0; i < keyWords.length; ++i) {
            map.put("keyword" + (i + 1), keyWords[i]);
        }
        return map;
    }

    public static KeyNote buildFirst(String type) {
        KeyNote first = new KeyNote();
        if ("income".equals(type)) {
            first.setValue("\u60a8\u83b7\u5f97\u4e86\u4e00\u7b14\u6536\u76ca");
        } else {
            first.setValue("\u60a8\u4eca\u5929\u7684\u6536\u76ca");
        }
        first.setColor("#173177");
        return first;
    }

    public static KeyNote buildKeynote1() {
        KeyNote keyNote = new KeyNote();
        keyNote.setValue("\u6536\u5165");
        keyNote.setColor("#173177");
        return keyNote;
    }

    public static KeyNote buildKeynote2(String income) {
        KeyNote keyNote = new KeyNote();
        keyNote.setValue(income);
        keyNote.setColor("#173177");
        return keyNote;
    }

    public static KeyNote buildKeynote3() {
        KeyNote keyNote = new KeyNote();
        keyNote.setValue(DateUtil.dateFormat(new Date()));
        keyNote.setColor("#173177");
        return keyNote;
    }

    public static KeyNote buildRemark(String total) {
        KeyNote remark = new KeyNote();
        remark.setValue("\u60a8\u7684\u603b\u6536\u76ca:" + total + "\u5143");
        remark.setColor("#173177");
        return remark;
    }

    public static void main(String[] args) {
        String accessToken = WeiXinUtil.getEllaPartnerAccessToken();
        String body = HttpConnectUtil.getConnectionFromBody("https://api.weixin.qq.com/cgi-bin/user/get?access_token=" + accessToken, null, "GET");
        System.out.println(body);
    }
}

